/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.nativeImpl.time;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DateUtil {
    private static final Map<Pattern, String> ISOWithTimeZoneOrNonISO = DateUtil.initialize_ISOWithTimeZoneOrNonISO();
    private static final Map<Pattern, String> ISO8601USEUTCListMatcher = DateUtil.initialize_ISO8601USEUTCListMatcher();

    private static final Map<Pattern, String> initialize_ISOWithTimeZoneOrNonISO() {
        HashMap<Pattern, String> ISOWithTimeZoneOrNonISO = new HashMap<Pattern, String>();
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}\\s(\\+|\\-)(\\d{4}|\\d{2}:\\d{2})$"), "%a, %d %b %Y %H:%M:%S %Z");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}\\s(\\+|\\-)(\\d{4}|\\d{2}:\\d{2})$"), "%a, %d %b %y %H:%M:%S %Z");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}\\s(\\+|\\-)(\\d{4}|\\d{2}:\\d{2})$"), "%a, %d %b %Y %H:%M %Z");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}\\s(\\+|\\-)(\\d{4}|\\d{2}:\\d{2})$"), "%a, %d %b %y %H:%M %Z");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}\\s(\\+|\\-)(\\d{4}|\\d{2}:\\d{2})$"), "%d %b %Y %H:%M:%S %Z");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}\\s(\\+|\\-)(\\d{4}|\\d{2}:\\d{2})$"), "%d %b %y %H:%M:%S %Z");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}\\s(\\+|\\-)(\\d{4}|\\d{2})$"), "%d %b %Y %H:%M %Z");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}\\s(\\+|\\-)(\\d{4}|\\d{2})$"), "%d %b %y %H:%M %Z");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$"), "%a, %d %b %Y %H:%M:%S");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$"), "%a, %d %b %y %H:%M:%S");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}$"), "%a, %d %b %Y %H:%M");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}$"), "%a, %d %b %y %H:%M");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}$"), "%a, %d %b %Y");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}$"), "%a, %d %b %y");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$"), "%d %b %Y %H:%M:%S");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$"), "%d %b %y %H:%M:%S");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}$"), "%d %b %Y %H:%M");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}$"), "%d %b %y %H:%M");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}$"), "%d %b %Y");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}$"), "%d %b %y");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}(\\+|\\-)(\\d{4}|\\d{2}:\\d{2})$"), "%Y-%m-%dT%H:%M%Z");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}:\\d{2}(\\+|\\-)(\\d{4}|\\d{2}:\\d{2})$"), "%Y-%m-%dT%H:%M:%S%Z");
        ISOWithTimeZoneOrNonISO.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}:\\d{2}.\\d{1,3}(\\+|\\-)((\\d{4})|(\\d{2}:\\d{2}))$"), "%Y-%m-%dT%H:%M:%S.%L%Z");
        return ISOWithTimeZoneOrNonISO;
    }

    private static final Map<Pattern, String> initialize_ISO8601USEUTCListMatcher() {
        HashMap<Pattern, String> ISO8601USEUTCListMatcher = new HashMap<Pattern, String>();
        ISO8601USEUTCListMatcher.put(Pattern.compile("^\\d{4}$"), "%Y");
        ISO8601USEUTCListMatcher.put(Pattern.compile("^\\d{4}-\\d{1,2}$"), "%Y-%m");
        ISO8601USEUTCListMatcher.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}$"), "%Y-%m-%d");
        ISO8601USEUTCListMatcher.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}$"), "%Y-%m-%dT%H:%M");
        ISO8601USEUTCListMatcher.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}:\\d{2}$"), "%Y-%m-%dT%H:%M:%S");
        ISO8601USEUTCListMatcher.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}:\\d{2}.\\d{1,3}$"), "%Y-%m-%dT%H:%M:%S.%L");
        return ISO8601USEUTCListMatcher;
    }

    public static String determineDateFormat(String dateString) {
        for (Map.Entry<Pattern, String> entry : ISOWithTimeZoneOrNonISO.entrySet()) {
            if (!entry.getKey().matcher(dateString).matches()) continue;
            return entry.getValue();
        }
        for (Map.Entry<Pattern, String> entry : ISO8601USEUTCListMatcher.entrySet()) {
            if (!entry.getKey().matcher(dateString).matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean isUTC(String dateString) {
        for (Map.Entry<Pattern, String> entry : ISO8601USEUTCListMatcher.entrySet()) {
            if (!entry.getKey().matcher(dateString).matches()) continue;
            return true;
        }
        return false;
    }
}

