/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.nativeImpl.timer;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.context.RaveOperationalMode;
import com.ibm.vida.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.vida.rave.core.nativeImpl.timer.TimerEventWithExceptionHandling;

@FunctionClass(value="addEvent")
public class Timer {
    public static Timer INSTANCE = new Timer();
    private static double nextEventId = 0.0;
    public static final long FRAME_RATE = 15L;
    protected final QueueItem head;
    protected QueueItem tail;
    protected long time;
    private final Thread timerThread;
    private final Runnable timerThreadRunnable;

    public static double newEventId() {
        double d = nextEventId;
        nextEventId = d + 1.0;
        return d;
    }

    public Timer() {
        this.tail = this.head = new QueueItem(null, 0.0, 0.0, -1.0);
        this.timerThreadRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    QueueItem last = null;
                    try {
                        long now;
                        QueueItem queueItem = Timer.this.head;
                        synchronized (queueItem) {
                            if (Timer.this.head.next == null) {
                                Timer.this.head.wait();
                            }
                            last = Timer.this.tail;
                        }
                        Timer.this.time = now = System.currentTimeMillis();
                        QueueItem item = Timer.this.head.next;
                        while (item != null) {
                            if (item.paused) {
                                long increasedTime = item.previousTickTime - now;
                                item.execTime += (double)increasedTime;
                                item.time += (double)increasedTime;
                            }
                            item.previousTickTime = now;
                            if ((double)now >= item.execTime) {
                                block24: {
                                    if (!item.running) {
                                        item.running = true;
                                    }
                                    try {
                                        item.complete = item.callback.run((double)now - item.time);
                                    }
                                    catch (Throwable e) {
                                        item.complete = true;
                                        if (!(item.callback instanceof TimerEventWithExceptionHandling)) break block24;
                                        ((TimerEventWithExceptionHandling)item.callback).handleException(e);
                                    }
                                }
                                if (!item.complete) {
                                    double delay = item.delay <= 0.0 ? 15.0 : item.delay;
                                    double frameDelay = delay - (double)(System.currentTimeMillis() - now);
                                    item.execTime = frameDelay > 0.0 ? (double)now + frameDelay : (double)now;
                                }
                            }
                            if (item == last) break;
                            item = item.next;
                        }
                        long newNow = System.currentTimeMillis();
                        QueueItem queueItem2 = Timer.this.head;
                        synchronized (queueItem2) {
                            double smallestDelayTime = Double.MAX_VALUE;
                            QueueItem previousItem = Timer.this.head;
                            item = Timer.this.head.next;
                            while (item != null) {
                                if (item.complete) {
                                    previousItem.next = item.next;
                                } else {
                                    double delay;
                                    previousItem = item;
                                    if (smallestDelayTime > 0.0 && (delay = item.execTime - (double)newNow) < smallestDelayTime) {
                                        smallestDelayTime = delay;
                                    }
                                }
                                item = item.next;
                            }
                            if (Timer.this.head.next != null) {
                                Timer.this.tail = previousItem;
                                if (smallestDelayTime > 1.0) {
                                    Timer.this.head.wait((long)smallestDelayTime);
                                }
                            } else {
                                Timer.this.tail = Timer.this.head;
                            }
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        if (RaveOperationalMode.MODE != 1) {
            this.timerThread = new Thread(this.timerThreadRunnable, "RaveTimer");
            this.timerThread.start();
        } else {
            this.timerThread = null;
        }
    }

    public void addEvent(TimerEvent callback) {
        this.addEvent(callback, 0.0);
    }

    public void addEvent(TimerEvent callback, double delay) {
        this.addEvent(callback, delay, System.currentTimeMillis());
    }

    public void addEvent(TimerEvent callback, double delay, double start) {
        this.addEvent(callback, delay, start, -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(TimerEvent callback, double delay, double start, double id) {
        QueueItem queueItem = this.head;
        synchronized (queueItem) {
            this.tail = this.tail.next = new QueueItem(callback, delay, start, id);
            this.head.notify();
        }
    }

    public void pauseDelayedTasks(ArrayEx<Double> _arrIds, boolean _paused) {
        QueueItem item = this.head.next;
        while (item != null) {
            if (!item.running && _arrIds.contains(item.id)) {
                item.paused = _paused;
            }
            if (item == this.tail) break;
            item = item.next;
        }
    }

    public void triggerDelayedTasks(ArrayEx<Double> _arrIds) {
        QueueItem item = this.head.next;
        while (item != null) {
            if (!item.running && _arrIds.contains(item.id)) {
                item.paused = false;
                item.time = System.currentTimeMillis();
            }
            if (item == this.tail) break;
            item = item.next;
        }
        this.flush();
    }

    public boolean isTimerThread() {
        return Thread.currentThread() == this.timerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        QueueItem queueItem = this.head;
        synchronized (queueItem) {
            this.head.notify();
        }
    }

    public double currentTime() {
        return this.time;
    }

    protected static class QueueItem {
        public double time;
        public final double delay;
        public final TimerEvent callback;
        public final double id;
        public boolean complete;
        public boolean paused;
        public boolean running;
        public double execTime;
        public long previousTickTime;
        public QueueItem next;

        QueueItem(TimerEvent callback, double delay, double start, double id) {
            this.callback = callback;
            this.delay = delay;
            this.time = start + delay;
            this.id = id;
            this.paused = false;
            this.running = false;
            this.execTime = this.time;
            this.previousTickTime = 0L;
        }
    }
}

