/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.nativeImpl.util;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.nativeImpl.time.Date;
import com.ibm.vida.rave.core.time.IDate;
import java.util.Arrays;
import java.util.List;

public class ObjectConverter {
    public static boolean isNaN(Object o) {
        return Double.isNaN(ObjectConverter.toDouble(o));
    }

    public static double toDouble(double d) {
        return d;
    }

    public static double toDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof java.util.Date) {
            return ((java.util.Date)o).getTime();
        }
        if (o instanceof IDate) {
            return ((IDate)o).getTime();
        }
        String s = o.toString();
        if (!s.isEmpty()) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        return 0.0;
    }

    public static IDate toDate(Object date) {
        if (date instanceof java.util.Date) {
            return new Date(((java.util.Date)date).getTime());
        }
        if (date instanceof IDate) {
            return (IDate)date;
        }
        if (date instanceof Number) {
            return new Date(ObjectConverter.toLong(date));
        }
        if (date instanceof String) {
            return new Date((String)date);
        }
        return new Date("");
    }

    public static Double[] toDouble(Object[] array) {
        Double[] arr = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            arr[i] = ObjectConverter.toDouble(array[i]);
        }
        return arr;
    }

    public static int toNumber(boolean b) {
        return b ? 1 : 0;
    }

    public static String toString(Object obj) {
        if (obj instanceof Number) {
            Number num = (Number)obj;
            if (num.doubleValue() == (double)num.longValue()) {
                num = num.longValue();
            }
            return String.valueOf(num);
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj == null) {
            return "null";
        }
        if (obj instanceof List || Lang.isArray(obj)) {
            StringBuilder result = new StringBuilder();
            List<Object> array = obj instanceof List ? (List<Object>)obj : Arrays.asList((Object[])obj);
            for (int i = 0; i < array.size(); ++i) {
                if (i != 0) {
                    result.append(',');
                }
                result.append(ObjectConverter.toString(array.get(i)));
            }
            return result.toString();
        }
        return obj.toString();
    }

    public static long toLong(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof java.util.Date) {
            return ((java.util.Date)o).getTime();
        }
        if (o instanceof IDate) {
            return ((IDate)o).getTime();
        }
        return (long)ObjectConverter.toDouble(o);
    }

    public static <T extends Number> ArrayEx<Object> numberArrayAsObjectArray(List<T> range) {
        ArrayEx<Object> objects = new ArrayEx<Object>();
        for (int i = 0; i < range.size(); ++i) {
            objects.add(range.get(i));
        }
        return objects;
    }

    public static <T extends Number> ArrayEx<Integer> numberArrayAsIntegerArray(List<T> range) {
        ArrayEx<Integer> ints = new ArrayEx<Integer>();
        for (int index = 0; index < range.size(); ++index) {
            ints.add(ObjectConverter.asInteger(range.get(index)));
        }
        return ints;
    }

    public static <T extends Number> ArrayEx<Double> numberArrayAsDoubleArray(List<T> range) {
        ArrayEx<Double> doubles = new ArrayEx<Double>();
        for (int index = 0; index < range.size(); ++index) {
            doubles.add(ObjectConverter.asDouble(range.get(index)));
        }
        return doubles;
    }

    public static int toInt(Object o) {
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof java.util.Date) {
            return (int)ObjectConverter.toDouble(((java.util.Date)o).getTime());
        }
        if (o instanceof IDate) {
            return (int)ObjectConverter.toDouble(((IDate)o).getTime());
        }
        return (int)ObjectConverter.toDouble(o);
    }

    public static <T> ArrayEx<T> listToArray(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list instanceof ArrayEx) {
            return (ArrayEx)list;
        }
        ArrayEx<T> objects = new ArrayEx<T>();
        for (int i = 0; i < list.size(); ++i) {
            objects.add(list.get(i));
        }
        return objects;
    }

    public static boolean toBoolean(double val) {
        return val != 0.0 && !Double.isNaN(val);
    }

    public static boolean toBoolean(Number val) {
        return val != null && val.doubleValue() != 0.0 && !Double.isNaN(val.doubleValue());
    }

    public static boolean toBoolean(Object obj) {
        if (obj instanceof Number) {
            return ObjectConverter.toBoolean((Number)obj);
        }
        if (obj instanceof String) {
            return ((String)obj).length() > 0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return obj != null;
    }

    public static Double asDouble(Object d) {
        if (d == null) {
            return null;
        }
        return ObjectConverter.toDouble(d);
    }

    public static String asString(Object s) {
        if (s == null) {
            return null;
        }
        return ObjectConverter.toString(s);
    }

    public static Integer asInteger(Object d) {
        if (d == null) {
            return null;
        }
        return ObjectConverter.toInt(d);
    }
}

