/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.nativeImpl.xhr;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.event.Dispatcher;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.nativeImpl.xhr.XhrRunnable;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrResponse;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrResult;
import com.ibm.vida.rave.core.selector.RunFunction;

public class Xhr<A> {
    private final XhrRunnable runnable;
    private final OMap<String, String> headers = new OMap();
    private String mimeType;
    Callback<A> userCallback = new Callback<A>(){

        @Override
        public void callback(XhrResult error, A response) {
            Xhr.this.respond(error, response);
        }
    };
    private final XhrResponse<A> _response;
    private String _data;
    private final Dispatcher<Xhr<A>> dispatcher;
    public static final String GET = "GET";
    private static final String POST = "POST";
    private static final String BEFORESEND = "beforesend";
    private static final String PROGRESS = "progress";
    private static final String LOAD = "load";
    private static final String ERROR = "error";
    private final Callback<XhrResult> runnableCallback = new Callback<XhrResult>(){

        @Override
        public void callback(XhrResult error, XhrResult request) {
            if (error != null) {
                Xhr.this.userCallback.callback(error, null);
            } else {
                Object value = null;
                try {
                    value = Xhr.this._response.getValue(request);
                }
                catch (Exception e) {
                    request.message = request.statusText = e.getMessage();
                    Xhr.this.userCallback.callback(request, null);
                    return;
                }
                Xhr.this.userCallback.callback(null, value);
            }
        }
    };

    Xhr(String url, String mimeType, XhrResponse<A> response, Callback<A> callback) {
        this._response = response;
        this.mimeType = mimeType;
        if (callback != null) {
            this.userCallback = callback;
        }
        this.dispatcher = Rave.dispatch(BEFORESEND, PROGRESS, LOAD, ERROR);
        this.runnable = new XhrRunnable(url, this.runnableCallback);
        this.runnable.start();
    }

    public Xhr<A> get(Callback<A> requestCallback) {
        this.send(GET, this._data, requestCallback);
        return this;
    }

    void respond(XhrResult error, A response) {
        if (error != null) {
            ((Dispatcher.DispatcherEvent)this.dispatcher.get(ERROR)).fire(this, error);
        } else if (response != null) {
            ((Dispatcher.DispatcherEvent)this.dispatcher.get(LOAD)).fire(this, response);
        } else {
            ((Dispatcher.DispatcherEvent)this.dispatcher.get(PROGRESS)).fire(this, response);
        }
    }

    public Xhr<A> post(String postData, Callback<A> requestCallback) {
        this.send(POST, postData, requestCallback);
        return this;
    }

    public Xhr<A> on(String eventType, RunFunction<Xhr<A>> listener) {
        if (this.dispatcher != null) {
            this.dispatcher.on(eventType, listener);
        }
        return this;
    }

    public Xhr<A> send(String method, String data, Callback<A> requestCallback) {
        String sendMethod;
        if (requestCallback != null) {
            this.userCallback = requestCallback;
        }
        String string = sendMethod = method == null ? GET : method.toUpperCase();
        if (this.mimeType != null && !this.headers.containsKey("accept")) {
            this.headers.put("accept", this.mimeType + ",*/*");
        }
        this.runnable.headers(this.headers).method(sendMethod).mimeType(this.mimeType).data(data);
        if (this.dispatcher != null) {
            ((Dispatcher.DispatcherEvent)this.dispatcher.get(BEFORESEND)).fire(this, this.runnable);
        }
        this.runnable.start();
        return this;
    }

    public Xhr<A> send(String method, Callback<A> callback) {
        return this.send(method, null, callback);
    }

    public void abort() {
        this.runnable.abort();
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public Xhr<A> header(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.put(name, value);
        }
        return this;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public Xhr<A> mimeType(String type) {
        this.mimeType = type;
        this.runnable.mimeType(type);
        return this;
    }

    public String responseType() {
        return this.runnable.responseType();
    }

    public Xhr<A> responseType(String type) {
        this.runnable.responseType(type);
        return this;
    }

    @FunctionClass(value="callback")
    public static interface Callback<A> {
        public void callback(XhrResult var1, A var2);
    }
}

