/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.scales;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scales.LinearScale;
import com.ibm.vida.rave.core.selector.ValueFunction;
import java.util.List;

public class IdentityScale
extends AbstractScale<Object, Object> {
    private ArrayEx<Object> _domain;

    private IdentityScale(ArrayEx<Object> domain) {
        this._domain = domain.map(new ArrayEx.ArrayValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object currentValue, int index, ArrayEx<Object> array) {
                return ObjectConverter.toDouble(currentValue);
            }
        });
        final IdentityScale self = this;
        this.setInvert(new AbstractScale.InvertValueFunction<Object>(){

            @Override
            public Object getValue(Object y) {
                return self.scale(y);
            }
        });
        this.setTicks(new AbstractScale.TicksValueFunction(){

            @Override
            public ArrayEx<Object> getValue(Object ... tickArguments) {
                return LinearScale.linearTicks(self._domain, tickArguments);
            }
        });
        this.setTickFormat(new AbstractScale.TickFormatValueFunction(){

            @Override
            public ValueFunction<Object, String> getValue(Object ... tickArguments) {
                Double count = tickArguments.length > 0 ? Double.valueOf(ObjectConverter.toDouble(tickArguments[0])) : null;
                Object format = tickArguments.length > 1 ? tickArguments[1] : null;
                return LinearScale.linearTickFormat(self._domain, count, format instanceof String ? (String)format : null);
            }
        });
    }

    public static IdentityScale newIdentityScale() {
        return new IdentityScale(new ArrayEx<Object>(0, 1));
    }

    @Override
    @SwiftMethodOverload(skipParameters={1}, skipOverloads={"Bool"})
    public Object getValue(Object context, Object data, int index, int groupIndex) {
        return this.scale(data);
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public Object scale(Object key) {
        return ObjectConverter.toDouble(key);
    }

    @Override
    public AbstractScale<Object, Object> domain(List<Object> values) {
        this._domain = Lang.toArray(values.toArray()).map(new ArrayEx.ArrayValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object currentValue, int index, ArrayEx<Object> array) {
                return ObjectConverter.toDouble(currentValue);
            }
        });
        return this;
    }

    @Override
    public List<Object> domain() {
        return this._domain;
    }

    @Override
    public AbstractScale<Object, Object> range(List<Object> values) {
        return this.domain(values);
    }

    @Override
    public List<Object> range() {
        return this._domain;
    }

    @Override
    public AbstractScale<Object, Object> copy() {
        return new IdentityScale(this._domain);
    }
}

