/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.scales;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.internal.scales.Ranger;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import java.util.ArrayList;
import java.util.List;

public final class OrdinalScale
extends AbstractScale<Object, Object> {
    public static final Ranger DEFAULT_RANGER = new Ranger("range", new ArrayList<Object>(), 0.0, 0.0);
    private List<Object> _domain = new ArrayList<Object>();
    private List<Object> _range = new ArrayList<Object>();
    private double _rangeBand = 0.0;
    private double _rangeStep = 0.0;
    private Ranger ranger = DEFAULT_RANGER;
    private ES6Map<String, Integer> index = ES6Map.create();
    private double _viewOffset;
    private double _viewZoom;

    public OrdinalScale(List<Object> _domain, Ranger ranger, Number viewZoom, Number viewOffset) {
        this.ranger = ranger;
        this.domain((List)_domain);
        this._viewOffset = ObjectConverter.asDouble(viewOffset);
        this._viewZoom = ObjectConverter.asDouble(viewZoom);
        final OrdinalScale self = this;
        this.setRangeBand(new AbstractScale.RangeBandValueFunction(){

            @Override
            public Number getValue() {
                return self._rangeBand * self._viewZoom;
            }
        });
        this.setRangeStep(new AbstractScale.RangeStepValueFunction(){

            @Override
            public Number getValue() {
                return self._rangeStep * self._viewZoom;
            }
        });
        this.setRangeExtent(new AbstractScale.RangeExtentValueFunction<Object>(){

            @Override
            public List<Object> getValue() {
                return AbstractScale.scaleExtent(((OrdinalScale)self).ranger.a);
            }
        });
        this.setTicksInRange(new AbstractScale.TicksInRangeFunction(){

            @Override
            public ArrayEx<Object> ticksInRange(Object ... tickArguments) {
                ArrayEx<Object> ticksResult = new ArrayEx<Object>();
                if (tickArguments.length > 0 && ObjectConverter.toInt(tickArguments[0]) <= 0) {
                    return ticksResult;
                }
                List<Object> domain = self.domain();
                List rangeExtent = self.getRangeExtent().getValue();
                if (Lang.isNumber(rangeExtent.get(0)) && Lang.isNumber(rangeExtent.get(1))) {
                    int increment;
                    double min = ObjectConverter.toDouble(rangeExtent.get(0));
                    double max = ObjectConverter.toDouble(rangeExtent.get(1));
                    double bandWidth = ObjectConverter.toDouble(self.getRangeBand().getValue());
                    double bandDelta = bandWidth / 2.0;
                    if (tickArguments.length > 0) {
                        int nPreferredTicks = ObjectConverter.toInt(tickArguments[0]);
                        double maxTicksInRange = (max - min) / (bandWidth > 0.0 ? bandWidth : ObjectConverter.toDouble(self.getRangeStep().getValue()));
                        increment = ObjectConverter.toInt(Math.max(1.0, Math.pow(2.0, Math.floor(Math.log(maxTicksInRange / (double)nPreferredTicks) / Math.log(2.0)))));
                    } else {
                        increment = 1;
                    }
                    for (int i = 0; i < domain.size(); i += increment) {
                        Object d = domain.get(i);
                        double r = ObjectConverter.toDouble(self.getValue((Object)null, d, 0, 0)) + bandDelta;
                        if (!(r >= min) || !(r <= max)) continue;
                        ticksResult.push((Object[])new Object[]{d});
                    }
                }
                return ticksResult;
            }
        });
        this.setZoomTransform(new AbstractScale.ZoomTransformFunction(){

            @Override
            public void zoomTransform(Number zoom, Number offset) {
                self._viewOffset = ObjectConverter.toDouble(offset);
                self._viewZoom = Math.max(0.0, ObjectConverter.toDouble(zoom));
            }
        });
    }

    private Object scale(Object key, Ranger ranger) {
        String keyString = ObjectConverter.toString(key);
        Integer myindex = this.index.get(keyString);
        if (myindex == null && ranger.t.equals("range")) {
            this._domain.add(key);
            myindex = this.index.set(keyString, this._domain.size());
        }
        if (this._range.size() == 0 || myindex == null) {
            return Lang.undefined();
        }
        myindex = (myindex - 1) % this._range.size();
        return this.transformRangeValue(this._range.get(myindex));
    }

    public OrdinalScale domain(List<Object> values) {
        this._domain = new ArrayList<Object>();
        this.index = ES6Map.create();
        int i = -1;
        int n = values.size();
        while (++i < n) {
            String xi = ObjectConverter.toString(values.get(i));
            if (this.index.has(xi)) continue;
            this._domain.add(values.get(i));
            this.index.set(xi, this._domain.size());
        }
        if ("range".equals(this.ranger.t)) {
            return this.range((List)this.ranger.a);
        }
        if ("rangeBands".equals(this.ranger.t)) {
            return this.rangeBands(this.ranger.a, this.ranger.padding, this.ranger.outerPadding);
        }
        if ("rangePoints".equals(this.ranger.t)) {
            return this.rangePoints(this.ranger.a, this.ranger.padding);
        }
        if ("rangeRoundBands".equals(this.ranger.t)) {
            return this.rangeRoundBands(this.ranger.a, this.ranger.padding, this.ranger.outerPadding);
        }
        if ("rangeRoundPoints".equals(this.ranger.t)) {
            return this.rangeRoundPoints(this.ranger.a, this.ranger.padding);
        }
        return this;
    }

    @Override
    public List<Object> domain() {
        return this._domain;
    }

    public OrdinalScale range(List<Object> values) {
        this._range = values;
        this.ranger = new Ranger("range", values, 0.0, 0.0);
        this._rangeBand = 0.0;
        this._rangeStep = 0.0;
        return this;
    }

    @Override
    public List<Object> range() {
        return this._range;
    }

    public OrdinalScale copy() {
        return new OrdinalScale(this._domain, this.ranger, this._viewZoom, this._viewOffset);
    }

    @Override
    @SwiftMethodOverload(skipParameters={1}, overloads={"String"})
    public Object getValue(Object context, Object key, int _index, int groupIndex) {
        return this.scale(key, this.ranger);
    }

    public final OrdinalScale rangePoints(List<Object> interval, Double padding) {
        Double _padding = padding;
        if (_padding == null) {
            _padding = 0.0;
        }
        double start = ObjectConverter.toDouble(interval.get(0));
        double stop = ObjectConverter.toDouble(interval.get(1));
        double step = this._domain.size() < 2 ? (start = (start + stop) / 2.0) : (stop - start) / ((double)(this._domain.size() - 1) + _padding);
        this._range = this.steps(start + step * _padding / 2.0, step);
        this._rangeBand = 0.0;
        this._rangeStep = step;
        this.ranger = new Ranger("rangePoints", interval, _padding, 0.0);
        return this;
    }

    public final OrdinalScale rangeRoundPoints(List<Object> interval, Double padding) {
        double step;
        Double _padding = padding;
        if (_padding == null) {
            _padding = 0.0;
        }
        double start = ObjectConverter.toDouble(interval.get(0));
        double stop = ObjectConverter.toDouble(interval.get(1));
        if (this._domain.size() < 2) {
            stop = start = (double)Math.round((start + stop) / 2.0);
            step = start;
        } else {
            step = (int)((stop - start) / ((double)(this._domain.size() - 1) + _padding));
        }
        this._range = this.steps(start + (double)Math.round(step * _padding / 2.0 + (stop - start - ((double)(this._domain.size() - 1) + _padding) * step) / 2.0), step);
        this._rangeBand = 0.0;
        this._rangeStep = Math.round(step);
        this.ranger = new Ranger("rangeRoundPoints", interval, _padding, 0.0);
        return this;
    }

    public final OrdinalScale rangeBands(List<Object> interval, Double padding, Double outerPadding) {
        Double _padding = padding;
        Double _outerPadding = outerPadding;
        if (_padding == null) {
            _padding = 0.0;
        }
        if (_outerPadding == null) {
            _outerPadding = _padding;
        }
        double interval0 = ObjectConverter.toDouble(interval.get(0));
        double interval1 = ObjectConverter.toDouble(interval.get(1));
        boolean reverse = interval1 < interval0;
        double start = reverse ? interval1 : interval0;
        double stop = reverse ? interval0 : interval1;
        double step = (stop - start) / ((double)this._domain.size() - _padding + 2.0 * _outerPadding);
        this._range = this.steps(start + step * _outerPadding, step);
        if (reverse) {
            for (int i = 0; i < this._range.size() / 2; ++i) {
                Object temp = this._range.get(i);
                Object value = this._range.get(this._range.size() - 1 - i);
                this._range.set(i, value);
                this._range.set(this._range.size() - 1 - i, temp);
            }
        }
        this._rangeBand = step * (1.0 - _padding);
        this._rangeStep = 0.0;
        this.ranger = new Ranger("rangeBands", interval, _padding, _outerPadding);
        return this;
    }

    public final OrdinalScale rangeRoundBands(List<Object> interval, Double padding, Double outerPadding) {
        Double _padding = padding;
        Double _outerPadding = outerPadding;
        if (_padding == null) {
            _padding = 0.0;
        }
        if (_outerPadding == null) {
            _outerPadding = _padding;
        }
        double interval0 = ObjectConverter.toDouble(interval.get(0));
        double interval1 = ObjectConverter.toDouble(interval.get(1));
        boolean reverse = interval1 < interval0;
        double start = reverse ? interval1 : interval0;
        double stop = reverse ? interval0 : interval1;
        double step = Math.floor((stop - start) / ((double)this._domain.size() - _padding + 2.0 * _outerPadding));
        this._range = this.steps(start + (double)Math.round((stop - start - ((double)this._domain.size() - _padding) * step) / 2.0), step);
        if (reverse) {
            for (int i = 0; i < this._range.size() / 2; ++i) {
                Object temp = this._range.get(i);
                Object value = this._range.get(this._range.size() - 1 - i);
                this._range.set(i, value);
                this._range.set(this._range.size() - 1 - i, temp);
            }
        }
        this._rangeBand = Math.round(step * (1.0 - _padding));
        this.ranger = new Ranger("rangeRoundBands", interval, _padding, _outerPadding);
        return this;
    }

    private List<Object> steps(double start, double step) {
        ArrayEx<Object> rangeSteps = new ArrayEx<Object>(this._domain.size());
        for (int i = 0; i < this._domain.size(); ++i) {
            rangeSteps.set(i, start + step * (double)i);
        }
        return rangeSteps;
    }

    private Object transformRangeValue(Object r) {
        if (Lang.isNumber(r) && this.zoomTransformIsModified()) {
            return ObjectConverter.toDouble(r) * this._viewZoom + this._viewOffset;
        }
        return r;
    }

    private boolean zoomTransformIsModified() {
        return this._viewOffset != 0.0 || this._viewZoom != 1.0;
    }
}

