/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.scales;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.arrays.Quantile;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.util.Comparator;
import java.util.ArrayList;
import java.util.List;

public class QuantileScale
extends AbstractScale<Object, Object> {
    private List<Object> thresholds = new ArrayList<Object>();
    private List<Object> _domain = new ArrayList<Object>();
    private List<Object> _range = new ArrayList<Object>();

    public QuantileScale(List<Object> domain, List<Object> range) {
        this.domain(domain);
        this.range(range);
    }

    @Override
    @SwiftMethodOverload(skipParameters={1}, skipOverloads={"Bool"})
    public Object getValue(Object context, Object data, int index, int groupIndex) {
        if (!Double.isNaN(ObjectConverter.asDouble(data))) {
            return this.range().get(Rave.bisect.bisect(this.thresholds, data));
        }
        return Lang.undefined();
    }

    private QuantileScale rescale() {
        int i = 0;
        int rangeSize = this.range().size();
        this.thresholds = new ArrayList<Object>();
        while (++i < rangeSize) {
            this.thresholds.add(i - 1, Quantile.quantile(this._domain, ObjectConverter.toDouble(i) / ObjectConverter.toDouble(rangeSize)));
        }
        return this;
    }

    @Override
    public AbstractScale<Object, Object> domain(List<Object> values) {
        ArrayEx.ArrayValueFunction<Object, Double> rave_number = new ArrayEx.ArrayValueFunction<Object, Double>(){

            @Override
            public Double getValue(Object currentValue, int index, ArrayEx<Object> array) {
                return currentValue == null ? Double.NaN : ObjectConverter.toDouble(currentValue);
            }
        };
        ArrayEx.ArrayValueFunction<Double, Boolean> rave_numeric = new ArrayEx.ArrayValueFunction<Double, Boolean>(){

            @Override
            public Boolean getValue(Double currentValue, int index, ArrayEx<Double> array) {
                return !Double.isNaN(currentValue);
            }
        };
        Comparator<Double> ascending = new Comparator<Double>(){

            @Override
            public int compare(Double obj1, Double obj2) {
                return (int)(obj1 < obj2 ? -1.0 : (obj1 > obj2 ? 1.0 : (obj1 >= obj2 ? 0.0 : Double.NaN)));
            }
        };
        this._domain = ArrayEx.map(values, rave_number).filter(rave_numeric).sort(ascending);
        return this.rescale();
    }

    @Override
    public AbstractScale<Object, Object> range(List<Object> values) {
        this._range = values;
        return this.rescale();
    }

    @Override
    public List<Object> domain() {
        return this._domain;
    }

    @Override
    public List<Object> range() {
        return this._range;
    }

    public List<Object> quantiles() {
        return this.thresholds;
    }

    @Override
    public AbstractScale<Object, Object> copy() {
        return new QuantileScale(this._domain, this._range);
    }

    public List<Object> invertExtent(Object y) {
        int index = this._range.indexOf(y);
        ArrayList<Object> temp = new ArrayList<Object>();
        if (index < 0) {
            temp.add(Double.NaN);
            temp.add(Double.NaN);
            return temp;
        }
        temp.add(index > 0 ? this.thresholds.get(index - 1) : this._domain.get(0));
        temp.add(index < this.thresholds.size() ? this.thresholds.get(index) : this._domain.get(this._domain.size() - 1));
        return temp;
    }
}

