/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.scales;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.scales.IdentityScale;
import com.ibm.vida.rave.core.scales.LinearScale;
import com.ibm.vida.rave.core.scales.LogScale;
import com.ibm.vida.rave.core.scales.OrdinalScale;
import com.ibm.vida.rave.core.scales.PowScale;
import com.ibm.vida.rave.core.scales.QuantileScale;
import com.ibm.vida.rave.core.scales.QuantizeScale;
import com.ibm.vida.rave.core.scales.ThresholdScale;
import java.util.ArrayList;
import java.util.List;

public class Scales {
    public static final Scales INSTANCE = new Scales();
    private static ArrayEx<Object> RAVE_CAT10 = new ArrayEx<Object>("#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2", "#7f7f7f", "#bcbd22", "#17becf");
    private static ArrayEx<Object> RAVE_CAT20 = new ArrayEx<Object>("#1f77b4", "#aec7e8", "#ff7f0e", "#ffbb78", "#2ca02c", "#98df8a", "#d62728", "#ff9896", "#9467bd", "#c5b0d5", "#8c564b", "#c49c94", "#e377c2", "#f7b6d2", "#7f7f7f", "#c7c7c7", "#bcbd22", "#dbdb8d", "#17becf", "#9edae5");
    private static ArrayEx<Object> RAVE_CAT20b = new ArrayEx<Object>("#393b79", "#5254a3", "#6b6ecf", "#9c9ede", "#637939", "#8ca252", "#b5cf6b", "#cedb9c", "#8c6d31", "#bd9e39", "#e7ba52", "#e7cb94", "#843c39", "#ad494a", "#d6616b", "#e7969c", "#7b4173", "#a55194", "#ce6dbd", "#de9ed6");
    private static ArrayEx<Object> RAVE_CAT20c = new ArrayEx<Object>("#3182bd", "#6baed6", "#9ecae1", "#c6dbef", "#e6550d", "#fd8d3c", "#fdae6b", "#fdd0a2", "#31a354", "#74c476", "#a1d99b", "#c7e9c0", "#756bb1", "#9e9ac8", "#bcbddc", "#dadaeb", "#636363", "#969696", "#bdbdbd", "#d9d9d9");

    private Scales() {
    }

    public LinearScale linear() {
        return new LinearScale(null, null, null, null);
    }

    public OrdinalScale category10() {
        return Rave.scale.ordinal().range(RAVE_CAT10);
    }

    public OrdinalScale category20() {
        return Rave.scale.ordinal().range(RAVE_CAT20);
    }

    public OrdinalScale category20b() {
        return Rave.scale.ordinal().range(RAVE_CAT20b);
    }

    public OrdinalScale category20c() {
        return Rave.scale.ordinal().range(RAVE_CAT20c);
    }

    public OrdinalScale ordinal() {
        return new OrdinalScale(new ArrayList<Object>(), OrdinalScale.DEFAULT_RANGER, 1.0, 0.0);
    }

    public QuantizeScale quantize() {
        QuantizeScale scale = new QuantizeScale();
        ArrayList<Object> tempList = new ArrayList<Object>();
        tempList.add(0.0);
        tempList.add(1.0);
        scale.range((List<Object>)tempList);
        scale.domain((List<Object>)tempList);
        return scale;
    }

    public QuantileScale quantile() {
        return new QuantileScale(new ArrayList<Object>(), new ArrayList<Object>());
    }

    public LogScale log() {
        return new LogScale((LinearScale)this.linear().domain(new ArrayEx<Object>(0.0, 1.0)), LogScale.DEFAULT_BASE, true, new ArrayEx<Object>(1.0, 10.0));
    }

    public PowScale pow() {
        return new PowScale(this.linear(), 1, new ArrayEx<Object>(0.0, 1.0));
    }

    public PowScale sqrt() {
        return this.pow().exponent(0.5);
    }

    public ThresholdScale threshold() {
        return ThresholdScale.newThresholdScale();
    }

    public IdentityScale identity() {
        return IdentityScale.newIdentityScale();
    }
}

