/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.scales;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import java.util.List;

public class ThresholdScale
extends AbstractScale<Object, Object> {
    private List<Object> _domain = new ArrayEx<Object>();
    private List<Object> _range = new ArrayEx<Object>();

    private ThresholdScale(List<Object> domain, List<Object> range) {
        this._domain = domain;
        this._range = range;
    }

    @Override
    @SwiftMethodOverload(skipParameters={1})
    public Object getValue(Object context, Object data, int index, int groupIndex) {
        return this.scale(data);
    }

    public Object scale(Object key) {
        int i;
        Object _key = key;
        if (_key == null) {
            _key = ObjectConverter.toDouble(_key);
        }
        if (Lang.lessThanOrEqual(_key, _key) && (i = Rave.bisect.bisect(this._domain, _key)) >= 0 && i < this._range.size()) {
            return this._range.get(i);
        }
        return Lang.undefined();
    }

    @Override
    public AbstractScale<Object, Object> domain(List<Object> values) {
        this._domain = values;
        return this;
    }

    @Override
    public List<Object> domain() {
        return this._domain;
    }

    @Override
    public AbstractScale<Object, Object> range(List<Object> values) {
        this._range = values;
        return this;
    }

    @Override
    public List<Object> range() {
        return this._range;
    }

    @Override
    public AbstractScale<Object, Object> copy() {
        return new ThresholdScale(this._domain, this._range);
    }

    public List<Object> invertExtent(Object y) {
        int i = this._range.indexOf(y);
        Object first = Lang.undefined();
        Object second = Lang.undefined();
        if (i > 0 && i <= this._domain.size()) {
            first = this._domain.get(i - 1);
        }
        if (i >= 0 && i < this._domain.size()) {
            second = this._domain.get(i);
        }
        return new ArrayEx<Object>(first, second);
    }

    public static ThresholdScale newThresholdScale() {
        ArrayEx<Object> domain = new ArrayEx<Object>();
        domain.add(0.5);
        return new ThresholdScale(domain, new ArrayEx<Object>(0, 1));
    }
}

