/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.selector;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.Configuration;
import com.ibm.vida.rave.core.ExtensionFactory;
import com.ibm.vida.rave.core.RegistryService;
import com.ibm.vida.rave.core.arrays.Sort;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.event.BaseEvent;
import com.ibm.vida.rave.core.event.Event;
import com.ibm.vida.rave.core.event.EventListener;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.internal.nativeImpl.PlatformInitialization;
import com.ibm.vida.rave.core.internal.nativeImpl.transitions.InheritedTransition;
import com.ibm.vida.rave.core.internal.selector.EmptySceneNode;
import com.ibm.vida.rave.core.internal.selector.InternalEventListener;
import com.ibm.vida.rave.core.internal.selector.SelectorHelper;
import com.ibm.vida.rave.core.internal.selector.mirror.MirroredSelector;
import com.ibm.vida.rave.core.internal.transitions.TransitionInfo;
import com.ibm.vida.rave.core.internal.transitions.TransitionTracker;
import com.ibm.vida.rave.core.internal.transitions.TransitionUtil;
import com.ibm.vida.rave.core.internal.util.NamespaceUtil;
import com.ibm.vida.rave.core.internal.util.QueryUtil;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.vida.rave.core.nativeImpl.event.EventTracker;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.scene.SceneNodeFactory;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.EnterSelector;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selection;
import com.ibm.vida.rave.core.selector.SelectorDelegate;
import com.ibm.vida.rave.core.selector.SelectorEventListener;
import com.ibm.vida.rave.core.selector.SelectorGroup;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.transition.ITransitionInfo;
import com.ibm.vida.rave.core.transition.Transition;
import com.ibm.vida.rave.core.util.Comparator;
import com.ibm.vida.rave.core.util.QName;
import java.util.Iterator;
import java.util.List;

public class Selector
extends Selection<Selector> {
    private static final ExtensionFactory<Selector> factory = new ExtensionFactory<Selector>(){

        @Override
        public Selector create() {
            return new Selector();
        }
    };
    private static final String SELECTOR_DELEGATE_REGISTRY_KEY = "SELECTOR_DELEGATE_REGISTRY_KEY";
    @SwiftWeak(value=false)
    private Selector enterSelector;
    @SwiftWeak(value=false)
    private Selector exitSelector;
    protected boolean needsNodeExtension = false;

    private static RegistryService getSelectorDelegateRegistry() {
        SelectorRegistryService selectorDelegateRegistry = (SelectorRegistryService)RaveContextManager.INSTANCE.getRaveContext().getData(SELECTOR_DELEGATE_REGISTRY_KEY);
        if (selectorDelegateRegistry == null) {
            selectorDelegateRegistry = new SelectorRegistryService();
            RaveContextManager.INSTANCE.getRaveContext().putData(SELECTOR_DELEGATE_REGISTRY_KEY, selectorDelegateRegistry);
        }
        return selectorDelegateRegistry;
    }

    protected ExtensionFactory<Selector> getSelectorFactory() {
        return factory;
    }

    public Selector append(String name) {
        final QName qname = NamespaceUtil.getQName(name);
        return this.select(new ValueFunction<SceneNode, SceneNode>(){

            @Override
            public SceneNode getValue(SceneNode parent, Object data, int index, int groupIndex) {
                SceneNode newNode = Selector.createSceneNode(qname.space, qname.local, parent);
                if (newNode != null) {
                    parent.appendChild(newNode);
                }
                return newNode;
            }
        });
    }

    public Selector append(final ValueFunction<Object, SceneNode> elementFunction) {
        return this.select((Object)new ValueFunction<SceneNode, Object>(){

            @Override
            public Object getValue(SceneNode parent, Object data, int index, int groupIndex) {
                SceneNode newNode = (SceneNode)elementFunction.getValue(parent, data, index, groupIndex);
                SceneNode existingParent = newNode.getParentNode();
                if (existingParent != null) {
                    existingParent.removeChild(newNode);
                }
                parent.appendChild(newNode);
                return newNode;
            }
        });
    }

    public Selector insert(String name) {
        return this.insert(name, (String)null);
    }

    public Selector insert(ValueFunction<Object, SceneNode> elementFunction) {
        return this.insert(elementFunction, (String)null);
    }

    public Selector insert(ValueFunction<Object, SceneNode> elementFunction, String before) {
        return this.insert(elementFunction, SelectorHelper.selector(before));
    }

    public Selector insert(final ValueFunction<Object, SceneNode> nameFunction, final ValueFunction<SceneNode, SceneNode> beforeFunction) {
        return this.select(new ValueFunction<SceneNode, SceneNode>(){

            @Override
            public SceneNode getValue(SceneNode parent, Object data, int index, int groupIndex) {
                SceneNode newNode = (SceneNode)nameFunction.getValue(parent, data, index, groupIndex);
                if (newNode != null) {
                    SceneNode existingParent = newNode.getParentNode();
                    if (existingParent != null) {
                        existingParent.removeChild(newNode);
                    }
                    parent.insertBefore(newNode, beforeFunction != null ? (SceneNode)beforeFunction.getValue(parent, data, index, groupIndex) : null);
                }
                return newNode;
            }
        });
    }

    public Selector insert(String name, String before) {
        return this.insert(name, SelectorHelper.selector(before));
    }

    public Selector insert(String type, final ValueFunction<SceneNode, SceneNode> beforeFunction) {
        final QName qname = NamespaceUtil.getQName(type);
        return this.select(new ValueFunction<SceneNode, SceneNode>(){

            @Override
            public SceneNode getValue(SceneNode parent, Object data, int index, int groupIndex) {
                SceneNode newNode = Selector.createSceneNode(qname.space, qname.local, parent);
                if (newNode != null) {
                    parent.insertBefore(newNode, beforeFunction != null ? (SceneNode)beforeFunction.getValue(parent, data, index, groupIndex) : null);
                }
                return newNode;
            }
        });
    }

    @Override
    public Selector remove() {
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode parent;
                SceneNode node = (SceneNode)group.get(i);
                if (node == null || (parent = node.getParentNode()) == null) continue;
                parent.removeChild(node);
            }
        }
        return this;
    }

    public SelectorEventListener<? extends Event> on(String eventName) {
        EventListener<?> eventListener;
        SceneNode node = this.node();
        if (node != null && (eventListener = node.getEventListener(eventName)) instanceof InternalEventListener) {
            return ((InternalEventListener)eventListener)._listener;
        }
        return (SelectorEventListener)Lang.undefined();
    }

    public Selector on(OMap<String, SelectorEventListener<? extends Event>> value) {
        for (String key : value.keySet()) {
            this.on(key, value.get(key), false);
        }
        return this;
    }

    public Selector on(String eventName, SelectorEventListener<? extends Event> listener) {
        return this.on(eventName, listener, false);
    }

    public <E extends Event> Selector on(String eventName, final SelectorEventListener<E> listener, final boolean useCapture) {
        String group;
        String type;
        final Selector self = this;
        int idx = eventName.indexOf(".");
        if (idx >= 0) {
            type = eventName.substring(0, idx);
            group = eventName.substring(idx + 1);
        } else {
            type = eventName;
            group = null;
        }
        this.each(new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode node, Object data, final int index, final int groupIndex) {
                if (type != null && (group == null || type.length() > 0)) {
                    if (listener != null) {
                        final SceneNode fNode = node;
                        InternalEventListener eventListener = new InternalEventListener<E>(){

                            @Override
                            public void onEvent(SceneNode context, E event) {
                                self.notifyEvent(listener, fNode, index, groupIndex, event);
                            }
                        };
                        eventListener._listener = listener;
                        if (group != null) {
                            node.removeEventListener(type, group);
                            node.addEventListener(type, eventListener, useCapture, group);
                        } else {
                            node.removeEventListener(type);
                            node.addEventListener(type, eventListener, useCapture);
                        }
                    } else if (group != null) {
                        node.removeEventListener(type, group);
                    } else {
                        node.removeEventListener(type);
                    }
                } else if (group != null && listener == null) {
                    node.removeEventListeners(group);
                }
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E extends Event> void notifyEvent(SelectorEventListener<E> listener, SceneNode node, int index, int groupIndex, E event) {
        BaseEvent<?> o = EventTracker.INSTANCE.get();
        EventTracker.INSTANCE.set(event);
        try {
            listener.onEvent(node, node.getData(), index, groupIndex, event);
        }
        finally {
            EventTracker.INSTANCE.set(o);
        }
    }

    public SceneNode owner() {
        SceneNode node = this.node();
        return node != null ? node.getOwner() : null;
    }

    public Selector owner(final SceneNode owner) {
        return this.each(new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                context.setOwner(owner);
            }
        });
    }

    public Selector owner(final ValueFunction<? super SceneNode, ? extends SceneNode> owner) {
        if (owner == null) {
            return this.owner((SceneNode)((Object)owner));
        }
        return this.each(new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                context.setOwner((SceneNode)owner.getValue(context, data, index, groupIndex));
            }
        });
    }

    public Object attr(String attribute) {
        SceneNode node = this.node();
        if (node != null) {
            QName qname = NamespaceUtil.getQName(attribute);
            if (qname.space == null) {
                return node.getAttribute(qname.local);
            }
            return node.getAttributeNS(qname.space, qname.local);
        }
        return null;
    }

    @Override
    public Selector attr(String attribute, Object value) {
        if (value instanceof ValueFunction) {
            return this.attr(attribute, (ValueFunction)value);
        }
        QName qname = NamespaceUtil.getQName(attribute);
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                if (value == null) {
                    if (qname.space == null) {
                        node.removeAttribute(qname.local);
                        continue;
                    }
                    node.removeAttributeNS(qname.space, qname.local);
                    continue;
                }
                if (qname.space == null) {
                    node.setAttribute(qname.local, value);
                    continue;
                }
                node.setAttributeNS(qname.space, qname.local, value);
            }
        }
        return this;
    }

    @Override
    public Selector attr(String attribute, ValueFunction<? super SceneNode, ?> valueFunction) {
        if (valueFunction == null) {
            return this.attr(attribute, (Object)null);
        }
        QName qname = NamespaceUtil.getQName(attribute);
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                Object value = valueFunction.getValue(node, node.getData(), i, j);
                if (value == null) {
                    if (qname.space == null) {
                        node.removeAttribute(qname.local);
                        continue;
                    }
                    node.removeAttributeNS(qname.space, qname.local);
                    continue;
                }
                if (qname.space == null) {
                    node.setAttribute(qname.local, value);
                    continue;
                }
                node.setAttributeNS(qname.space, qname.local, value);
            }
        }
        return this;
    }

    public Object style(String styleName) {
        SceneNode node = this.node();
        return node != null ? node.getComputedStyle(styleName) : null;
    }

    @Override
    public Selector style(String styleName, Object value) {
        return value instanceof ValueFunction ? this.style(styleName, (ValueFunction)value, (String)null) : this.style(styleName, value, null);
    }

    @Override
    public Selector style(String styleName, Object value, String priority) {
        if (value instanceof ValueFunction) {
            return this.style(styleName, (ValueFunction)value, priority);
        }
        String newPriority = priority != null ? priority : "";
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                if (value == null) {
                    node.removeStyle(styleName);
                    continue;
                }
                node.setStyle(styleName, value, newPriority);
            }
        }
        return this;
    }

    @Override
    public Selector style(String styleName, ValueFunction<? super SceneNode, ?> valueFunction) {
        return this.style(styleName, (ValueFunction)valueFunction, (String)null);
    }

    @Override
    public Selector style(String styleName, ValueFunction<? super SceneNode, ?> valueFunction, String priority) {
        if (valueFunction == null) {
            return this.style(styleName, (Object)null);
        }
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                Object value = valueFunction.getValue(node, node.getData(), i, j);
                if (value == null) {
                    node.removeStyle(styleName);
                    continue;
                }
                node.setStyle(styleName, value, priority);
            }
        }
        return this;
    }

    public Object property(String key) {
        SceneNode node = this.node();
        return node != null ? node.getProperty(key) : null;
    }

    public Selector property(OMap<String, Object> value) {
        for (String key : value.keySet()) {
            Object v = value.get(key);
            if (v instanceof ValueFunction) {
                this.property(key, (ValueFunction)v);
                continue;
            }
            this.property(key, v);
        }
        return this;
    }

    public Selector property(String key, Object value) {
        if (value instanceof ValueFunction) {
            return this.property(key, (ValueFunction)value);
        }
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                this.selectorSetProperty(node, key, value);
            }
        }
        return this;
    }

    private void selectorSetProperty(SceneNode node, String key, Object value) {
        if (value == null) {
            node.removeProperty(key);
        } else {
            node.setProperty(key, value);
        }
    }

    public Selector property(String key, ValueFunction<? super SceneNode, ?> valueFunction) {
        if (valueFunction == null) {
            return this.property(key, (Object)null);
        }
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                this.selectorSetProperty(node, key, valueFunction.getValue(node, node.getData(), i, j));
            }
        }
        return this;
    }

    public String text() {
        SceneNode node = this.node();
        return node != null ? node.getText() : null;
    }

    @Override
    public Selector text(Object value) {
        if (value instanceof ValueFunction) {
            return this.text((ValueFunction)value);
        }
        String text = value == null ? "" : value + "";
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                node.setText(text);
            }
        }
        return this;
    }

    @Override
    public Selector text(ValueFunction<? super SceneNode, ?> valueFunction) {
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                Object value = valueFunction == null ? null : valueFunction.getValue(node, node.getData(), i, j);
                node.setText(value == null ? "" : value + "");
            }
        }
        return this;
    }

    public String html() {
        SceneNode node = this.node();
        return node != null ? node.getHtml() : null;
    }

    public Selector html(Object value) {
        String html = value == null ? "" : value + "";
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                node.setHtml(html);
            }
        }
        return this;
    }

    public Selector html(ValueFunction<? super SceneNode, ?> valueFunction) {
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                Object value = valueFunction == null ? null : valueFunction.getValue(node, node.getData(), i, j);
                node.setHtml(value == null ? "" : value + "");
            }
        }
        return this;
    }

    @Override
    public Selector filter(ValueFunction<? super SceneNode, Boolean> filterFunction) {
        Selector subgroups = this.getSelectorFactory().create();
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            SelectorGroup subgroup = new SelectorGroup();
            subgroups.add(subgroup);
            subgroup.parentNode = group.parentNode;
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null || !filterFunction.getValue(node, node.getData(), i, j).booleanValue()) continue;
                subgroup.add(node);
            }
        }
        return subgroups;
    }

    @Override
    public Selector filter(final String filter) {
        return this.filter(new ValueFunction<SceneNode, Boolean>(){

            @Override
            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                return QueryUtil.getQueryEngine(context).matches(context, filter);
            }
        });
    }

    @Override
    public boolean isTransition() {
        return false;
    }

    public boolean classed(String className) {
        SceneNode node = this.node();
        return node != null && node.containsClass(className);
    }

    public Selector classed(OMap<String, Object> value) {
        for (String key : value.keySet()) {
            Object v = value.get(key);
            if (v instanceof ValueFunction) {
                this.classed(key, (ValueFunction)v);
                continue;
            }
            this.classed(key, ObjectConverter.toBoolean(v));
        }
        return this;
    }

    public Selector classed(String className, boolean add) {
        String newClassName = className + "";
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                if (add) {
                    node.addClass(newClassName);
                    continue;
                }
                node.removeClass(newClassName);
            }
        }
        return this;
    }

    public Selector classed(String className, ValueFunction<? super SceneNode, Boolean> valueFunction) {
        if (valueFunction == null) {
            return this.classed(className, false);
        }
        String newClassName = className != null ? className + "" : "";
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                if (valueFunction.getValue(node, node.getData(), i, j).booleanValue()) {
                    node.addClass(newClassName);
                    continue;
                }
                node.removeClass(newClassName);
            }
        }
        return this;
    }

    public ArrayEx<Object> data() {
        if (this.length() > 0) {
            SelectorGroup group = (SelectorGroup)this.get(0);
            int n = group.size();
            ArrayEx<Object> value = new ArrayEx<Object>(n);
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                value.set(i, node.getData());
            }
            return value;
        }
        return null;
    }

    public Object datum() {
        SceneNode node = this.node();
        if (node != null) {
            return node.getData();
        }
        return null;
    }

    public Selector datum(ValueFunction<? super SceneNode, ?> valueFn) {
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                this.selectorSetProperty(node, "__data__", valueFn.getValue(node, node.getData(), i, j));
            }
        }
        return this;
    }

    public Selector datum(final Object value) {
        return this.datum(new ValueFunction<SceneNode, Object>(){

            @Override
            public Object getValue(SceneNode node, Object data, int index, int groupIndex) {
                return value;
            }
        });
    }

    public Selector data(ValueFunction<? super SceneNode, ? super Object[]> value) {
        return this.doData(value, null);
    }

    public Selector data(ValueFunction<? super SceneNode, ? super Object[]> value, ValueFunction<Object, Object> key) {
        return this.doData(value, key);
    }

    public Selector data(List<?> value, ValueFunction<Object, Object> key) {
        return this.doData(value, key);
    }

    public Selector data(Object[] value) {
        return this.doData(value, null);
    }

    public Selector data(List<?> value) {
        return this.doData(value, null);
    }

    public Selector data(Object[] value, ValueFunction<Object, Object> key) {
        return this.doData(value, key);
    }

    private Selector doData(Object value, final ValueFunction<Object, Object> key) {
        int i = -1;
        int n = this.length();
        ExtensionFactory<Selector> extFactory = this.getSelectorFactory();
        final EnterSelector enter = new EnterSelector().setSelectorFactory(extFactory);
        final Selector exit = extFactory.create();
        final Selector update = extFactory.create();
        update.enterSelector = enter;
        update.exitSelector = exit;
        final Selector self = this;
        BindRunnable bind = new BindRunnable(){

            @Override
            public void run(SelectorGroup group, Object[] groupData) {
                int n = group.size();
                int m = groupData.length;
                int n0 = Math.min(n, m);
                SelectorGroup updateNodes = new SelectorGroup(m);
                SelectorGroup enterNodes = new SelectorGroup(m);
                SelectorGroup exitNodes = new SelectorGroup(n);
                if (key != null) {
                    SceneNode snode;
                    Object keyValue;
                    Object node;
                    int i;
                    ES6Map<Object, Object> nodeByKeyValue = ES6Map.create();
                    ArrayEx keyValues = new ArrayEx(n);
                    for (i = 0; i < n; ++i) {
                        node = group.get(i);
                        keyValue = key.getValue(node, ((SceneNode)node).getData(), i, -1);
                        if (nodeByKeyValue.has(keyValue)) {
                            snode = (SceneNode)node;
                            snode.setProperty("isExit", true);
                            exitNodes.set(i, snode);
                        } else {
                            nodeByKeyValue.set(keyValue, node);
                        }
                        keyValues.set(i, keyValue);
                    }
                    for (i = 0; i < m; ++i) {
                        Object nodeData = groupData[i];
                        keyValue = key.getValue(groupData, nodeData, i, -1);
                        node = nodeByKeyValue.get(keyValue);
                        if (!ObjectConverter.toBoolean(node)) {
                            enterNodes.set(i, new EmptySceneNode(nodeData));
                        } else if (node != self) {
                            updateNodes.set(i, (SceneNode)node);
                            ((SceneNode)node).setData(nodeData);
                        }
                        nodeByKeyValue.set(keyValue, self);
                    }
                    for (i = 0; i < n; ++i) {
                        if (nodeByKeyValue.get(keyValues.get(i)) == self) continue;
                        snode = (SceneNode)group.get(i);
                        snode.setProperty("isExit", true);
                        exitNodes.set(i, snode);
                    }
                } else {
                    int i;
                    for (i = 0; i < n0; ++i) {
                        Object node = group.get(i);
                        Object nodeData = groupData[i];
                        if ((SceneNode)node != null) {
                            ((SceneNode)node).setData(nodeData);
                            updateNodes.set(i, (SceneNode)node);
                            continue;
                        }
                        enterNodes.set(i, new EmptySceneNode(nodeData));
                    }
                    while (i < m) {
                        enterNodes.set(i, new EmptySceneNode(groupData[i]));
                        ++i;
                    }
                    while (i < n) {
                        SceneNode snode = (SceneNode)group.get(i);
                        snode.setProperty("isExit", true);
                        exitNodes.set(i, snode);
                        ++i;
                    }
                }
                enterNodes.update = updateNodes;
                updateNodes.parentNode = exitNodes.parentNode = group.parentNode;
                enterNodes.parentNode = exitNodes.parentNode;
                enter.add(enterNodes);
                update.add(updateNodes);
                exit.add(exitNodes);
            }
        };
        if (value instanceof ValueFunction) {
            while (++i < n) {
                SelectorGroup group = (SelectorGroup)this.get(i);
                bind.run(group, (Object[])((ValueFunction)value).getValue(group, group.parentNode.getData(), i, -1));
            }
        } else {
            Object[] array;
            Object[] objectArray = array = value instanceof List ? ((List)value).toArray() : (Object[])value;
            while (++i < n) {
                bind.run((SelectorGroup)this.get(i), array);
            }
        }
        return update;
    }

    public Selector enter() {
        return this.enterSelector;
    }

    public Selector exit() {
        return this.exitSelector;
    }

    @Override
    public Transition transition() {
        return this.transition(null);
    }

    @Override
    public Transition transition(String name) {
        TransitionInfo inherit = InheritedTransition.get();
        if (inherit != null) {
            return Transition.create(this, name, inherit);
        }
        return Transition.create(this, name);
    }

    public Selector interrupt() {
        return this.interrupt(null);
    }

    public ITransitionInfo getTransitionInfo(String name) {
        Iterator iterator;
        TransitionTracker tracker;
        String namespace = TransitionUtil.transitionNamespace(name);
        SceneNode node = this.node();
        TransitionTracker transitionTracker = tracker = node != null ? (TransitionTracker)node.getProperty(namespace) : null;
        if (tracker != null && (iterator = tracker.keySet().iterator()).hasNext()) {
            Integer key = (Integer)iterator.next();
            TransitionInfo info = (TransitionInfo)tracker.get(key);
            return info;
        }
        return null;
    }

    public Selector interrupt(String name) {
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                TransitionUtil.interruptNS(node, TransitionUtil.transitionNamespace(name));
            }
        }
        return this;
    }

    public Selector pause() {
        return this.pause(null);
    }

    public Selector pause(String name) {
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                TransitionUtil.pauseNS(node, TransitionUtil.transitionNamespace(name));
            }
        }
        return this;
    }

    public Selector resume() {
        return this.resume(null);
    }

    public Selector resume(String name) {
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                TransitionUtil.resumeNS(node, TransitionUtil.transitionNamespace(name));
            }
        }
        return this;
    }

    public Selector end() {
        return this.end(null);
    }

    public Selector end(String name) {
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                TransitionUtil.endNS(node, TransitionUtil.transitionNamespace(name));
            }
        }
        return this;
    }

    @Override
    public Selector select(Object query) {
        return this.select(SelectorHelper.selector(query));
    }

    @Override
    public Selector select(ValueFunction<? super SceneNode, SceneNode> valueFunction) {
        Selector subgroups = this.getSelectorFactory().create();
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            SelectorGroup subgroup = new SelectorGroup();
            subgroups.add(subgroup);
            subgroup.parentNode = group.parentNode;
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node != null && valueFunction != null) {
                    SceneNode subnode = valueFunction.getValue(node, node.getData(), i, j);
                    subgroup.add(subnode);
                    if (subnode == null || !node.hasData()) continue;
                    subnode.setData(node.getData());
                    continue;
                }
                subgroup.add(null);
            }
        }
        return subgroups;
    }

    @Override
    public Selector selectAll(String query) {
        return this.selectAll(SelectorHelper.selectorAll(query));
    }

    @Override
    public Selector selectAll(ValueFunction<? super SceneNode, List<SceneNode>> selector) {
        Selector subgroups = this.getSelectorFactory().create();
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup subgroup = new SelectorGroup();
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                subgroup = Selector.createSelectorGroupFromNodes(selector != null ? selector.getValue(node, node.getData(), i, j) : null);
                subgroups.add(subgroup);
                subgroup.parentNode = node;
            }
        }
        return subgroups;
    }

    @Override
    public Selector each(CallbackFunction<? super SceneNode> callback) {
        return SelectorHelper.each(this, callback);
    }

    @Override
    public Selector each(String type, final RunFunction<? super SceneNode> listener) {
        return SelectorHelper.each(this, (CallbackFunction<? super SceneNode>)new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                listener.run(context, data, index, groupIndex);
            }
        });
    }

    @Override
    public Selector call(RunFunction<? super Selector> callback, Object ... args) {
        List<Object> list = Lang.toList(args);
        list.add(0, this);
        callback.run(this, list.toArray());
        return this;
    }

    public Selector init(SceneNode node) {
        SelectorGroup group = Selector.createSelectorGroupFromNode(node);
        this.add(group);
        group.parentNode = PlatformInitialization.getDocumentElement(node);
        return this;
    }

    public Selector initAll(List<SceneNode> nodes) {
        SelectorGroup group = Selector.createSelectorGroupFromNodes(nodes);
        this.add(group);
        group.parentNode = PlatformInitialization.getDocumentElement(PlatformInitialization.getDocument());
        return this;
    }

    public Selector init(String query) {
        SceneNode node = Configuration.INSTANCE.filter(QueryUtil.getQueryEngine(null).querySelector(query), query);
        SelectorGroup group = Selector.createSelectorGroupFromNode(node);
        this.add(group);
        group.parentNode = PlatformInitialization.getDocumentElement(node);
        return this;
    }

    public Selector initAll(String query) {
        List<SceneNode> nodes = Configuration.INSTANCE.filterArray(QueryUtil.getQueryEngine(null).querySelectorAll(query));
        SelectorGroup group = Selector.createSelectorGroupFromNodes(nodes);
        this.add(group);
        group.parentNode = PlatformInitialization.getDocumentElement(PlatformInitialization.getDocument());
        return this;
    }

    public Selector order() {
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int i = group.length() - 1;
            if (i <= 0) continue;
            SceneNode next = (SceneNode)group.get(i);
            while (--i >= 0) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                if (next != null && !next.equals(node.getNextSibling())) {
                    next.getParentNode().insertBefore(node, next);
                }
                next = node;
            }
        }
        return this;
    }

    public Selector sort2(final Comparator<Object> c) {
        Comparator<SceneNode> comparator = new Comparator<SceneNode>(){

            @Override
            public int compare(SceneNode a, SceneNode b) {
                if (a != null && b != null) {
                    return c.compare(a.getData(), b.getData());
                }
                return ObjectConverter.toNumber(!ObjectConverter.toBoolean(a)) - ObjectConverter.toNumber(!ObjectConverter.toBoolean(b));
            }
        };
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            ((SelectorGroup)this.get(j)).sort(comparator);
        }
        return this.order();
    }

    public Selector sort() {
        return this.sort2(Sort.ascending);
    }

    private static SelectorGroup createSelectorGroupFromNodes(List<SceneNode> nodes) {
        SelectorGroup result = new SelectorGroup();
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                result.add(nodes.get(i));
            }
        }
        return result;
    }

    private static SelectorGroup createSelectorGroupFromNode(SceneNode node) {
        SelectorGroup result = new SelectorGroup();
        if (node != null) {
            result.add(node);
        }
        return result;
    }

    private static SceneNode createSceneNode(String nsuri, String name, SceneNode context) {
        String _nsuri = nsuri;
        Configuration config = Configuration.INSTANCE;
        SceneNodeFactory nodeFactory = config.getSceneNodeFactory(context.getQualifiedName());
        if (_nsuri == null) {
            _nsuri = context.getNamespaceURI();
        }
        if (nodeFactory == null) {
            nodeFactory = config.getSceneNodeFactory(_nsuri);
        }
        return nodeFactory.create(_nsuri, name, context);
    }

    public Selector mirror(boolean mirror) {
        MirroredSelector mirroredSelector = new MirroredSelector();
        if (this.node() != null) {
            mirroredSelector.register(this.node()).initWithSelector(this);
            mirroredSelector.mirror(mirror);
        }
        return mirror ? mirroredSelector : this;
    }

    protected void initWithSelector(Selector selector) {
        int m = selector.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)selector.get(j);
            SelectorGroup newgroup = new SelectorGroup();
            newgroup.parentNode = group.parentNode;
            this.add(newgroup);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (this.needsNodeExtension) {
                    node = Configuration.INSTANCE.extendRecursive(node);
                }
                newgroup.add(node);
            }
        }
    }

    public Selector extension(String id) {
        Object delegate = Selector.getSelectorDelegateRegistry().extension(id);
        return delegate != null ? ((SelectorDelegate)delegate).setDelegate(this) : null;
    }

    public static boolean extension(String id, ExtensionFactory<SelectorDelegate> extensionFactory) {
        return Selector.getSelectorDelegateRegistry().extension(id, extensionFactory);
    }

    public Selector dispose() {
        this.remove();
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                node.dispose();
            }
        }
        return this;
    }

    @FunctionClass(value="run")
    @SwiftClosure(value="run")
    private static interface BindRunnable {
        public void run(SelectorGroup var1, Object[] var2);
    }

    private static class SelectorRegistryService
    extends RegistryService {
        private SelectorRegistryService() {
        }

        @Override
        public String getServiceId() {
            return "Selector";
        }
    }
}

