/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.svg;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.internal.util.Identity;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scales.Scales;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selection;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.AbstractTickHandler;
import com.ibm.vida.rave.core.transition.Transition;
import com.ibm.vida.rave.core.transition.Tween;
import java.util.List;

public final class Axis
implements RunFunction<Object> {
    @InlineStringConstant
    private static final String BOTTOM_ORIENT = "bottom";
    @InlineStringConstant
    private static final String TOP_ORIENT = "top";
    @InlineStringConstant
    private static final String LEFT_ORIENT = "left";
    @InlineStringConstant
    private static final String RIGHT_ORIENT = "right";
    @InlineStringConstant
    private static final String DEFAULT_ORIENT = "bottom";
    @InlineStringConstant
    private static final String PROPERTY_CHART = "__chart__";
    @InlineStringConstant
    private static final String CLASS_DOMAIN = "domain";
    @InlineStringConstant
    private static final String CLASS_DOMAIN_SELECTOR = ".domain";
    @InlineStringConstant
    private static final String ATTR_TRANSFORM = "transform";
    @InlineStringConstant
    private static final String ATTR_X = "x";
    @InlineStringConstant
    private static final String ATTR_Y = "y";
    @InlineStringConstant
    private static final String ATTR_X2 = "x2";
    @InlineStringConstant
    private static final String ATTR_Y2 = "y2";
    @InlineStringConstant
    private static final String ATTR_DY = "dy";
    @InlineStringConstant
    private static final String ATTR_SVG_PATH_DATA = "d";
    @InlineStringConstant
    private static final String CLASS_PROPERTY = "class";
    @InlineStringConstant
    private static final String CLASS_TICK = "tick";
    @InlineStringConstant
    private static final String CLASS_TICK_SELECTOR = ".tick";
    @InlineStringConstant
    private static final String STYLE_OPACITY = "opacity";
    @InlineStringConstant
    private static final String STYLE_TEXT_ANCHOR = "text-anchor";
    @InlineStringConstant
    private static final String ANCHOR_MIDDLE = "middle";
    @InlineStringConstant
    private static final String ANCHOR_START = "start";
    @InlineStringConstant
    private static final String ANCHOR_END = "end";
    @InlineStringConstant
    private static final String DY_HORIZONTAL_TOP = "0em";
    @InlineStringConstant
    private static final String DY_HORIZONTAL_BOTTOM = ".71em";
    @InlineStringConstant
    private static final String DY_VERTICAL = ".32em";
    @InlineStringConstant
    private static final String SVG_VERTICAL_LINETO = "V";
    @InlineStringConstant
    private static final String SVG_HORIZONTAL_LINETO = "H";
    @InlineStringConstant
    private static final String SVG_ZERO_COORD = "0";
    private static final ValueFunction<Object, String> _identity = Identity.create();
    private AbstractScale _scale = Scales.INSTANCE.linear();
    private String _orient = "bottom";
    private double _innerTickSize = 6.0;
    private double _outerTickSize = 6.0;
    private double _tickPadding = 3.0;
    private Object[] _tickArguments = new Object[0];
    private List<Object> _tickValues = null;
    private Object _tickFormat;
    @InlineStringConstant
    private static final String PROPERTY_TICK_HANDLER = "__tickHandler__";
    private RunFunction<? super SceneNode> _tickHandler = null;
    private static TickTransform HORIZONTAL_TRANSFORM = new TickTransform(){

        @Override
        public void transform(Selection ticks, final AbstractScale scale, final AbstractScale scale2) {
            ticks.attr(Axis.ATTR_TRANSFORM, new ValueFunction<SceneNode, String>(){

                @Override
                public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                    double value = ObjectConverter.toDouble(scale.getValue(context, data, index, groupIndex));
                    if (!Lang.isFinite(value)) {
                        value = ObjectConverter.toDouble(scale2.getValue(context, data, index, groupIndex));
                    }
                    return "translate(" + value + ",0)";
                }
            });
        }
    };
    private static TickTransform VERTICAL_TRANSFORM = new TickTransform(){

        @Override
        public void transform(Selection ticks, final AbstractScale scale, final AbstractScale scale2) {
            ticks.attr(Axis.ATTR_TRANSFORM, new ValueFunction<SceneNode, String>(){

                @Override
                public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                    double value = ObjectConverter.toDouble(scale.getValue(context, data, index, groupIndex));
                    if (!Lang.isFinite(value)) {
                        value = ObjectConverter.toDouble(scale2.getValue(context, data, index, groupIndex));
                    }
                    return "translate(0," + value + ")";
                }
            });
        }
    };

    @Override
    public Object run(Object context, Object ... args) {
        this.axis((Selection)args[0]);
        return null;
    }

    public void axis(Selection<?> g) {
        final Axis self = this;
        g.each(new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                String y2;
                String x2;
                String y1;
                String x1;
                TickTransform tickTransformFunction;
                int sign;
                ValueFunction<Object, String> tickFormat;
                Selector groupSelector = new Selector().init(context);
                Object __chart__ = context.getProperty(Axis.PROPERTY_CHART);
                DeltaScale scale0 = __chart__ != null ? (DeltaScale)__chart__ : self._scale;
                DeltaScale scale1 = self._scale.copy();
                context.setProperty(Axis.PROPERTY_CHART, scale1);
                List<Object> ticks = self._tickValues;
                if (ticks == null) {
                    ticks = scale1.getTicksInRange() != null ? scale1.getTicksInRange().ticksInRange(self._tickArguments) : (scale1.getTicks() != null ? scale1.getTicks().getValue(self._tickArguments) : ((AbstractScale)scale1).domain());
                }
                if ((tickFormat = self._tickFormat) == null) {
                    tickFormat = scale1.getTickFormat() != null ? scale1.getTickFormat().getValue(self._tickArguments) : _identity;
                }
                final Selector tick = groupSelector.selectAll(Axis.CLASS_TICK_SELECTOR).data(ticks.toArray(), scale1);
                Selector tickEnter = tick.enter().insert("g", Axis.CLASS_DOMAIN_SELECTOR).attr(Axis.CLASS_PROPERTY, Axis.CLASS_TICK).style(Axis.STYLE_OPACITY, 1.0E-6);
                Object tickExit = ((Selection)Transition.newTransition(tick.exit()).style(Axis.STYLE_OPACITY, 1.0E-6)).remove();
                Object tickUpdate = Transition.newTransition(tick.order()).style(Axis.STYLE_OPACITY, 1);
                double tickSpacing = Math.max(self._innerTickSize, 0.0) + self._tickPadding;
                List<Object> range = AbstractScale.scaleRange(scale1);
                Selector path = groupSelector.selectAll(Axis.CLASS_DOMAIN_SELECTOR).data(new Double[]{0.0});
                path.enter().append("path").attr(Axis.CLASS_PROPERTY, Axis.CLASS_DOMAIN);
                Selection<?> pathUpdate = Transition.newTransition(path);
                tickEnter.append("line");
                tickEnter.append("text");
                Selector lineEnter = tickEnter.select("line");
                Object lineUpdate = ((Selection)tickUpdate).select("line");
                Selector text = tick.select("text");
                if (tickFormat instanceof ValueFunction) {
                    text.text(tickFormat);
                } else {
                    text.text((Object)tickFormat);
                }
                Selector textEnter = tickEnter.select("text");
                Object textUpdate = ((Selection)tickUpdate).select("text");
                int n = sign = Axis.TOP_ORIENT.equals(self._orient) || Axis.LEFT_ORIENT.equals(self._orient) ? -1 : 1;
                if ("bottom".equals(self._orient) || Axis.TOP_ORIENT.equals(self._orient)) {
                    tickTransformFunction = HORIZONTAL_TRANSFORM;
                    x1 = Axis.ATTR_X;
                    y1 = Axis.ATTR_Y;
                    x2 = Axis.ATTR_X2;
                    y2 = Axis.ATTR_Y2;
                    text.attr(Axis.ATTR_DY, sign < 0 ? Axis.DY_HORIZONTAL_TOP : Axis.DY_HORIZONTAL_BOTTOM).style(Axis.STYLE_TEXT_ANCHOR, (Object)Axis.ANCHOR_MIDDLE);
                    pathUpdate.attr(Axis.ATTR_SVG_PATH_DATA, "M" + range.get(0) + "," + (double)sign * self._outerTickSize + Axis.SVG_VERTICAL_LINETO + Axis.SVG_ZERO_COORD + Axis.SVG_HORIZONTAL_LINETO + range.get(1) + Axis.SVG_VERTICAL_LINETO + (double)sign * self._outerTickSize);
                } else {
                    tickTransformFunction = VERTICAL_TRANSFORM;
                    x1 = Axis.ATTR_Y;
                    y1 = Axis.ATTR_X;
                    x2 = Axis.ATTR_Y2;
                    y2 = Axis.ATTR_X2;
                    text.attr(Axis.ATTR_DY, Axis.DY_VERTICAL).style(Axis.STYLE_TEXT_ANCHOR, (Object)(sign < 0 ? Axis.ANCHOR_END : Axis.ANCHOR_START));
                    pathUpdate.attr(Axis.ATTR_SVG_PATH_DATA, "M" + (double)sign * self._outerTickSize + "," + range.get(0) + Axis.SVG_HORIZONTAL_LINETO + Axis.SVG_ZERO_COORD + Axis.SVG_VERTICAL_LINETO + range.get(1) + Axis.SVG_HORIZONTAL_LINETO + (double)sign * self._outerTickSize);
                }
                lineEnter.attr(y2, (double)sign * self._innerTickSize);
                textEnter.attr(y1, (double)sign * tickSpacing);
                ((Selection)((Selection)lineUpdate).attr(x2, 0)).attr(y2, (double)sign * self._innerTickSize);
                ((Selection)((Selection)textUpdate).attr(x1, 0)).attr(y1, (double)sign * tickSpacing);
                if (scale1.getRangeBand() != null) {
                    double dx = ObjectConverter.asDouble(scale1.getRangeBand().getValue()) / 2.0;
                    scale0 = scale1 = new DeltaScale(scale1, dx);
                } else if (scale0.getRangeBand() != null) {
                    scale0 = scale1;
                } else {
                    tickTransformFunction.transform((Selection)tickExit, scale1, scale0);
                }
                tickTransformFunction.transform(tickEnter, scale0, scale1);
                tickTransformFunction.transform((Selection)tickUpdate, scale1, scale1);
                Object __tickHandler__ = context.getProperty(Axis.PROPERTY_TICK_HANDLER);
                context.setProperty(Axis.PROPERTY_TICK_HANDLER, self._tickHandler);
                if (__tickHandler__ != null && __tickHandler__ instanceof AbstractTickHandler) {
                    AbstractTickHandler tickHandler = (AbstractTickHandler)__tickHandler__;
                    tickHandler.reset(tick);
                }
                if (self._tickHandler != null) {
                    if (((Selection)tickUpdate).isTransition()) {
                        ((Transition)tickUpdate).tween("__axisLabelDrop__", new ValueFunction<SceneNode, Tween<SceneNode>>(){

                            @Override
                            public Tween<SceneNode> getValue(SceneNode originalSceneNodeContext, Object data, int index, int groupIndex) {
                                return new Tween<SceneNode>(){

                                    @Override
                                    public Object tween(SceneNode _originalSceneNodeContext, double t, boolean apply) {
                                        if (self._tickHandler != null) {
                                            self._tickHandler.run(_originalSceneNodeContext, Transition.newTransition(tick), self._orient);
                                        }
                                        return null;
                                    }
                                };
                            }
                        });
                    } else {
                        self._tickHandler.run(context, tick, self._orient);
                    }
                }
            }
        });
    }

    public final Axis scale(AbstractScale scale) {
        this._scale = scale;
        return this;
    }

    public final AbstractScale scale() {
        return this._scale;
    }

    public final Axis orient(String orientation) {
        this._orient = "bottom".equals(orientation) || TOP_ORIENT.equals(orientation) || LEFT_ORIENT.equals(orientation) || RIGHT_ORIENT.equals(orientation) ? orientation : "bottom";
        return this;
    }

    public final String orient() {
        return this._orient;
    }

    public final Axis ticks(Object ... tickArguments) {
        this._tickArguments = tickArguments;
        return this;
    }

    public final Object[] ticks() {
        return this._tickArguments;
    }

    public final Axis tickValues(List<Object> values) {
        this._tickValues = values;
        return this;
    }

    public final List<Object> tickValues() {
        return this._tickValues;
    }

    @SwiftMethodOverload(overloads={"String"})
    public final Axis tickFormat(Object format) {
        this._tickFormat = format;
        return this;
    }

    public final Axis tickFormat(ValueFunction<? super SceneNode, ?> valueFunction) {
        this._tickFormat = valueFunction;
        return this;
    }

    public final Object tickFormat() {
        return this._tickFormat;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public final Axis tickSize(Object size) {
        return this.tickSize(size, size);
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public final Axis tickSize(Object inner, Object outer) {
        this.innerTickSize(inner);
        this.outerTickSize(outer);
        return this;
    }

    @Deprecated
    @SwiftMethodOverload(skipOverloads={"Bool"})
    public final Axis tickSize(Object inner, Object extra, Object outer) {
        return this.tickSize(inner, outer);
    }

    public final double tickSize() {
        return this.innerTickSize();
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public final Axis innerTickSize(Object size) {
        this._innerTickSize = ObjectConverter.toDouble(size);
        return this;
    }

    public final double innerTickSize() {
        return this._innerTickSize;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public final Axis outerTickSize(Object size) {
        this._outerTickSize = ObjectConverter.toDouble(size);
        return this;
    }

    public final double outerTickSize() {
        return this._outerTickSize;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public final Axis tickPadding(Object padding) {
        this._tickPadding = ObjectConverter.toDouble(padding);
        return this;
    }

    public final double tickPadding() {
        return this._tickPadding;
    }

    public final Number tickSubdivide() {
        return 0;
    }

    @SwiftMethodOverload(skip=true)
    public final Axis tickSubdivide(Object arg) {
        return this;
    }

    public final Axis ticksHandler(AbstractTickHandler callback) {
        this._tickHandler = callback;
        return this;
    }

    @Deprecated
    public final Axis ticksHandler(RunFunction<? super SceneNode> callback) {
        this._tickHandler = callback;
        return this;
    }

    public final RunFunction<? super SceneNode> ticksHandler() {
        return this._tickHandler;
    }

    @FunctionClass(value="transform")
    @SwiftClosure(value="transform")
    private static interface TickTransform {
        public void transform(Selection var1, AbstractScale var2, AbstractScale var3);
    }

    private static class DeltaScale
    extends AbstractScale<Object, Object> {
        private double delta = 0.0;
        @SwiftWeak(value=false)
        private AbstractScale<Object, Object> wrappedScale = null;

        public DeltaScale(AbstractScale<Object, Object> referencedScale, double delta) {
            this.wrappedScale = referencedScale;
            this.delta = delta;
        }

        @Override
        @SwiftMethodOverload(skipParameters={1})
        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ObjectConverter.toDouble(this.wrappedScale.getValue(context, data, index, groupIndex)) + this.delta;
        }

        @Override
        public AbstractScale<Object, Object> domain(List values) {
            return null;
        }

        @Override
        public List domain() {
            return null;
        }

        @Override
        public AbstractScale<Object, Object> range(List values) {
            return null;
        }

        @Override
        public List range() {
            return null;
        }

        @Override
        public AbstractScale<Object, Object> copy() {
            return null;
        }
    }
}

