/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.svg;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geom.Point;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.AbstractLineInterpolator;
import com.ibm.vida.rave.core.svg.SVGLine;
import java.util.List;

public class LinePathGenerator
implements ValueFunction<Object, String> {
    private ValueFunction<Object, Boolean> definedFn = SVGLine.DEFAULT_DEFINED_FN;
    private AbstractLineInterpolator interpolateFn = SVGLine.r2_svg_lineLinear;
    private double tensionVal = 0.7;
    private ValueFunction<Object, Object> fx = SVGLine.DEFAULT_X_FN;
    private ValueFunction<Object, Object> fy = SVGLine.DEFAULT_Y_FN;
    private Object interpolateKey = this.interpolateFn.getKey();
    private double xVal;
    private double yVal;
    private final ValueFunction<Object, ArrayEx<?>> projectionFn;
    private boolean _showMissingAsGap = true;

    public LinePathGenerator(ValueFunction<Object, ArrayEx<?>> projection) {
        this.projectionFn = projection;
    }

    public Object x() {
        if (this.fx != null) {
            return this.fx;
        }
        return this.xVal;
    }

    public LinePathGenerator x(ValueFunction<Object, Object> valFn) {
        this.fx = valFn;
        return this;
    }

    public LinePathGenerator x(double xNewVal) {
        this.fx = null;
        this.xVal = xNewVal;
        return this;
    }

    public Object y() {
        if (this.fy != null) {
            return this.fy;
        }
        return this.yVal;
    }

    public LinePathGenerator y(ValueFunction<Object, Object> valFn) {
        this.fy = valFn;
        return this;
    }

    public LinePathGenerator y(double yNewVal) {
        this.fy = null;
        this.yVal = yNewVal;
        return this;
    }

    public ValueFunction<Object, Boolean> defined() {
        return this.definedFn;
    }

    public LinePathGenerator defined(ValueFunction<Object, Boolean> valFn) {
        this.definedFn = valFn;
        return this;
    }

    public double tension() {
        return this.tensionVal;
    }

    public LinePathGenerator tension(double tensionNewVal) {
        this.tensionVal = tensionNewVal;
        return this;
    }

    public Object interpolate() {
        return this.interpolateKey;
    }

    public LinePathGenerator interpolate(String key) {
        this.interpolateKey = key;
        this.interpolateFn = SVGLine.r2_svg_lineInterpolators.get(key);
        if (this.interpolateFn == null) {
            this.interpolateFn = SVGLine.r2_svg_lineLinear;
            this.interpolateKey = this.interpolateFn.getKey();
        }
        return this;
    }

    public LinePathGenerator interpolate(AbstractLineInterpolator valFn) {
        this.interpolateFn = valFn;
        this.interpolateKey = this.interpolateFn;
        return this;
    }

    public LinePathGenerator showMissingAsGap(boolean state) {
        this._showMissingAsGap = state;
        return this;
    }

    @Override
    @SwiftMethodOverload(skip=true)
    public String getValue(Object context, Object datum, int index, int groupIndex) {
        ArrayEx<Object> segments = new ArrayEx<Object>();
        ArrayEx<Point> points = new ArrayEx<Point>();
        List data = (List)datum;
        int i = -1;
        int n = 0;
        Object d = null;
        n = data.size();
        while (++i < n) {
            d = data.get(i);
            if (this.definedFn.getValue(this, d, i, -1).booleanValue()) {
                points.push(new Point(ObjectConverter.toDouble(this.fx == null ? Double.valueOf(this.xVal) : this.fx.getValue(context, d, i, -1)), ObjectConverter.toDouble(this.fy == null ? Double.valueOf(this.yVal) : this.fy.getValue(context, d, i, -1))));
                continue;
            }
            if (!this._showMissingAsGap || points.size() == 0) continue;
            segments.push("M", this.interpolateFn.getValue(this.projectionFn.getValue(context, points, -1, -1), this.tensionVal));
            points = new ArrayEx();
        }
        if (points.size() != 0) {
            segments.push("M", this.interpolateFn.getValue(this.projectionFn.getValue(context, points, -1, -1), this.tensionVal));
        }
        return segments.size() != 0 ? segments.join("") : null;
    }
}

