/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.svg;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geom.Point;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.LinePathGenerator;

public class LineRadial {
    public static final ValueFunction<Object, ArrayEx<?>> r2_svg_lineRadial = new ValueFunction<Object, ArrayEx<?>>(){

        @Override
        public ArrayEx<Point> getValue(Object context, Object data, int index, int groupIndex) {
            ArrayEx points = (ArrayEx)data;
            int i = -1;
            int n = points.size();
            while (++i < n) {
                Point point = (Point)points.get(i);
                double r = point.getX();
                double a = point.getY() - 1.5707963267948966;
                point.setX(r * Math.cos(a));
                point.setY(r * Math.sin(a));
            }
            return points;
        }
    };

    public static RadialLinePathGenerator createLine() {
        return new RadialLinePathGenerator(r2_svg_lineRadial);
    }

    public static final class RadialLinePathGenerator
    extends LinePathGenerator {
        public RadialLinePathGenerator(ValueFunction<Object, ArrayEx<?>> projection) {
            super(projection);
        }

        public Object radius() {
            return super.x();
        }

        public RadialLinePathGenerator radius(ValueFunction<Object, Object> valFn) {
            return (RadialLinePathGenerator)super.x(valFn);
        }

        public RadialLinePathGenerator radius(double xNewVal) {
            return (RadialLinePathGenerator)super.x(xNewVal);
        }

        public Object angle() {
            return super.y();
        }

        public RadialLinePathGenerator angle(ValueFunction<Object, Object> valFn) {
            return (RadialLinePathGenerator)super.y(valFn);
        }

        public RadialLinePathGenerator angle(double yNewVal) {
            return (RadialLinePathGenerator)super.y(yNewVal);
        }

        @Override
        public Object x() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LinePathGenerator x(ValueFunction<Object, Object> valFn) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LinePathGenerator x(double xNewVal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object y() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LinePathGenerator y(ValueFunction<Object, Object> valFn) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LinePathGenerator y(double yNewVal) {
            throw new UnsupportedOperationException();
        }
    }
}

