/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.svg;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.internal.svg.symbol.CircleSymbolCreator;
import com.ibm.vida.rave.core.internal.svg.symbol.CrossSymbolCreator;
import com.ibm.vida.rave.core.internal.svg.symbol.DiamondSymbolCreator;
import com.ibm.vida.rave.core.internal.svg.symbol.SquareSymbolCreator;
import com.ibm.vida.rave.core.internal.svg.symbol.TriangleDownSymbolCreator;
import com.ibm.vida.rave.core.internal.svg.symbol.TriangleUpSymbolCreator;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.SymbolCreator;
import java.util.List;

public class Symbol
implements ValueFunction<Object, String> {
    private static double DEFAULT_SIZE = 64.0;
    @InlineStringConstant
    private static final String SYMBOLS_KEY = "SYMBOLS_KEY";
    private static SymbolCreator r2_svg_symbolCircle = new CircleSymbolCreator();
    private ValueFunction<Object, String> type_fn = TYPE_FN;
    private ValueFunction<Object, ? extends Number> size_fn = SIZE_FN;
    private static ValueFunction<Object, ? extends Number> SIZE_FN = new ValueFunction<Object, Number>(){

        @Override
        public Number getValue(Object context, Object data, int index, int groupIndex) {
            return DEFAULT_SIZE;
        }
    };
    private static ValueFunction<Object, String> TYPE_FN = new ValueFunction<Object, String>(){

        @Override
        public String getValue(Object context, Object data, int index, int groupIndex) {
            return "circle";
        }
    };

    private static ES6Map<String, SymbolCreator> createSymbols() {
        ES6Map<String, SymbolCreator> map = ES6Map.create();
        map.set("circle", r2_svg_symbolCircle);
        map.set("cross", new CrossSymbolCreator());
        map.set("diamond", new DiamondSymbolCreator());
        map.set("square", new SquareSymbolCreator());
        map.set("triangle-down", new TriangleDownSymbolCreator());
        map.set("triangle-up", new TriangleUpSymbolCreator());
        return map;
    }

    private static SymbolsMap getSymbols() {
        SymbolsMap symbolsMap = (SymbolsMap)RaveContextManager.INSTANCE.getRaveContext().getData(SYMBOLS_KEY);
        if (symbolsMap == null) {
            symbolsMap = new SymbolsMap();
            RaveContextManager.INSTANCE.getRaveContext().putData(SYMBOLS_KEY, symbolsMap);
        }
        return symbolsMap;
    }

    public static List<String> getSymbolTypes() {
        return Symbol.getSymbols().types;
    }

    static boolean register(String id, SymbolCreator symbolCreator) {
        return Symbol.getSymbols().register(id, symbolCreator);
    }

    @Override
    public String getValue(Object context, Object data, int index, int groupIndex) {
        String type = this.type_fn.getValue(context, data, index, groupIndex);
        SymbolCreator creator = Symbol.getSymbols().r2_svg_symbols.get(type);
        if (creator == null) {
            creator = r2_svg_symbolCircle;
        }
        return creator.create(ObjectConverter.toDouble(this.size_fn.getValue(context, data, index, groupIndex)));
    }

    public ValueFunction<Object, String> type() {
        return this.type_fn;
    }

    public Symbol type(ValueFunction<Object, String> valueFn) {
        if (valueFn != null) {
            this.type_fn = valueFn;
        } else {
            this.type((String)null);
        }
        return this;
    }

    public Symbol type(final String value) {
        this.type_fn = new ValueFunction<Object, String>(){

            @Override
            public String getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, ? extends Number> size() {
        return this.size_fn;
    }

    public Symbol size(ValueFunction<Object, ? extends Number> valueFn) {
        if (valueFn != null) {
            this.size_fn = valueFn;
        } else {
            this.size(0.0);
        }
        return this;
    }

    public Symbol size(final double value) {
        this.size_fn = new ValueFunction<Object, Number>(){

            @Override
            public Number getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    static /* synthetic */ ES6Map access$000() {
        return Symbol.createSymbols();
    }

    private static class SymbolsMap {
        final ES6Map<String, SymbolCreator> r2_svg_symbols = Symbol.access$000();
        final List<String> types = new ArrayEx<String>();

        SymbolsMap() {
            List<String> keys = this.r2_svg_symbols.keys();
            for (int i = 0; i < keys.size(); ++i) {
                this.types.add(keys.get(i));
            }
        }

        boolean register(String id, SymbolCreator symbolCreator) {
            if (this.r2_svg_symbols.get(id) != null) {
                return false;
            }
            this.r2_svg_symbols.set(id, symbolCreator);
            this.types.add(id);
            return true;
        }
    }
}

