/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.time;

import com.ibm.vida.rave.core.arrays.Range;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.time.Date;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.time.IDate;
import com.ibm.vida.rave.core.time.TimeInterval;

public class Millisecond
extends TimeInterval {
    public static TimeInterval INSTANCE = new Millisecond();

    private Millisecond() {
    }

    @Override
    public IDate floor(IDate date) {
        return date;
    }

    @Override
    public void step(IDate date, int offset) {
        date.setMilliseconds(date.getMilliseconds() + offset);
    }

    @Override
    public int number(IDate date) {
        return date.getMilliseconds();
    }

    @Override
    public IDate ceil(IDate date) {
        return date;
    }

    @Override
    public ArrayEx<Object> range(IDate start, IDate stop, int step) {
        ArrayEx<Object> result = new ArrayEx<Object>();
        for (Number n : Range.create(Math.ceil(start.getTime() / (long)step) * (double)step, ObjectConverter.toDouble(stop), step)) {
            result.add(new Date(n.longValue()));
        }
        return result;
    }
}

