/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.time;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.time.TimeUtil;
import com.ibm.vida.rave.core.locale.Locale;
import com.ibm.vida.rave.core.locale.TimeFormat;
import com.ibm.vida.rave.core.time.DateTimeScale;
import com.ibm.vida.rave.core.time.Day;
import com.ibm.vida.rave.core.time.Hour;
import com.ibm.vida.rave.core.time.IDate;
import com.ibm.vida.rave.core.time.ITimeInterval;
import com.ibm.vida.rave.core.time.Millisecond;
import com.ibm.vida.rave.core.time.Minute;
import com.ibm.vida.rave.core.time.Month;
import com.ibm.vida.rave.core.time.Second;
import com.ibm.vida.rave.core.time.TimeInterval;
import com.ibm.vida.rave.core.time.TimeIntervalUTC;
import com.ibm.vida.rave.core.time.TimeRangeValueFunction;
import com.ibm.vida.rave.core.time.Week;
import com.ibm.vida.rave.core.time.Year;

public class Time {
    private static volatile Time INSTANCE;
    public final TimeScaleValueFunction scale = new TimeScaleValueFunction(){

        @Override
        public DateTimeScale utc() {
            return new DateTimeScale(null, null, null, null, DateTimeScale.utcFormat, DateTimeScale.utcMethods, DateTimeScale.utcMethodsYear);
        }

        @Override
        public DateTimeScale create() {
            return new DateTimeScale(null, null, null, null, DateTimeScale.localFormat, DateTimeScale.localMethods, DateTimeScale.localMethodsYear);
        }
    };
    public final TimeFormat format = new TimeFormat(Locale.DEFAULT_LOCALE);
    public final TimeInterval day = Day.INSTANCE;
    public final TimeInterval hour = Hour.INSTANCE;
    public final TimeInterval month = Month.INSTANCE;
    public final TimeInterval year = Year.INSTANCE;
    public final TimeInterval second = Second.INSTANCE;
    public final TimeInterval minute = Minute.INSTANCE;
    public final TimeInterval millisecond = Millisecond.INSTANCE;
    public final TimeRange days = new TimeRangeImpl(this.day);
    public final TimeRange years = new TimeRangeImpl(this.year);
    public final TimeRange months = new TimeRangeImpl(this.month);
    public final TimeRange hours = new TimeRangeImpl(this.hour);
    public final TimeRange minutes = new TimeRangeImpl(this.minute);
    public final TimeRange seconds = new TimeRangeImpl(this.second);
    public final TimeInterval sunday;
    public final TimeInterval week = this.sunday = new Week(0);
    public final TimeInterval monday = new Week(1);
    public final TimeInterval tuesday = new Week(2);
    public final TimeInterval wednesday = new Week(3);
    public final TimeInterval thursday = new Week(4);
    public final TimeInterval friday = new Week(5);
    public final TimeInterval saturday = new Week(6);
    public final TimeRange sundays;
    public final TimeRange weeks = this.sundays = new TimeRangeImpl(this.sunday);
    public final TimeRange mondays = new TimeRangeImpl(this.monday);
    public final TimeRange tuesdays = new TimeRangeImpl(this.tuesday);
    public final TimeRange wednesdays = new TimeRangeImpl(this.wednesday);
    public final TimeRange thursdays = new TimeRangeImpl(this.thursday);
    public final TimeRange fridays = new TimeRangeImpl(this.friday);
    public final TimeRange saturdays = new TimeRangeImpl(this.saturday);
    public final WeekOfYear sundayOfYear;
    public final WeekOfYear weekOfYear = this.sundayOfYear = new WeekOfYear(0);
    public final WeekOfYear mondayOfYear = new WeekOfYear(1);
    public final WeekOfYear tuesdayOfYear = new WeekOfYear(2);
    public final WeekOfYear wednesdayOfYear = new WeekOfYear(3);
    public final WeekOfYear thursdayOfYear = new WeekOfYear(4);
    public final WeekOfYear fridayOfYear = new WeekOfYear(5);
    public final WeekOfYear saturdayOfYear = new WeekOfYear(6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Time getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<Time> clazz = Time.class;
        synchronized (Time.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new Time();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private Time() {
    }

    public int dayOfYear(IDate date) {
        return TimeUtil.dayOfYear(date);
    }

    @FunctionClass(value="create")
    public static interface TimeScaleValueFunction {
        public DateTimeScale create();

        public DateTimeScale utc();
    }

    @FunctionClass(value="get")
    @SwiftClosure(value="get")
    private static interface WeekOfYearValueFunction {
        public int get(IDate var1);
    }

    public class WeekOfYear
    implements WeekOfYearValueFunction {
        private final int weekIndex;

        private WeekOfYear(int index) {
            this.weekIndex = index;
        }

        @Override
        public int get(IDate date) {
            int day = Time.getInstance().year.getValue(date).getDay();
            return (int)Math.floor((Time.getInstance().dayOfYear(date) + (day + (7 - this.weekIndex)) % 7) / 7);
        }
    }

    private class TimeRangeUTC
    extends TimeRange {
        public TimeRangeUTC(TimeInterval interval) {
            super(interval);
            this.interval = new TimeIntervalUTC(interval);
        }
    }

    private class TimeRangeImpl
    extends TimeRange {
        public TimeRangeImpl(TimeInterval interval) {
            super(interval);
            this.utc = new TimeRangeUTC(interval);
        }
    }

    public abstract class TimeRange
    implements TimeRangeValueFunction {
        protected ITimeInterval interval;
        public TimeRange utc;

        public TimeRange(ITimeInterval interval) {
            this.interval = interval;
        }

        public ITimeInterval getInterval() {
            return this.interval;
        }

        @Override
        public ArrayEx<Object> getValue(IDate start, IDate stop, int step) {
            return this.interval.range(start, stop, step);
        }

        @Override
        public final boolean hasRangeMethod() {
            return false;
        }
    }
}

