/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.time;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.time.Date;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.time.DateUTC;
import com.ibm.vida.rave.core.time.IDate;
import com.ibm.vida.rave.core.time.ITimeInterval;
import com.ibm.vida.rave.core.time.TimeIntervalFunction;
import com.ibm.vida.rave.core.time.TimeIntervalUTC;

public abstract class TimeInterval
implements TimeIntervalFunction,
ITimeInterval {
    public final ITimeInterval utc = new TimeIntervalUTC(this);
    private static final TimeIntervalUTC utc_load_flag_unused = new TimeIntervalUTC(null);

    TimeInterval() {
    }

    @Override
    public final boolean hasRangeMethod() {
        return true;
    }

    @Override
    public IDate round(IDate date) {
        IDate d0 = this.getValue(date);
        IDate d1 = this.offset(d0, 1);
        return date.getTime() - d0.getTime() < d1.getTime() - date.getTime() ? d0 : d1;
    }

    @Override
    public IDate ceil(IDate date) {
        IDate localDate = this.createDate(date, date.getTime() - 1L);
        localDate = this.getValue(localDate);
        this.step(localDate, 1);
        return localDate;
    }

    @Override
    public IDate offset(IDate date, int k) {
        IDate newDate = this.createDate(date, date.getTime());
        this.step(newDate, k);
        return newDate;
    }

    @Override
    public ArrayEx<Object> range(IDate start, IDate stop, int step) {
        IDate time = this.ceil(start);
        ArrayEx<Object> times = new ArrayEx<Object>();
        if (step > 1) {
            while (time.getTime() < stop.getTime()) {
                if (!ObjectConverter.toBoolean(this.number(time) % step)) {
                    times.push((Object[])new Object[]{new Date(time.getTime())});
                }
                this.step(time, 1);
            }
        } else {
            while (time.getTime() < stop.getTime()) {
                times.push((Object[])new Object[]{new Date(time.getTime())});
                this.step(time, 1);
            }
        }
        return times;
    }

    @Override
    public IDate getValue(IDate start) {
        return this.floor(start);
    }

    protected IDate createDate(IDate date, long time) {
        IDate newdate = date instanceof DateUTC ? new DateUTC(time) : new Date(time);
        return newdate;
    }

    @Override
    public abstract IDate floor(IDate var1);

    @Override
    public abstract void step(IDate var1, int var2);

    @Override
    public abstract int number(IDate var1);
}

