/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.time;

import com.ibm.vida.rave.core.internal.time.TimeUtil;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.time.Day;
import com.ibm.vida.rave.core.time.IDate;
import com.ibm.vida.rave.core.time.TimeInterval;
import com.ibm.vida.rave.core.time.Year;

public class Week
extends TimeInterval {
    private final int dayIndex;

    public Week(int index) {
        this.dayIndex = index;
    }

    @Override
    public IDate floor(IDate date) {
        IDate newDate = Day.INSTANCE.getValue(date);
        newDate.setDate(newDate.getDate() - (newDate.getDay() + this.dayIndex) % 7);
        return newDate;
    }

    @Override
    public void step(IDate date, int offset) {
        date.setDate((int)((double)date.getDate() + Math.floor(offset) * 7.0));
    }

    @Override
    public int number(IDate date) {
        int day = Year.INSTANCE.getValue(date).getDay();
        return (int)(Math.floor((TimeUtil.dayOfYear(date) + (day + this.dayIndex) % 7) / 7) - (double)ObjectConverter.toNumber(day != this.dayIndex));
    }
}

