/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.transform;

public final class Matrix {
    public double a;
    public double b;
    public double c;
    public double d;
    public double e;
    public double f;

    public Matrix(double a, double b, double c, double d, double e, double f) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.e = e;
        this.f = f;
    }

    private static Matrix identity() {
        return new Matrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public Matrix multiply(Matrix matrix) {
        double a1 = matrix.a * this.a + matrix.b * this.c;
        double b1 = matrix.a * this.b + matrix.b * this.d;
        double c1 = matrix.c * this.a + matrix.d * this.c;
        double d1 = matrix.c * this.b + matrix.d * this.d;
        double e1 = matrix.e * this.a + matrix.f * this.c + this.e;
        double f1 = matrix.e * this.b + matrix.f * this.d + this.f;
        return new Matrix(a1, b1, c1, d1, e1, f1);
    }

    public Matrix inverse() {
        double determinant = this.a * this.d - this.b * this.c;
        if (determinant == 0.0) {
            return Matrix.identity();
        }
        double a1 = this.d / determinant;
        double b1 = -this.b / determinant;
        double c1 = -this.c / determinant;
        double d1 = this.a / determinant;
        double e1 = (this.c * this.f - this.d * this.e) / determinant;
        double f1 = (this.b * this.e - this.a * this.f) / determinant;
        return new Matrix(a1, b1, c1, d1, e1, f1);
    }

    public Matrix translate(double x, double y) {
        double e1 = x * this.a + y * this.c + this.e;
        double f1 = x * this.b + y * this.d + this.f;
        return new Matrix(this.a, this.b, this.c, this.d, e1, f1);
    }

    public Matrix scale(double scaleFactor) {
        return this.scaleNonUniform(scaleFactor, scaleFactor);
    }

    public Matrix scaleNonUniform(double scaleFactorX, double scaleFactorY) {
        double a1 = this.a * scaleFactorX;
        double b1 = this.b * scaleFactorX;
        double c1 = this.c * scaleFactorY;
        double d1 = this.d * scaleFactorY;
        return new Matrix(a1, b1, c1, d1, this.e, this.f);
    }

    public Matrix rotate(double angle) {
        double rads = Matrix.degreesToRadians(angle);
        double sin = Math.sin(rads);
        double cos = Math.cos(rads);
        return this.multiply(new Matrix(cos, sin, -sin, cos, 0.0, 0.0));
    }

    public Matrix rotate(double angle, double originX, double originY) {
        return this.translate(originX, originY).rotate(angle).translate(-originX, -originY);
    }

    public Matrix rotateFromVector(double x, double y) {
        return this.rotate(Matrix.radiansToDegrees(Math.atan2(y, x)));
    }

    public Matrix flipX() {
        return this.scaleNonUniform(-1.0, 1.0);
    }

    public Matrix flipY() {
        return this.scaleNonUniform(1.0, -1.0);
    }

    public Matrix skewX(double angle) {
        return this.skew(angle, 0.0);
    }

    public Matrix skewY(double angle) {
        return this.skew(0.0, angle);
    }

    private Matrix skew(double horizontalAngle, double verticalAngle) {
        Matrix newMatrix = Matrix.identity();
        newMatrix.c = Math.tan(Matrix.degreesToRadians(horizontalAngle));
        newMatrix.b = Math.tan(Matrix.degreesToRadians(verticalAngle));
        return this.multiply(newMatrix);
    }

    private static final double radiansToDegrees(double rads) {
        return rads * 180.0 / Math.PI;
    }

    private static final double degreesToRadians(double angle) {
        return angle * Math.PI / 180.0;
    }

    public String toString() {
        return "matrix(" + this.a + ',' + this.b + ',' + this.c + ',' + this.d + ',' + this.e + ',' + this.f + ')';
    }
}

