/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.transition;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.ease.Easing;
import com.ibm.vida.rave.core.ease.EasingFunction;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.internal.nativeImpl.PlatformInitialization;
import com.ibm.vida.rave.core.internal.nativeImpl.transitions.InheritedTransition;
import com.ibm.vida.rave.core.internal.selector.SelectorHelper;
import com.ibm.vida.rave.core.internal.transitions.TransitionInfo;
import com.ibm.vida.rave.core.internal.transitions.TransitionTracker;
import com.ibm.vida.rave.core.internal.transitions.TransitionUtil;
import com.ibm.vida.rave.core.internal.transitions.TweenFunctions;
import com.ibm.vida.rave.core.internal.transitions.Tweener;
import com.ibm.vida.rave.core.internal.util.NamespaceUtil;
import com.ibm.vida.rave.core.internal.util.QueryUtil;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selection;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.SelectorGroup;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.transition.TransitionCollector;
import com.ibm.vida.rave.core.transition.TransitionInterpolatorFactory;
import com.ibm.vida.rave.core.transition.Tween;
import com.ibm.vida.rave.core.util.QName;
import java.util.List;

public final class Transition
extends Selection<Transition> {
    @InlineStringConstant
    private static final String TRANSITION_ID_COUNT_KEY = "TRANSITION_ID_COUNT_KEY";
    private RunFunction<Transition> _endedCallback;
    @InlineStringConstant
    private static final String TEXT_PREFIX = "text";
    @InlineStringConstant
    private static final String ATTR_PREFIX = "attr.";
    @InlineStringConstant
    private static final String STYLE_PREFIX = "style.";
    private final int id;
    private final String namespace;

    private static TransitionIdCount getTransitionIdCount() {
        TransitionIdCount transitionIdCount = (TransitionIdCount)RaveContextManager.INSTANCE.getRaveContext().getData(TRANSITION_ID_COUNT_KEY);
        if (transitionIdCount == null) {
            transitionIdCount = new TransitionIdCount();
            RaveContextManager.INSTANCE.getRaveContext().putData(TRANSITION_ID_COUNT_KEY, transitionIdCount);
        }
        return transitionIdCount;
    }

    public static Transition newTransition() {
        return new Selector().init(PlatformInitialization.getDocumentElement(PlatformInitialization.getDocument())).transition(null);
    }

    public static Transition newTransition(String name) {
        return new Selector().init(PlatformInitialization.getDocumentElement(PlatformInitialization.getDocument())).transition(name);
    }

    public final int getId() {
        return this.id;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public static Selection<?> newTransition(Selection<?> selection) {
        return Transition.newTransition(selection, null);
    }

    public static Selection<?> newTransition(Selection<?> selection, String name) {
        if (selection != null && InheritedTransition.get() != null) {
            return selection.transition(name);
        }
        return selection;
    }

    public static Transition create(Selector selector, String name) {
        TransitionIdCount transitionIdCount = Transition.getTransitionIdCount();
        int id = ++transitionIdCount.idCount;
        String namespace = TransitionUtil.transitionNamespace(name);
        Transition subgroups = new Transition(id, namespace);
        int m = selector.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)selector.get(j);
            SelectorGroup subgroup = new SelectorGroup();
            subgroups.add(subgroup);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node != null) {
                    TransitionInfo info = TransitionUtil.getTransitionInfo(node, namespace, id);
                    Transition trans = info.getTransition();
                    if (trans != null && trans != subgroups) {
                        TransitionCollector.removeTransition(trans);
                    }
                    info.setTransition(subgroups);
                    info.setIndex(i);
                    info.setGroupIndex(j);
                }
                subgroup.add(node);
            }
        }
        return subgroups;
    }

    public static Transition create(Selector selector, TransitionInfo inherit) {
        return Transition.create(selector, null, inherit);
    }

    public static Transition create(Selector selector, String name, TransitionInfo inherit) {
        String namespace = TransitionUtil.transitionNamespace(name);
        Transition subgroups = new Transition(inherit.getTransitionId(), namespace);
        int m = selector.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)selector.get(j);
            SelectorGroup subgroup = new SelectorGroup();
            subgroups.add(subgroup);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node != null) {
                    TransitionInfo info = TransitionUtil.getTransitionInfo(node, namespace, inherit.getTransitionId());
                    info.setIndex(i);
                    Transition trans = info.getTransition();
                    if (trans != null && trans != subgroups) {
                        TransitionCollector.removeTransition(trans);
                    }
                    info.setTransition(subgroups);
                    info.setGroupIndex(j);
                    info.setDelay(inherit.getDelay());
                    info.setDuration(inherit.getDuration());
                    info.setEase(inherit.getEase());
                }
                subgroup.add(node);
            }
        }
        return subgroups;
    }

    private Transition(int id, String transitionNamespace) {
        this.namespace = transitionNamespace;
        this.id = id;
        TransitionCollector.addTransition(this);
        Tweener.schedule(this);
    }

    public double delay() {
        SceneNode node = this.node();
        return node != null ? TransitionUtil.getTransitionInfo(node, this.namespace, this.id).getDelay() : 0.0;
    }

    public Transition delay(Object delay) {
        final double d = ObjectConverter.toDouble(delay);
        final int transitionId = this.id;
        final String transitionNamespace = this.namespace;
        return SelectorHelper.each(this, (CallbackFunction<? super SceneNode>)new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                TransitionUtil.getTransitionInfo(context, transitionNamespace, transitionId).setDelay(d);
            }
        });
    }

    public Transition delay(final ValueFunction<? super SceneNode, ?> delayFunction) {
        final int transitionId = this.id;
        final String transitionNamespace = this.namespace;
        return SelectorHelper.each(this, (CallbackFunction<? super SceneNode>)new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                TransitionUtil.getTransitionInfo(context, transitionNamespace, transitionId).setDelay(ObjectConverter.toDouble(delayFunction.getValue(context, context.getData(), index, groupIndex)));
            }
        });
    }

    public double duration() {
        SceneNode node = this.node();
        return node != null ? TransitionUtil.getTransitionInfo(node, this.namespace, this.id).getDuration() : 250.0;
    }

    public Transition duration(Object duration) {
        final int transitionId = this.id;
        final String transitionNamespace = this.namespace;
        final double d = Math.max(1.0, ObjectConverter.toDouble(duration));
        return SelectorHelper.each(this, (CallbackFunction<? super SceneNode>)new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                TransitionUtil.getTransitionInfo(context, transitionNamespace, transitionId).setDuration(d);
            }
        });
    }

    public Transition duration(final ValueFunction<? super SceneNode, ?> durationFunction) {
        final int transitionId = this.id;
        final String transitionNamespace = this.namespace;
        return SelectorHelper.each(this, (CallbackFunction<? super SceneNode>)new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                double d = ObjectConverter.toDouble(durationFunction.getValue(context, data, index, groupIndex));
                TransitionUtil.getTransitionInfo(context, transitionNamespace, transitionId).setDuration(Math.max(1.0, d));
            }
        });
    }

    public EasingFunction ease() {
        SceneNode node = this.node();
        return node != null ? TransitionUtil.getTransitionInfo(node, this.namespace, this.id).getEase() : Easing.DEFAULT;
    }

    public Transition ease(String name, Object ... args) {
        return this.ease(Easing.INSTANCE.ease(name, args));
    }

    public Transition ease(final EasingFunction easeFunction) {
        final int transitionId = this.id;
        final String transitionNamespace = this.namespace;
        return SelectorHelper.each(this, (CallbackFunction<? super SceneNode>)new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                TransitionUtil.getTransitionInfo(context, transitionNamespace, transitionId).setEase(easeFunction);
            }
        });
    }

    @Override
    public Transition attr(String attribute, Object value) {
        final QName qname = NamespaceUtil.getQName(attribute);
        return TweenFunctions.tween(this, ATTR_PREFIX + attribute, value, new TweenFunctions.GetTween(){

            @Override
            public ValueFunction<SceneNode, Tween<SceneNode>> getTween(Object v) {
                return TweenFunctions.attr(qname, v);
            }
        });
    }

    @Override
    public Transition attr(String attribute, ValueFunction<? super SceneNode, ?> value) {
        return this.attr(attribute, (Object)value);
    }

    public Transition attrTween(String attribute, TransitionInterpolatorFactory<SceneNode> factory) {
        QName qname = NamespaceUtil.getQName(attribute);
        return this.tween(ATTR_PREFIX + attribute, TweenFunctions.attrTween(qname, factory));
    }

    @Override
    public Transition text(Object value) {
        return TweenFunctions.tween(this, TEXT_PREFIX, value, new TweenFunctions.GetTween(){

            @Override
            public ValueFunction<SceneNode, Tween<SceneNode>> getTween(Object v) {
                final String textValue = v == null ? "" : v + "";
                return new ValueFunction<SceneNode, Tween<SceneNode>>(){

                    @Override
                    public Tween<SceneNode> getValue(SceneNode context, Object data, int index, int groupIndex) {
                        context.setText(textValue);
                        return null;
                    }
                };
            }
        });
    }

    @Override
    public Transition text(ValueFunction<? super SceneNode, ?> value) {
        return this.text((Object)value);
    }

    @Override
    public Transition style(String styleName, Object value) {
        return this.style(styleName, value, null);
    }

    @Override
    public Transition style(final String styleName, Object value, String priority) {
        final String p = priority != null ? priority : "";
        return TweenFunctions.tween(this, STYLE_PREFIX + styleName, value, new TweenFunctions.GetTween(){

            @Override
            public ValueFunction<SceneNode, Tween<SceneNode>> getTween(Object v) {
                return TweenFunctions.style(styleName, v, p);
            }
        });
    }

    @Override
    public Transition style(String attribute, ValueFunction<? super SceneNode, ?> value) {
        return this.style(attribute, (Object)value, null);
    }

    @Override
    public Transition style(String attribute, ValueFunction<? super SceneNode, ?> value, String priority) {
        return this.style(attribute, (Object)value, priority);
    }

    public Transition styleTween(String styleName, TransitionInterpolatorFactory<SceneNode> factory) {
        return this.styleTween(styleName, factory, null);
    }

    public Transition styleTween(String styleName, TransitionInterpolatorFactory<SceneNode> factory, String priority) {
        return this.tween(STYLE_PREFIX + styleName, TweenFunctions.styleTween(styleName, factory, priority != null ? priority : ""));
    }

    public Transition tween(final String name, final ValueFunction<SceneNode, Tween<SceneNode>> factory) {
        final int transitionId = this.id;
        final String transitionName = this.namespace;
        return SelectorHelper.each(this, (CallbackFunction<? super SceneNode>)(factory == null ? new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                TransitionUtil.getTransitionInfo(context, transitionName, transitionId).removeTweenFactory(name);
            }
        } : new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                TransitionUtil.getTransitionInfo(context, transitionName, transitionId).addTweenFactory(name, factory);
            }
        }));
    }

    public ValueFunction<SceneNode, Tween<SceneNode>> tween(String tweenName) {
        SceneNode node = this.node();
        return node != null ? TransitionUtil.getTransitionInfo(node, this.namespace, this.id).getTweenFactory(tweenName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transition each(final CallbackFunction<? super SceneNode> callback) {
        final int transitionId = this.id;
        final String transitionNamespace = this.namespace;
        TransitionInfo inherit = InheritedTransition.get();
        try {
            Transition transition = SelectorHelper.each(this, (CallbackFunction<? super SceneNode>)new CallbackFunction<SceneNode>(){

                @Override
                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    TransitionInfo info = TransitionUtil.getTransitionInfo(context, transitionNamespace, transitionId);
                    InheritedTransition.set(info);
                    callback.run(context, data, index, groupIndex);
                }
            });
            return transition;
        }
        finally {
            InheritedTransition.set(inherit);
        }
    }

    @Override
    public Transition each(final String type, final RunFunction<? super SceneNode> listener) {
        final int transitionId = this.id;
        final String transitionNamespace = this.namespace;
        return SelectorHelper.each(this, (CallbackFunction<? super SceneNode>)new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                TransitionUtil.getTransitionInfo(context, transitionNamespace, transitionId).getOrCreateDispatcher().on(type, listener);
            }
        });
    }

    @Override
    public Transition remove() {
        final String transitionNamespace = this.namespace;
        return this.each("end.transition", new RunFunction<SceneNode>(){

            @Override
            public Object run(SceneNode node, Object ... args) {
                SceneNode p = node.getParentNode();
                TransitionTracker t = TransitionUtil.getTransitionTracker(node, transitionNamespace);
                if (t.count < 2 && p != null) {
                    p.removeChild(node);
                }
                return null;
            }
        });
    }

    @Override
    public Transition call(RunFunction<? super Transition> callback, Object ... args) {
        List<Object> list = Lang.toList(args);
        list.add(0, this);
        callback.run(this, list.toArray());
        return this;
    }

    @Override
    public Transition transition() {
        int parentId = this.id;
        TransitionIdCount transitionIdCount = Transition.getTransitionIdCount();
        int newId = ++transitionIdCount.idCount;
        String ns = this.namespace;
        Transition subgroups = new Transition(newId, ns);
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            SelectorGroup subgroup = new SelectorGroup();
            subgroups.add(subgroup);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node != null) {
                    TransitionInfo info = TransitionUtil.getTransitionInfo(node, ns, newId);
                    Transition trans = info.getTransition();
                    if (trans != null && trans != subgroups) {
                        TransitionCollector.removeTransition(trans);
                    }
                    info.setTransition(subgroups);
                    info.setIndex(i);
                    info.setGroupIndex(j);
                    TransitionInfo pinfo = TransitionUtil.getTransitionInfo(node, ns, parentId);
                    info.setDelay(pinfo.getDelay() + pinfo.getDuration());
                    info.setDuration(pinfo.getDuration());
                    info.setEase(pinfo.getEase());
                    info.setStartTime(pinfo.getStartTime());
                }
                subgroup.add(node);
            }
        }
        return subgroups;
    }

    @Override
    public Transition transition(String transitionNamespace) {
        return this.transition();
    }

    @Override
    public boolean isTransition() {
        return true;
    }

    @Override
    public Transition select(Object query) {
        return this.select(SelectorHelper.selector(query));
    }

    @Override
    public Transition select(ValueFunction<? super SceneNode, SceneNode> valueFunction) {
        Transition subgroups = new Transition(this.id, this.namespace);
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            SelectorGroup subgroup = new SelectorGroup();
            subgroups.add(subgroup);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node != null) {
                    SceneNode subnode = valueFunction.getValue(node, node.getData(), i, j);
                    subgroup.add(subnode);
                    if (subnode == null) continue;
                    if (node.hasData()) {
                        subnode.setData(node.getData());
                    }
                    TransitionInfo inherit = TransitionUtil.getTransitionInfo(node, this.namespace, this.id);
                    TransitionInfo info = TransitionUtil.getTransitionInfo(subnode, this.namespace, this.id);
                    Transition trans = info.getTransition();
                    if (trans != null && trans != subgroups) {
                        TransitionCollector.removeTransition(trans);
                    }
                    info.setTransition(subgroups);
                    info.setIndex(i);
                    info.setGroupIndex(j);
                    info.setDelay(inherit.getDelay());
                    info.setDuration(inherit.getDuration());
                    info.setEase(inherit.getEase());
                    continue;
                }
                subgroup.add(null);
            }
        }
        return subgroups;
    }

    @Override
    public Transition selectAll(String query) {
        return this.selectAll(SelectorHelper.selectorAll(query));
    }

    @Override
    public Transition selectAll(ValueFunction<? super SceneNode, List<SceneNode>> selector) {
        Transition subgroups = new Transition(this.id, this.namespace);
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                SelectorGroup subgroup = new SelectorGroup();
                List<SceneNode> subnodes = selector.getValue(node, node.getData(), i, j);
                subgroups.add(subgroup);
                TransitionInfo inherit = TransitionUtil.getTransitionInfo(node, this.namespace, this.id);
                int o = subnodes.size();
                for (int k = 0; k < o; ++k) {
                    SceneNode subnode = subnodes.get(k);
                    if (subnode != null) {
                        TransitionInfo info = TransitionUtil.getTransitionInfo(subnode, this.namespace, this.id);
                        Transition trans = info.getTransition();
                        if (trans != null && trans != subgroups) {
                            TransitionCollector.removeTransition(trans);
                        }
                        info.setTransition(subgroups);
                        info.setIndex(k);
                        info.setGroupIndex(i);
                        info.setDelay(inherit.getDelay());
                        info.setDuration(inherit.getDuration());
                        info.setEase(inherit.getEase());
                    }
                    subgroup.add(subnode);
                }
            }
        }
        return subgroups;
    }

    @Override
    public Transition filter(final String filter) {
        return this.filter(new ValueFunction<SceneNode, Boolean>(){

            @Override
            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                return QueryUtil.getQueryEngine(context).matches(context, filter);
            }
        });
    }

    @Override
    public Transition filter(ValueFunction<? super SceneNode, Boolean> filterFunction) {
        Transition subgroups = new Transition(this.id, this.namespace);
        int m = this.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup subgroup = new SelectorGroup();
            subgroups.add(subgroup);
            SelectorGroup group = (SelectorGroup)this.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null || !filterFunction.getValue(node, node.getData(), i, j).booleanValue()) continue;
                subgroup.add(node);
            }
        }
        return subgroups;
    }

    @Override
    public boolean isEmpty() {
        boolean empty = true;
        for (int i = 0; i < this.length(); ++i) {
            if (this.get(i) == null || ((SelectorGroup)this.get(i)).isEmpty()) continue;
            empty = false;
            break;
        }
        return empty;
    }

    @Deprecated
    public void transitionEndedCallback(RunFunction<Transition> callback) {
        this._endedCallback = callback;
    }

    @Deprecated
    public void nodeTransitionComplete() {
        if (this._endedCallback != null) {
            this._endedCallback.run(this, new Object[0]);
        }
    }

    private static class TransitionIdCount {
        int idCount = 0;

        private TransitionIdCount() {
        }
    }
}

