/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.transition;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.transition.Transition;
import java.util.List;

public class TransitionCollector {
    @InlineStringConstant
    private static final String TRANSITIONS_LIST_KEY = "TRANSITIONS_LIST_KEY";

    public static boolean isCollectingTransitions() {
        return RaveContextManager.INSTANCE.getRaveContext().getData(TRANSITIONS_LIST_KEY) != null;
    }

    public static void startCollectingTransitions() {
        RaveContextManager.INSTANCE.getRaveContext().putData(TRANSITIONS_LIST_KEY, new ArrayEx());
    }

    public static List<Transition> stopCollectingTransitions() {
        ArrayEx list = (ArrayEx)RaveContextManager.INSTANCE.getRaveContext().getData(TRANSITIONS_LIST_KEY);
        RaveContextManager.INSTANCE.getRaveContext().removeData(TRANSITIONS_LIST_KEY);
        ArrayEx<Transition> transitions = null;
        if (list != null) {
            transitions = new ArrayEx<Transition>();
            for (int i = 0; i < list.size(); ++i) {
                if (((TransitionData)list.get((int)i))._complete) continue;
                transitions.add(((TransitionData)list.get((int)i))._transition);
            }
        }
        return transitions;
    }

    static boolean addTransition(Transition trans) {
        ArrayEx transitionList = (ArrayEx)RaveContextManager.INSTANCE.getRaveContext().getData(TRANSITIONS_LIST_KEY);
        if (transitionList != null) {
            TransitionData data = new TransitionData(trans);
            transitionList.add(data);
            return true;
        }
        return false;
    }

    public static void monitorTransitions() {
        ArrayEx transitionList = (ArrayEx)RaveContextManager.INSTANCE.getRaveContext().getData(TRANSITIONS_LIST_KEY);
        if (transitionList != null) {
            for (int i = 0; i < transitionList.size(); ++i) {
                TransitionData transData = (TransitionData)transitionList.get(i);
                if (transData._monitored) continue;
                TransitionCompleteMonitor tm = new TransitionCompleteMonitor(transData, transData._transition.size());
                transData._transition.transitionEndedCallback(tm);
                transData._monitored = true;
            }
        }
    }

    public static void removeTransition(Transition transition) {
        ArrayEx transitionList = (ArrayEx)RaveContextManager.INSTANCE.getRaveContext().getData(TRANSITIONS_LIST_KEY);
        if (transitionList != null) {
            for (int i = 0; i < transitionList.size(); ++i) {
                Transition trans = ((TransitionData)transitionList.get((int)i))._transition;
                if (trans != transition) continue;
                transitionList.splice(i, 1, new TransitionData[0]);
                i = transitionList.size();
            }
        }
    }

    private static class TransitionCompleteMonitor
    implements RunFunction<Transition> {
        private int _count;
        TransitionData _data;

        TransitionCompleteMonitor(TransitionData data, int count) {
            this._count = count;
            this._data = data;
        }

        @Override
        public Object run(Transition context, Object ... args) {
            --this._count;
            if (this._count == 0) {
                this._data._complete = true;
            }
            return null;
        }
    }

    private static class TransitionData {
        final Transition _transition;
        boolean _complete;
        boolean _monitored;

        public TransitionData(Transition transition) {
            this._transition = transition;
            this._complete = false;
            this._monitored = false;
        }
    }
}

