/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.accessibility;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.accessibility.internal.AccessibilityUtil;
import com.ibm.vida.rave.accessibility.internal.AccessibleNavigationSceneNodeExtension;
import com.ibm.vida.rave.accessibility.navigation.AccessibleNavigation;
import com.ibm.vida.rave.core.context.RaveContextManager;

public final class Accessibility {
    public static final String ACCESSIBLE_INFO_KEY = "__accessibleInfo__";
    public static final String SHADOW_TREE_BUILDER_KEY = "__shadowTreeBuilder__";
    public static final String SELECTOR_ID = "raveAccessibility";
    public static final AccessibleNavigation navigation = AccessibleNavigation.INSTANCE;
    @InlineStringConstant
    private static final String EXTENSION_REGISTRATION_STATUS_KEY = "ACCESSIBILITY_EXTENSION_REGISTRATION_STATUS_KEY";

    private Accessibility() {
    }

    private static RegistrationStatus getRegistrationStatus() {
        RegistrationStatus registrationStatus = (RegistrationStatus)RaveContextManager.INSTANCE.getRaveContext().getData(EXTENSION_REGISTRATION_STATUS_KEY);
        if (registrationStatus == null) {
            registrationStatus = new RegistrationStatus();
            RaveContextManager.INSTANCE.getRaveContext().putData(EXTENSION_REGISTRATION_STATUS_KEY, (Object)registrationStatus);
        }
        return registrationStatus;
    }

    public static void init() {
        RegistrationStatus registrationStatus = Accessibility.getRegistrationStatus();
        if (!registrationStatus.registered) {
            AccessibleNavigationSceneNodeExtension.register();
            AccessibilityUtil.registerSelector();
            registrationStatus.registered = true;
        }
    }

    private static class RegistrationStatus {
        boolean registered = false;

        private RegistrationStatus() {
        }
    }
}

