/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.accessibility.internal;

import com.ibm.vida.rave.accessibility.ShadowTreeBuilder;
import com.ibm.vida.rave.accessibility.selector.AccessibilitySelector;
import com.ibm.vida.rave.core.ExtensionFactory;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.SelectorDelegate;

public final class AccessibilityUtil {
    private AccessibilityUtil() {
    }

    public static ShadowTreeBuilder getShadowTreeBuilder(SceneNode node) {
        return (ShadowTreeBuilder)node.getProperty("__shadowTreeBuilder__");
    }

    public static boolean hasAccessibleInfo(SceneNode node) {
        return node.getProperty("__accessibleInfo__") != null;
    }

    public static void recursiveSetShadowTreeBuilder(SceneNode node, ShadowTreeBuilder builder) {
        node.setProperty("__shadowTreeBuilder__", (Object)builder);
        if (node.hasChildNodes()) {
            for (SceneNode child : node.getChildNodes()) {
                AccessibilityUtil.recursiveSetShadowTreeBuilder(child, builder);
            }
        }
    }

    public static void registerSelector() {
        Selector.extension((String)"raveAccessibility", (ExtensionFactory)new ExtensionFactory<SelectorDelegate>(){

            public SelectorDelegate create() {
                return new AccessibilitySelector();
            }
        });
    }
}

