/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.accessibility.internal;

import com.ibm.vida.rave.accessibility.ShadowTreeBuilder;
import com.ibm.vida.rave.accessibility.internal.AccessibilityUtil;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.scene.SceneNodeExtensionFactory;

public final class AccessibleNavigationSceneNodeExtension {
    private AccessibleNavigationSceneNodeExtension() {
    }

    public static final void extend(SceneNode baseNode) {
        final SceneNode.AppendChildExtension oriAppendChild = baseNode.appendChildExt;
        baseNode.appendChildExt = new SceneNode.AppendChildExtension(){

            public void appendChild(SceneNode context, SceneNode node) {
                oriAppendChild.appendChild(context, node);
                Rave.configuration.extendRecursive(node);
                ShadowTreeBuilder builder = AccessibilityUtil.getShadowTreeBuilder(context);
                if (builder != null) {
                    AccessibilityUtil.recursiveSetShadowTreeBuilder(node, builder);
                    builder.onAppend(context, node);
                }
            }
        };
        final SceneNode.InsertBeforeExtension oriInsertBefore = baseNode.insertBeforeExt;
        baseNode.insertBeforeExt = new SceneNode.InsertBeforeExtension(){

            public void insertBefore(SceneNode context, SceneNode node, SceneNode before) {
                oriInsertBefore.insertBefore(context, node, before);
                Rave.configuration.extendRecursive(node);
                ShadowTreeBuilder builder = AccessibilityUtil.getShadowTreeBuilder(context);
                if (builder != null) {
                    AccessibilityUtil.recursiveSetShadowTreeBuilder(node, builder);
                    builder.onInsert(context, node, before);
                }
            }
        };
        final SceneNode.RemoveChildExtension oriRemoveChild = baseNode.removeChildExt;
        baseNode.removeChildExt = new SceneNode.RemoveChildExtension(){

            public boolean removeChild(SceneNode context, SceneNode node) {
                int i = context.getChildNodes().indexOf(node);
                if (i != -1) {
                    oriRemoveChild.removeChild(context, node);
                    Rave.configuration.extendRecursive(node);
                    ShadowTreeBuilder builder = AccessibilityUtil.getShadowTreeBuilder(node);
                    if (builder != null) {
                        builder.onRemove(context, node, i);
                        AccessibilityUtil.recursiveSetShadowTreeBuilder(node, null);
                    }
                    return true;
                }
                return false;
            }
        };
        final SceneNode.SetPropertyExtension oriSetProperty = baseNode.setPropertyExt;
        baseNode.setPropertyExt = new SceneNode.SetPropertyExtension(){

            public void setProperty(SceneNode context, String key, Object value) {
                ShadowTreeBuilder builder;
                oriSetProperty.setProperty(context, key, value);
                if ("__accessibleInfo__".equals(key) && (builder = AccessibilityUtil.getShadowTreeBuilder(context)) != null) {
                    builder.onChange(context);
                }
            }
        };
    }

    public static void register() {
        Rave.configuration.addSceneNodeExtensionFactory("http://www.w3.org/2000/svg", new SceneNodeExtensionFactory(){

            public void extend(SceneNode node, SceneNode context) {
                if (context != null && context.hasProperty("__shadowTreeBuilder__") || node.hasProperty("__shadowTreeBuilder__")) {
                    AccessibleNavigationSceneNodeExtension.extend(node);
                }
            }
        }, 0);
    }
}

