/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.layout;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.ExtensionFactory;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.ext.layout.SplitPosNegStackLayout;
import com.ibm.vida.rave.ext.layout.bubble.BubbleLayout;
import com.ibm.vida.rave.ext.layout.cloud.CloudDataNode;
import com.ibm.vida.rave.ext.layout.cloud.CloudLayout;
import com.ibm.vida.rave.ext.layout.fill.FillLayout;
import com.ibm.vida.rave.ext.layout.fill.FillNode;
import com.ibm.vida.rave.ext.layout.hexbin.Hexbin;

public final class RaveLayout {
    public static final String BUBBLE = "bubble";
    public static final String FILL = "fill";
    public static final String CLOUD = "cloud";
    public static final String HEXBIN = "hexbin";
    public static final String SPLITPOSNEG = "splitposneg";
    @InlineStringConstant
    private static final String EXTENSION_REGISTRATION_STATUS_KEY = "RAVELAYOUT_EXTENSION_REGISTRATION_STATUS_KEY";

    public static BubbleLayout bubble() {
        return new BubbleLayout();
    }

    public static FillLayout<FillNode> fill() {
        return new FillLayout<FillNode>();
    }

    public static Hexbin hexbin() {
        return new Hexbin();
    }

    public static CloudLayout<CloudDataNode> cloud() {
        return new CloudLayout<CloudDataNode>();
    }

    public static SplitPosNegStackLayout splitPosNegStackLayout() {
        return new SplitPosNegStackLayout();
    }

    private static RegistrationStatus getRegistrationStatus() {
        RegistrationStatus registrationStatus = (RegistrationStatus)RaveContextManager.INSTANCE.getRaveContext().getData(EXTENSION_REGISTRATION_STATUS_KEY);
        if (registrationStatus == null) {
            registrationStatus = new RegistrationStatus();
            RaveContextManager.INSTANCE.getRaveContext().putData(EXTENSION_REGISTRATION_STATUS_KEY, (Object)registrationStatus);
        }
        return registrationStatus;
    }

    public static boolean init() {
        RegistrationStatus registrationStatus = RaveLayout.getRegistrationStatus();
        if (!registrationStatus.registered) {
            registrationStatus.registered = Rave.layout.extension(BUBBLE, (ExtensionFactory)new ExtensionFactory<BubbleLayout>(){

                public BubbleLayout create() {
                    return RaveLayout.bubble();
                }
            });
            registrationStatus.registered &= Rave.layout.extension(FILL, (ExtensionFactory)new ExtensionFactory<FillLayout<FillNode>>(){

                public FillLayout<FillNode> create() {
                    return RaveLayout.fill();
                }
            });
            registrationStatus.registered &= Rave.layout.extension(HEXBIN, (ExtensionFactory)new ExtensionFactory<Hexbin>(){

                public Hexbin create() {
                    return RaveLayout.hexbin();
                }
            });
            registrationStatus.registered &= Rave.layout.extension(CLOUD, (ExtensionFactory)new ExtensionFactory<CloudLayout<CloudDataNode>>(){

                public CloudLayout<CloudDataNode> create() {
                    return RaveLayout.cloud();
                }
            });
            registrationStatus.registered &= Rave.layout.extension(SPLITPOSNEG, (ExtensionFactory)new ExtensionFactory<SplitPosNegStackLayout>(){

                public SplitPosNegStackLayout create() {
                    return RaveLayout.splitPosNegStackLayout();
                }
            });
        }
        return registrationStatus.registered;
    }

    private static class RegistrationStatus {
        boolean registered = false;

        private RegistrationStatus() {
        }
    }
}

