/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.layout;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.layout.StackLayout;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;
import java.util.List;

public class SplitPosNegStackLayout
extends StackLayout {
    private static ValueFunction<Object, ArrayEx<? extends Number>> STACKOFFSET_POSNEGSILHOUETTE = new ValueFunction<Object, ArrayEx<? extends Number>>(){

        public ArrayEx<Double> getValue(Object context, Object data, int index, int groupIndex) {
            double val;
            ArrayEx aData = (ArrayEx)data;
            int n = aData.length();
            int m = ((ArrayEx)aData.get(0)).length();
            ArrayEx midPoints = new ArrayEx();
            double max = Double.NEGATIVE_INFINITY;
            double min = Double.POSITIVE_INFINITY;
            ArrayEx y0 = new ArrayEx();
            for (int j = 0; j < m; ++j) {
                Double oPos = null;
                Double oNeg = null;
                for (int i = 0; i < n; ++i) {
                    val = (Double)((ArrayEx)((ArrayEx)aData.get(i)).get(j)).get(1);
                    if (val < 0.0) {
                        if (oNeg == null) {
                            oNeg = val;
                            continue;
                        }
                        oNeg = oNeg + val;
                        continue;
                    }
                    oPos = oPos == null ? Double.valueOf(val) : Double.valueOf(oPos + val);
                }
                if (oPos != null) {
                    if (oPos > max) {
                        max = oPos;
                    }
                    if (oPos < min) {
                        min = oPos;
                    }
                } else {
                    oPos = 0.0;
                }
                if (oNeg != null) {
                    if (oNeg > max) {
                        max = oNeg;
                    }
                    if (oNeg < min) {
                        min = oNeg;
                    }
                } else {
                    oNeg = 0.0;
                }
                midPoints.push((Object[])new Double[]{(oNeg + oPos) / 2.0});
            }
            Double midPoint = (min + max) / 2.0;
            for (int j = 0; j < m; ++j) {
                val = (Double)midPoints.get(j);
                y0.set(j, (Object)(midPoint - (Double)midPoints.get(j)));
            }
            return y0;
        }
    };

    public ArrayEx<?> stack(ArrayEx<?> data, int index) {
        ArrayEx<?> objData = data;
        int n = data.length();
        if (n == 0) {
            return data;
        }
        final SplitPosNegStackLayout self = this;
        ArrayEx series = objData.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, ArrayEx<Object>>(){

            public ArrayEx<Object> getValue(Object currentValue, int currentIndex, ArrayEx<Object> array) {
                return (ArrayEx)self.valuesFn.getValue((Object)self, currentValue, currentIndex, -1);
            }
        });
        ArrayEx points = series.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<ArrayEx<Object>, ArrayEx<ArrayEx<Double>>>(){

            public ArrayEx<ArrayEx<Double>> getValue(ArrayEx<Object> currentValue, int notUsedindex, ArrayEx<ArrayEx<Object>> notUsedarray) {
                return currentValue.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Object, ArrayEx<Double>>(){

                    public ArrayEx<Double> getValue(Object pointsCurrentValue, int pointIndex, ArrayEx<Object> pointArray) {
                        double xVal = ObjectConverter.toDouble((Object)self.xFn.getValue((Object)self, pointsCurrentValue, pointIndex, -1));
                        double yVal = ObjectConverter.toDouble((Object)self.yFn.getValue((Object)self, pointsCurrentValue, pointIndex, -1));
                        return new ArrayEx((Object[])new Double[]{xVal, yVal});
                    }
                });
            }
        });
        ArrayEx orders = (ArrayEx)this.orderFn.getValue((Object)this, (Object)points, index, -1);
        series = Rave.permute((List)series, (List)orders);
        points = Rave.permute((List)points, (List)orders);
        ArrayEx offsets = (ArrayEx)this.offsetFn.getValue((Object)this, (Object)points, index, -1);
        int m = ((ArrayEx)series.get(0)).length();
        for (int j = 0; j < m; ++j) {
            double o;
            double posAccumulatedVal = o = ObjectConverter.asDouble((Object)offsets.get(j)).doubleValue();
            double negAccumulatedVal = o;
            double lastVal = (Double)((ArrayEx)((ArrayEx)points.get(0)).get(j)).get(1);
            this.outFn.updateValue((Object)this, ((ArrayEx)series.get(0)).get(j), o, (Object)lastVal);
            this.outFn.updateValue((Object)this, ((ArrayEx)series.get(0)).get(j), o, (Object)lastVal);
            for (int i = 1; i < n; ++i) {
                double currentVal = (Double)((ArrayEx)((ArrayEx)points.get(i)).get(j)).get(1);
                if (lastVal < 0.0) {
                    negAccumulatedVal += lastVal;
                } else {
                    posAccumulatedVal += lastVal;
                }
                this.outFn.updateValue((Object)this, ((ArrayEx)series.get(i)).get(j), posAccumulatedVal, (Object)currentVal);
                this.outFn.updateValue((Object)this, ((ArrayEx)series.get(i)).get(j), negAccumulatedVal, (Object)currentVal);
                lastVal = currentVal;
            }
        }
        return data;
    }

    public StackLayout offset(String offsetType) {
        if (offsetType.equals("silhouette")) {
            this.offsetFn = STACKOFFSET_POSNEGSILHOUETTE;
            return this;
        }
        return super.offset(offsetType);
    }
}

