/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.layout.cloud;

import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.event.Dispatcher;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.graphicUtils.Canvas;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.nativeImpl.EventQueue;
import com.ibm.vida.rave.core.nativeImpl.graphicUtils.RenderingContext;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.util.Comparator;
import com.ibm.vida.rave.core.util.Runnable;
import com.ibm.vida.rave.ext.layout.cloud.CloudDataNode;
import com.ibm.vida.rave.ext.layout.cloud.nativeImpl.GraphicContextUtil;

public class CloudLayout<T extends CloudDataNode> {
    private static final double AREA_INCREASE_PERCENT = 1.4;
    private static final double DIMENSION_INCREASE_PERCENT = 2.0;
    private static final int WORD_LETTER_MAX_LENGTH = 50;
    private static final String ARCHIMEDEAN = "archimedean";
    private static final double CONSTANT_LAYOUT = 0.5;
    private static final ValueFunction<Object, String> cloudText = new ValueFunction<Object, String>(){

        public String getValue(Object context, Object data, int index, int groupIndex) {
            return ((CloudDataNode)data).text;
        }
    };
    private static final ValueFunction<Object, String> cloudFont = new ValueFunction<Object, String>(){

        public String getValue(Object context, Object data, int index, int groupIndex) {
            return "serif";
        }
    };
    private static final ValueFunction<Object, String> cloudFontNormal = new ValueFunction<Object, String>(){

        public String getValue(Object context, Object data, int index, int groupIndex) {
            return "normal";
        }
    };
    private static final ValueFunction<Object, Double> cloudFontSize = new ValueFunction<Object, Double>(){

        public Double getValue(Object context, Object data, int index, int groupIndex) {
            return Math.sqrt(((CloudDataNode)data).value);
        }
    };
    private static final ValueFunction<Object, Integer> cloudRotate = new ValueFunction<Object, Integer>(){

        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((int)(CloudLayout.getRandom() * 6.0) - 3) * 30;
        }
    };
    private static final ValueFunction<Object, Integer> cloudPadding = new ValueFunction<Object, Integer>(){

        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return 1;
        }
    };
    private Runnable _step;
    private int ci = -1;
    private double[][] cbounds = null;
    private static final double cloudRadians = Math.PI / 180;
    private static final int context_width = 64;
    private static final int context_height = 2048;
    private double ratio = 1.0;
    private int[] _size = new int[]{256, 256};
    private int[] _areaSize = new int[]{0, 0};
    private ValueFunction<Object, String> _text = cloudText;
    private ValueFunction<Object, String> _font = cloudFont;
    private ValueFunction<Object, ? extends Number> _fontSize = cloudFontSize;
    private ValueFunction<Object, String> _fontStyle = cloudFontNormal;
    private ValueFunction<Object, String> _fontWeight = cloudFontNormal;
    private ValueFunction<Object, Integer> _rotate = cloudRotate;
    private ValueFunction<Object, Integer> _padding = cloudPadding;
    private SingleValueFunction<SingleValueFunction<Double[], Double>, int[]> _spiral = CloudLayout._archimedeanSpiral();
    private ArrayEx<T> _words;
    private double _timeInterval = Double.POSITIVE_INFINITY;
    @SwiftWeak(value=false)
    private Dispatcher<CloudLayout<T>> _event = Rave.dispatch((String[])new String[]{"word", "end", "step"});
    private Object _timer = null;
    private RenderingContext _context;
    private Integer _paddingValue = null;
    private String _fontWeightValue = null;
    private Integer _rotateValue = null;
    private String _fontStyleValue = null;
    private String _fontValue = null;
    private Double _fontSizeValue = null;
    private String _textValue = null;
    private static Boolean _isRandomised = true;

    private static final SingleValueFunction<SingleValueFunction<Double[], Double>, int[]> _archimedeanSpiral() {
        return new SingleValueFunction<SingleValueFunction<Double[], Double>, int[]>(){

            public SingleValueFunction<Double[], Double> getValue(int[] size) {
                final double e = (double)size[0] / (size[1] != 0 ? (double)size[1] : 1.0);
                return new SingleValueFunction<Double[], Double>(){

                    public Double[] getValue(Double t) {
                        double _t = t * 0.1;
                        Double a = e * _t * Math.cos(_t);
                        Double b = _t * Math.sin(_t);
                        Double[] result = new Double[]{a, b};
                        return result;
                    }
                };
            }
        };
    }

    private static final SingleValueFunction<SingleValueFunction<Double[], Double>, int[]> _rectangularSpiral() {
        return new SingleValueFunction<SingleValueFunction<Double[], Double>, int[]>(){

            public SingleValueFunction<Double[], Double> getValue(int[] size) {
                final double[] x = new double[]{0.0};
                final double[] y = new double[]{0.0};
                double dy = 4.0;
                final double dx = 4.0 * (double)size[0] / (double)size[1];
                return new SingleValueFunction<Double[], Double>(){

                    public Double[] getValue(Double t) {
                        double sign = t < 0.0 ? -1.0 : 1.0;
                        switch ((int)(Math.sqrt(1.0 + 4.0 * sign * t) - sign) & 3) {
                            case 0: {
                                x[0] = x[0] + dx;
                                break;
                            }
                            case 1: {
                                y[0] = y[0] + 4.0;
                                break;
                            }
                            case 2: {
                                x[0] = x[0] - dx;
                                break;
                            }
                            default: {
                                y[0] = y[0] - 4.0;
                            }
                        }
                        Double[] result = new Double[]{x[0], y[0]};
                        return result;
                    }
                };
            }
        };
    }

    private static int[] zeroArray(int n) {
        int[] a = new int[n];
        for (int i = 0; i < n; ++i) {
            a[i] = 0;
        }
        return a;
    }

    private static void cloudBounds(double[][] bounds, CloudDataNode d) {
        double[] b0 = bounds[0];
        double[] b1 = bounds[1];
        if ((double)d.x + d.x0 < b0[0]) {
            b0[0] = (double)d.x + d.x0;
        }
        if ((double)d.y + d.y0 < b0[1]) {
            b0[1] = (double)d.y + d.y0;
        }
        if ((double)d.x + d.x1 > b1[0]) {
            b1[0] = (double)d.x + d.x1;
        }
        if ((double)d.y + d.y1 > b1[1]) {
            b1[1] = (double)d.y + d.y1;
        }
    }

    public CloudLayout() {
        Canvas canvas;
        if (GraphicContextUtil.isDocumentDefined()) {
            canvas = Rave.canvas.create(1.0, 1.0);
            this.ratio = Math.sqrt(canvas.getContext((String)"2d", (Object[])new Object[0]).getImageData((double)0.0, (double)0.0, (double)1.0, (double)1.0).data.length >> 2);
            canvas.width = 2048.0 / this.ratio;
            canvas.height = 2048.0 / this.ratio;
        } else {
            canvas = Rave.canvas.create(2048.0, 2048.0);
        }
        this._context = canvas.getContext("2d", new Object[0]);
        this._context.strokeStyle = "red";
        this._context.fillStyle = "red";
        this._context.textAlign = "center";
    }

    public CloudLayout<T> on(String type, RunFunction<CloudLayout<T>> listener) {
        this._event.on(type, listener);
        return this;
    }

    private boolean cloudCollide(T tag, int[] board, int sw) {
        int _sw = sw;
        _sw >>= 5;
        ArrayEx<Integer> sprite = ((CloudDataNode)tag).sprite;
        int w = (int)((CloudDataNode)tag).width >> 5;
        int lx = ((CloudDataNode)tag).x - (w << 4);
        int sx = lx & 0x7F;
        int msx = 32 - sx;
        int h = (int)(((CloudDataNode)tag).y1 - ((CloudDataNode)tag).y0);
        int x = (int)((double)((CloudDataNode)tag).y + ((CloudDataNode)tag).y0) * _sw + (lx >> 5);
        for (int j = 0; j < h; ++j) {
            int last = 0;
            for (int i = 0; i <= w; ++i) {
                int n;
                int _sprite;
                int _board = x + i < board.length ? board[x + i] : 0;
                int n2 = _sprite = sprite == null || j * w + i >= sprite.size() ? 0 : (Integer)sprite.get(j * w + i);
                if (i < w) {
                    last = _sprite;
                    n = last >>> sx;
                } else {
                    n = 0;
                }
                if (((last << msx | n) & _board) == 0) continue;
                return true;
            }
            x += _sw;
        }
        return false;
    }

    private boolean collideRects(T a, double[][] bounds) {
        boolean test1 = (double)((CloudDataNode)a).x + ((CloudDataNode)a).x1 > bounds[0][0];
        boolean test2 = (double)((CloudDataNode)a).x + ((CloudDataNode)a).x0 < bounds[1][0];
        boolean test3 = (double)((CloudDataNode)a).y + ((CloudDataNode)a).y1 > bounds[0][1];
        boolean test4 = (double)((CloudDataNode)a).y + ((CloudDataNode)a).y0 < bounds[1][1];
        return test1 && test2 && test3 && test4;
    }

    public CloudLayout<T> start() {
        this.initContext();
        final CloudLayout cloud = this;
        this.cbounds = null;
        this.ci = -1;
        final int n = this.words().size();
        final ArrayEx tags = new ArrayEx();
        final ArrayEx data = this.words().map(new ArrayEx.ArrayValueFunction<T, T>(){

            public T getValue(T d, int i, ArrayEx<T> array) {
                ((CloudDataNode)d).text = (String)cloud._text.getValue((Object)this, d, i, 0);
                if (((CloudDataNode)d).text != null && ((CloudDataNode)d).text.length() > 50) {
                    ((CloudDataNode)d).text = ((CloudDataNode)d).text.substring(0, 49) + "...";
                }
                ((CloudDataNode)d).font = cloud._font.getValue((Object)this, d, i, 0);
                ((CloudDataNode)d).style = cloud._fontStyle.getValue((Object)this, d, i, 0);
                ((CloudDataNode)d).weight = cloud._fontWeight.getValue((Object)this, d, i, 0);
                ((CloudDataNode)d).rotate = (Integer)cloud._rotate.getValue((Object)this, d, i, 0);
                double fontSize = ((Number)cloud._fontSize.getValue((Object)this, d, i, 0)).doubleValue();
                long roundedFontsize = Math.round(fontSize);
                ((CloudDataNode)d).size = (int)roundedFontsize;
                ((CloudDataNode)d).padding = (Integer)cloud._padding.getValue((Object)this, d, i, 0);
                ((CloudDataNode)d).y1 = 0.0;
                ((CloudDataNode)d).x1 = 0.0;
                ((CloudDataNode)d).y0 = 0.0;
                ((CloudDataNode)d).x0 = 0.0;
                ((CloudDataNode)d).height = 0.0;
                ((CloudDataNode)d).width = 0.0;
                ((CloudDataNode)d).sprite = null;
                ((CloudDataNode)d).xoff = ((CloudDataNode)d).yoff = Integer.valueOf(0);
                ((CloudDataNode)d).x = ((CloudDataNode)d).y = ((CloudDataNode)d).yoff.intValue();
                return d;
            }
        });
        this.cloudSprite(data);
        data.sort(new Comparator<T>(){

            public int compare(T a, T b) {
                return (int)(Math.max(((CloudDataNode)b).width, ((CloudDataNode)b).height) - Math.max(((CloudDataNode)a).width, ((CloudDataNode)a).height));
            }
        });
        final int[] board = CloudLayout.zeroArray((this._size[0] >> 5) * this._size[1]);
        this._step = new Runnable(){

            public void run() {
                if (cloud._size[0] <= 0 || cloud._size[1] <= 0) {
                    cloud.stop();
                    ((Dispatcher.DispatcherEvent)cloud._event.get((Object)"end")).fire((Object)cloud, new Object[]{tags, cloud.cbounds});
                    return;
                }
                double start = Lang.now();
                int x_diff = cloud._size[0] - cloud._areaSize[0] >> 1;
                int y_diff = cloud._size[1] - cloud._areaSize[1] >> 1;
                while (Lang.now() - start < cloud._timeInterval && ++cloud.ci < n && cloud._timer != null) {
                    CloudDataNode d = (CloudDataNode)data.get(cloud.ci);
                    d.x = x_diff + (int)((double)cloud._areaSize[0] * (CloudLayout.getRandom() + 0.5)) >> 1;
                    d.y = y_diff + (int)((double)cloud._areaSize[1] * (CloudLayout.getRandom() + 0.5)) >> 1;
                    if (!d.hasText || !cloud.place(board, d, cloud.cbounds)) continue;
                    tags.push((Object[])new CloudDataNode[]{d});
                    ((Dispatcher.DispatcherEvent)cloud._event.get((Object)"word")).fire((Object)cloud, new Object[]{d});
                    if (cloud.cbounds != null) {
                        CloudLayout.cloudBounds(cloud.cbounds, d);
                    } else {
                        CloudLayout.access$802(cloud, new double[][]{{(double)d.x + d.x0, (double)d.y + d.y0}, {(double)d.x + d.x1, (double)d.y + d.y1}});
                    }
                    d.x -= cloud._size[0] >> 1;
                    d.y -= cloud._size[1] >> 1;
                }
                ((Dispatcher.DispatcherEvent)cloud._event.get((Object)"step")).fire((Object)cloud, new Object[]{tags, cloud.cbounds});
                if (cloud.ci >= n) {
                    cloud.stop();
                    ((Dispatcher.DispatcherEvent)cloud._event.get((Object)"end")).fire((Object)cloud, new Object[]{tags, cloud.cbounds});
                }
            }
        };
        if (this._timer != null) {
            EventQueue.clearInterval((Object)this._timer);
        }
        this._timer = cloud._timeInterval != Double.POSITIVE_INFINITY ? EventQueue.setInterval((Runnable)this._step, (int)0) : EventQueue.setTimeout((Runnable)this._step, (int)0);
        return cloud;
    }

    private void cloudSprite(ArrayEx<T> data) {
        boolean cannotLayout = false;
        int area = 0;
        double maxHeight = 0.0;
        double maxWidth = 0.0;
        int startIndex = 0;
        do {
            int index = startIndex;
            int maxIndex = index--;
            double canvasWidth = 2048.0 / this.ratio;
            double canvasHeight = 2048.0 / this.ratio;
            this._context.clearRect(0.0, 0.0, canvasWidth, canvasHeight);
            int x = 0;
            int y = 0;
            int n = data.size();
            double maxh = 0.0;
            while (++index < n) {
                CloudDataNode d = (CloudDataNode)data.get(index);
                if (d.sprite != null || d.text == null || d.text.length() == 0) continue;
                this._context.save();
                this._context.font = d.style + " normal " + d.weight + " " + (int)((double)(d.size + 1) / this.ratio) + "px/normal " + d.font;
                double w = this._context.measureText((String)d.text).width * this.ratio;
                double h = d.size << 1;
                if (d.rotate != 0) {
                    double sr = Math.sin((double)d.rotate.intValue() * (Math.PI / 180));
                    double cr = Math.cos((double)d.rotate.intValue() * (Math.PI / 180));
                    double wcr = w * cr;
                    double wsr = w * sr;
                    double hcr = h * cr;
                    double hsr = h * sr;
                    w = (int)(Math.max(Math.abs(wcr + hsr), Math.abs(wcr - hsr)) + 31.0) >> 5 << 5;
                    h = (int)Math.max(Math.abs(wsr + hcr), Math.abs(wsr - hcr));
                } else {
                    w = (int)w + 31 >> 5 << 5;
                }
                if (w >= canvasWidth || h >= canvasHeight) {
                    cannotLayout = true;
                    break;
                }
                if (h > maxh) {
                    maxh = h;
                }
                if ((double)x + w >= 2048.0) {
                    x = 0;
                    y = (int)((double)y + maxh);
                    maxh = 0.0;
                }
                if ((double)y + h >= 2048.0) break;
                this._context.translate((double)(x + ((int)w >> 1)) / this.ratio, (double)(y + ((int)h >> 1)) / this.ratio);
                if (d.rotate != 0) {
                    this._context.rotate((double)d.rotate.intValue() * (Math.PI / 180));
                }
                this._context.fillText(d.text, 0, 0);
                if (d.padding != 0) {
                    this._context.lineWidth = 2 * d.padding;
                    this._context.strokeText(d.text, 0, 0);
                }
                this._context.restore();
                d.width = w;
                d.height = h;
                d.xoff = x;
                d.yoff = y;
                d.x1 = (int)w >> 1;
                d.y1 = (int)h >> 1;
                d.x0 = -d.x1;
                d.y0 = -d.y1;
                d.hasText = true;
                x = (int)((double)x + w);
                maxWidth = Math.max(maxWidth, w);
                maxHeight = Math.max(maxHeight, h);
            }
            maxIndex = index;
            byte[] pixels = this._context.getImageData((double)0.0, (double)0.0, (double)canvasWidth, (double)canvasHeight).data;
            ArrayEx sprite = new ArrayEx();
            while (--index >= startIndex) {
                CloudDataNode d = (CloudDataNode)data.get(index);
                if (!d.hasText) continue;
                double w = d.width;
                int w32 = (int)w >> 5;
                double h = d.y1 - d.y0;
                int i = 0;
                while ((double)i < h * (double)w32) {
                    sprite.set(i, (Object)0);
                    ++i;
                }
                if (d.xoff == null) {
                    startIndex = maxIndex;
                    break;
                }
                x = d.xoff;
                y = d.yoff;
                int seen = 0;
                int seenRow = -1;
                int j = 0;
                while ((double)j < h) {
                    int i2 = 0;
                    while ((double)i2 < w) {
                        int k = w32 * j + (i2 >> 5);
                        int m = pixels[(y + j) * 2048 + (x + i2) << 2] != 0 ? 1 << 31 - i2 % 32 : 0;
                        sprite.set(k, (Object)((Integer)sprite.get(k) | m));
                        seen |= m;
                        ++i2;
                    }
                    if (seen != 0) {
                        seenRow = j;
                    } else {
                        d.y0 += 1.0;
                        h -= 1.0;
                        --j;
                        ++y;
                    }
                    ++j;
                }
                d.y1 = d.y0 + (double)seenRow;
                d.sprite = sprite.slice(0, (int)((d.y1 - d.y0) * (double)w32));
                area = (int)((double)area + d.width * d.height * 1.4);
            }
            startIndex = maxIndex;
            if (!cannotLayout) continue;
            ++startIndex;
        } while (startIndex < data.size());
        if (this._size[0] > 0 && this._size[1] > 0) {
            this._updateBoardSize(area, maxWidth, maxHeight);
        }
    }

    public void _updateBoardSize(int area, double maxWidth, double maxHeight) {
        double heightPercent;
        double widthPercent;
        double increasePercent;
        int newWidth = (int)Math.ceil((double)this._size[0] * Math.sqrt(ObjectConverter.toDouble((double)area) / (double)(this._size[0] * this._size[1])));
        int newHeight = (int)Math.ceil((double)this._size[1] * Math.sqrt(ObjectConverter.toDouble((double)area) / (double)(this._size[0] * this._size[1])));
        if (newWidth > this._size[0] || newHeight > this._size[1]) {
            this.size(new int[]{newWidth, newHeight});
        }
        this._areaSize[0] = this._size[0];
        this._areaSize[1] = this._size[1];
        double widthRequired = 2.0 * maxWidth;
        double heightRequired = 2.0 * maxHeight;
        if ((widthRequired > (double)this._size[0] || heightRequired > (double)this._size[1]) && (increasePercent = Math.max(widthPercent = widthRequired / (double)this._size[0], heightPercent = heightRequired / (double)this._size[1])) > 1.0) {
            this.size(new int[]{(int)Math.ceil((double)this._size[0] * increasePercent), (int)Math.ceil((double)this._size[1] * increasePercent)});
        }
    }

    public CloudLayout<T> stop() {
        if (this._timer != null) {
            EventQueue.clearInterval((Object)this._timer);
            this._timer = null;
        }
        this.disposeContext();
        return this;
    }

    public static double getRandom() {
        if (!_isRandomised.booleanValue()) {
            return 0.5;
        }
        return Rave.random.randomizer().randomize();
    }

    private boolean place(int[] board, T tag, double[][] bounds) {
        int dy;
        int dx;
        Double[] dxdy;
        int startX = ((CloudDataNode)tag).x;
        int startY = ((CloudDataNode)tag).y;
        double maxDelta = Math.sqrt(this._size[0] * this._size[0] + this._size[1] * this._size[1]);
        SingleValueFunction<Double[], Double> s = this.__spiral(this._size);
        double dt = CloudLayout.getRandom() < 0.5 ? 1.0 : -1.0;
        double t = -dt;
        while ((dxdy = (Double[])s.getValue((Object)(t += dt))) != null && !((double)Math.min(dx = dxdy[0].intValue(), dy = dxdy[1].intValue()) > maxDelta)) {
            ((CloudDataNode)tag).x = startX + dx;
            ((CloudDataNode)tag).y = startY + dy;
            if ((double)((CloudDataNode)tag).x + ((CloudDataNode)tag).x0 < 0.0 || (double)((CloudDataNode)tag).y + ((CloudDataNode)tag).y0 < 0.0 || (double)((CloudDataNode)tag).x + ((CloudDataNode)tag).x1 >= (double)this._size[0] || (double)((CloudDataNode)tag).y + ((CloudDataNode)tag).y1 >= (double)this._size[1] || bounds != null && this.cloudCollide(tag, board, this._size[0]) || bounds != null && !this.collideRects(tag, bounds)) continue;
            ArrayEx<Integer> sprite = ((CloudDataNode)tag).sprite;
            int w = (int)((CloudDataNode)tag).width >> 5;
            int sw = this.size()[0] >> 5;
            int lx = ((CloudDataNode)tag).x - (w << 4);
            int sx = lx & 0x7F;
            int msx = 32 - sx;
            int h = (int)(((CloudDataNode)tag).y1 - ((CloudDataNode)tag).y0);
            int x = (int)((double)((CloudDataNode)tag).y + ((CloudDataNode)tag).y0) * sw + (lx >> 5);
            for (int j = 0; j < h; ++j) {
                int last = 0;
                for (int i = 0; i <= w; ++i) {
                    int n;
                    int n2 = x + i;
                    int n3 = board[n2];
                    if (i < w) {
                        last = (Integer)sprite.get(j * w + i);
                        n = last >>> sx;
                    } else {
                        n = 0;
                    }
                    board[n2] = n3 | (last << msx | n);
                }
                x += sw;
            }
            ((CloudDataNode)tag).sprite = null;
            return true;
        }
        return false;
    }

    public CloudLayout<T> timeInterval(Double x) {
        this._timeInterval = x == null ? Double.POSITIVE_INFINITY : x;
        return this;
    }

    public Double timeInterval() {
        return this._timeInterval;
    }

    public CloudLayout<T> words(ArrayEx<T> nodes) {
        this._words = nodes;
        return this;
    }

    public ArrayEx<T> words() {
        return this._words;
    }

    public int[] size() {
        return this._size;
    }

    public CloudLayout<T> size(int[] newSize) {
        this._size = newSize;
        return this;
    }

    public CloudLayout<T> font(final String value) {
        this._font = new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        this._fontValue = value;
        return this;
    }

    public CloudLayout<T> font(ValueFunction<Object, String> value) {
        this._font = value;
        this._fontValue = null;
        return this;
    }

    public Object font() {
        return this._fontValue != null ? this._fontValue : this._font;
    }

    public Object fontStyle() {
        return this._fontStyleValue != null ? this._fontStyleValue : this._fontStyle;
    }

    public CloudLayout<T> fontStyle(final String value) {
        this._fontStyle = new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        this._fontStyleValue = value;
        return this;
    }

    public CloudLayout<T> fontStyle(ValueFunction<Object, String> fontStyleFn) {
        this._fontStyle = fontStyleFn;
        this._fontStyleValue = null;
        return this;
    }

    public Object rotate() {
        return this._rotateValue != null ? this._rotateValue : this._rotate;
    }

    public CloudLayout<T> rotate(final int value) {
        this._rotate = new ValueFunction<Object, Integer>(){

            public Integer getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        this._rotateValue = value;
        return this;
    }

    public CloudLayout<T> rotate(ValueFunction<Object, Integer> _rotateFn) {
        this._rotate = _rotateFn;
        this._rotateValue = null;
        return this;
    }

    public Object text() {
        return this._textValue != null ? this._textValue : this._text;
    }

    public CloudLayout<T> text(final String value) {
        this._text = new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        this._textValue = value;
        return this;
    }

    public CloudLayout<T> text(ValueFunction<Object, String> value) {
        this._text = value;
        this._textValue = null;
        return this;
    }

    public SingleValueFunction<SingleValueFunction<Double[], Double>, int[]> spiral() {
        return this._spiral;
    }

    public CloudLayout<T> spiral(String name) {
        this._spiral = ARCHIMEDEAN.equals(name) ? CloudLayout._archimedeanSpiral() : CloudLayout._rectangularSpiral();
        return this;
    }

    private SingleValueFunction<Double[], Double> __spiral(int[] arg) {
        return (SingleValueFunction)this._spiral.getValue((Object)arg);
    }

    public CloudLayout<T> fontSize(ValueFunction<Object, ? extends Number> fontSizeFn) {
        this._fontSize = fontSizeFn;
        this._fontSizeValue = null;
        return this;
    }

    public Object fontSize() {
        return this._fontSizeValue != null ? this._fontSizeValue : this._fontSize;
    }

    public CloudLayout<T> fontSize(final Number value) {
        this._fontSize = new ValueFunction<Object, Number>(){

            public Number getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        this._fontSizeValue = ObjectConverter.toDouble((Object)value);
        return this;
    }

    public Object padding() {
        return this._paddingValue != null ? this._paddingValue : this._padding;
    }

    public CloudLayout<T> padding(final int value) {
        this._padding = new ValueFunction<Object, Integer>(){

            public Integer getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        this._paddingValue = value;
        return this;
    }

    public boolean isRandomised() {
        return _isRandomised;
    }

    public CloudLayout<T> isRandomised(boolean value) {
        _isRandomised = value;
        return this;
    }

    public CloudLayout<T> padding(ValueFunction<Object, Integer> paddingFn) {
        this._padding = paddingFn;
        this._paddingValue = null;
        return this;
    }

    public CloudLayout<T> fontWeight(ValueFunction<Object, String> fontWeightFn) {
        this._fontWeight = fontWeightFn;
        this._fontWeightValue = null;
        return this;
    }

    public Object fontWeight() {
        return this._fontWeightValue != null ? this._fontWeightValue : this._fontWeight;
    }

    public CloudLayout<T> fontWeight(final String value) {
        this._fontWeight = new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        this._fontWeightValue = value;
        return this;
    }

    private void initContext() {
        if (this._context == null) {
            Canvas canvas;
            if (GraphicContextUtil.isDocumentDefined()) {
                canvas = Rave.canvas.create(1.0, 1.0);
                this._context = canvas.getContext("2d", new Object[0]);
                this.ratio = Math.sqrt(this._context.getImageData((double)0.0, (double)0.0, (double)1.0, (double)1.0).data.length >> 2);
                Rave.canvas.disposeContext(this._context);
                this._context = null;
                canvas.width = 2048.0 / this.ratio;
                canvas.height = 2048.0 / this.ratio;
            } else {
                canvas = Rave.canvas.create(2048.0, 2048.0);
            }
            this._context = canvas.getContext("2d", new Object[0]);
            this._context.strokeStyle = "red";
            this._context.fillStyle = "red";
            this._context.textAlign = "center";
        }
    }

    private void disposeContext() {
        if (this._context != null) {
            Rave.canvas.disposeContext(this._context);
            this._context = null;
        }
    }

    static /* synthetic */ double[][] access$802(CloudLayout x0, double[][] x1) {
        x0.cbounds = x1;
        return x1;
    }
}

