/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.layout.hexbin;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.JsonArray;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geom.Point;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import java.util.List;

@FunctionClass(value="hexbin")
public final class Hexbin {
    private static final ArrayEx<Number> rave_hexbinAngles = Rave.range((Object)0, (Object)(Math.PI * 2), (Object)1.0471975511965976);
    private static final HexbinFunction hexbinX = new HexbinFunction(){

        @Override
        public double bin(Point d, int i) {
            return d.getX();
        }
    };
    private static final HexbinFunction hexbinY = new HexbinFunction(){

        @Override
        public double bin(Point d, int i) {
            return d.getY();
        }
    };
    private HexbinFunction xFunc = hexbinX;
    private HexbinFunction yFunc = hexbinY;
    private double width = 1.0;
    private double height = 1.0;
    private double r;
    private double dx;
    private double dy;

    public Hexbin() {
        this.radius(1.0);
    }

    public List<HexbinNode> hexbin(List<Point> points) {
        ES6Map binsById = ES6Map.create();
        for (int i = 0; i < points.size(); ++i) {
            String id;
            HexbinNode bin;
            double pj2;
            double py2;
            double pi2;
            double px2;
            double px1;
            Point point = points.get(i);
            double py = this.yFunc.bin(point, i) / this.dy;
            double pj = Math.round(py);
            double px = this.xFunc.bin(point, i) / this.dx - (((int)pj & 1) == 1 ? 0.5 : 0.0);
            double pi = Math.round(px);
            double py1 = py - pj;
            if (Math.abs(py1) * 3.0 > 1.0 && (px1 = px - pi) * px1 + py1 * py1 > (px2 = px - (pi2 = pi + (double)(px < pi ? -1 : 1) / 2.0)) * px2 + (py2 = py - (pj2 = pj + (double)(py < pj ? -1 : 1))) * py2) {
                pi = pi2 + (double)(((int)pj & 1) == 1 ? 1 : -1) / 2.0;
                pj = pj2;
            }
            if ((bin = (HexbinNode)((Object)binsById.get((Object)(id = pi + "-" + pj)))) != null) {
                bin.push(new Point[]{point});
                continue;
            }
            bin = new HexbinNode();
            bin.push(new Point[]{point});
            binsById.set((Object)id, (Object)bin);
            bin.i = pi;
            bin.j = pj;
            bin.x = (pi + (((int)pj & 1) == 1 ? 0.5 : 0.0)) * this.dx;
            bin.y = pj * this.dy;
        }
        return binsById.values();
    }

    public Hexbin x(HexbinFunction accessor) {
        this.xFunc = accessor;
        return this;
    }

    public HexbinFunction x() {
        return this.xFunc;
    }

    public Hexbin y(HexbinFunction accessor) {
        this.yFunc = accessor;
        return this;
    }

    public HexbinFunction y() {
        return this.yFunc;
    }

    public String hexagon(double radius) {
        return "m" + Hexbin._hexagon(radius).join((Object)"l") + "z";
    }

    public String hexagon() {
        return "m" + Hexbin._hexagon(this.r).join((Object)"l") + "z";
    }

    private static ArrayEx<ArrayEx<Number>> _hexagon(final double radius) {
        return rave_hexbinAngles.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Number, ArrayEx<Number>>(){
            double x0 = 0.0;
            double y0 = 0.0;

            public ArrayEx<Number> getValue(Number currentValue, int index, ArrayEx<Number> array) {
                double angle = currentValue.doubleValue();
                double x1 = Math.sin(angle) * radius;
                double y1 = -Math.cos(angle) * radius;
                double dx = x1 - this.x0;
                double dy = y1 - this.y0;
                this.x0 = x1;
                this.y0 = y1;
                return new ArrayEx((Object[])new Number[]{dx, dy});
            }
        });
    }

    public ArrayEx<HexbinNode> centers() {
        ArrayEx centers = new ArrayEx();
        boolean odd = false;
        double y = 0.0;
        double j = 0.0;
        while (y < this.height + this.r) {
            double x = odd ? this.dx / 2.0 : 0.0;
            double i = 0.0;
            while (x < this.width + this.dx / 2.0) {
                HexbinNode center = new HexbinNode();
                center.x = x;
                center.y = y;
                center.i = i;
                center.j = j;
                centers.push((Object[])new HexbinNode[]{center});
                x += this.dx;
                i += 1.0;
            }
            y += this.dy;
            odd = !odd;
            j += 1.0;
        }
        return centers;
    }

    public String mesh() {
        final String fragment = Hexbin._hexagon(this.r).slice(0, 4).join((Object)"l");
        return this.centers().map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<HexbinNode, Object>(){

            public String getValue(HexbinNode currentValue, int index, ArrayEx<HexbinNode> array) {
                HexbinNode p = currentValue;
                return "M" + p.x + "," + p.y + "m" + fragment;
            }
        }).join((Object)"");
    }

    public Hexbin size(List<Number> size) {
        this.width = size.get(0).doubleValue();
        this.height = size.get(1).doubleValue();
        return this;
    }

    public ArrayEx<Number> size() {
        return new ArrayEx((Object[])new Number[]{this.width, this.height});
    }

    public Hexbin radius(double radius) {
        this.r = radius;
        this.dx = this.r * 2.0 * Math.sin(1.0471975511965976);
        this.dy = this.r * 1.5;
        return this;
    }

    public double radius() {
        return this.r;
    }

    @JsonArray
    public class HexbinNode
    extends ArrayEx<Point> {
        public double i;
        public double j;
        public double x;
        public double y;
    }

    @FunctionClass(value="bin")
    public static interface HexbinFunction {
        public double bin(Point var1, int var2);
    }
}

