/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.legend.size;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.Selection;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.Symbol;
import com.ibm.vida.rave.ext.legend.AbstractLegend;
import com.ibm.vida.rave.ext.text.wrap.TextFlow;
import java.util.List;

public class NestedSizeLegend
extends AbstractLegend<NestedSizeLegend> {
    private static final String SHAPE_SYMBOL_TYPE = "circle";
    private static final String SHAPE_DISPLAY_FULL = "full";
    private static final String SHAPE_DISPLAY_HALF = "half";
    private static final double TICK_PADDING_DEFAULT = 20.0;
    private double _tickPadding = 20.0;
    private String _shapeDisplay = "full";
    private Selector _defs;
    private String _clipId;

    public NestedSizeLegend() {
        this.scaleArguments(3);
    }

    @Override
    public void legend(Selector g) {
        final NestedSizeLegend self = this;
        g.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                Selector gSelection = self.prepareLegendGroup(context);
                self.prepareLegendBounds(gSelection);
                Object labelFormat = self.getLabelFormat();
                TextFlow textFlow = self.createTextFlowComponent();
                Selector titleSelector = self.prepareLegendTitle(gSelection, textFlow);
                if (titleSelector != null && titleSelector.node().getParentNode() == null) {
                    return;
                }
                double titleVerticalShift = self.calculateTitleVerticalShift(titleSelector);
                double availableWidth = self.size().getWidth() - (double)self.insets().left.intValue() - (double)self.insets().right.intValue();
                double availableHeight = self.size().getHeight() - (double)self.insets().top.intValue() - (double)self.insets().bottom.intValue() - titleVerticalShift;
                self.alignTitleHorizontally(titleSelector);
                if (availableHeight <= 0.0 || availableWidth <= 0.0 || !ObjectConverter.toBoolean((Object)self.scale())) {
                    return;
                }
                List scaleData = self.getData();
                if (scaleData == null) {
                    return;
                }
                ArrayEx ticks = ObjectConverter.listToArray((List)scaleData).reverse();
                double maxArea = ObjectConverter.toDouble((Object)self.scale().getValue(null, ticks.get(0), 0, 0));
                double minArea = ObjectConverter.toDouble((Object)self.scale().getValue(null, ticks.get(ticks.size() - 1), 0, 0));
                final double maxSymbolHeight = 2.0 * NestedSizeLegend.areaToCircleRadius(Math.max(maxArea, minArea));
                Symbol symbol = Rave.svg.symbol().type(NestedSizeLegend.SHAPE_SYMBOL_TYPE).size((ValueFunction)new ValueFunction<Object, Number>(){

                    @SwiftMethodOverload(skipParameters={1})
                    public Number getValue(Object context, Object data, int index, int groupIndex) {
                        return ObjectConverter.toDouble((Object)self.scale().getValue(null, data, 0, 0));
                    }
                });
                RectStruct container = new RectStruct((double)self.insets().left.intValue(), (double)self.insets().top.intValue() + titleVerticalShift, availableWidth, availableHeight);
                RectStruct entryBounds = new RectStruct(container.x + (double)self.entryInsets().left.intValue(), container.y + (double)self.entryInsets().top.intValue(), container.width - (double)self.entryInsets().left.intValue() - (double)self.entryInsets().right.intValue(), container.height - (double)self.entryInsets().top.intValue() - (double)self.entryInsets().bottom.intValue());
                double entryShiftX = 0.0;
                if (NestedSizeLegend.SHAPE_DISPLAY_FULL.equals(self._shapeDisplay)) {
                    entryShiftX += maxSymbolHeight / 2.0;
                }
                Selector legendContainer = gSelection.append("g").classed("legendContainer", true).attr("clip-path", self._clipId != null ? "url(#" + self._clipId + ")" : null);
                if (self._defs != null && self._clipId != null) {
                    Selector clipPath = self._defs.selectAll("#" + self._clipId).data(new Object[]{0});
                    clipPath.enter().append("clipPath").attr("id", (Object)self._clipId).append("rect");
                    clipPath.select((Object)"rect").attr("x", (Object)entryBounds.x).attr("width", (Object)entryBounds.width).attr("y", (Object)titleVerticalShift).attr("height", (Object)availableHeight);
                }
                ValueFunction<SceneNode, Object> transformEntry = new ValueFunction<SceneNode, Object>(){

                    @SwiftMethodOverload(skipParameters={1})
                    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                        double x = NestedSizeLegend.areaToCircleRadius(ObjectConverter.toDouble((Object)self.scale().getValue(null, data, 0, 0)));
                        return "translate(0, " + (maxSymbolHeight - x) + ")";
                    }
                };
                ValueFunction<SceneNode, Object> transformCenterEntry = new ValueFunction<SceneNode, Object>(){

                    @SwiftMethodOverload(skipParameters={1})
                    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                        double x = 2.0 * NestedSizeLegend.areaToCircleRadius(ObjectConverter.toDouble((Object)self.scale().getValue(null, data, 0, 0)));
                        return "translate(0, " + (maxSymbolHeight - x) + ")";
                    }
                };
                Selector legendEntries = legendContainer.selectAll(".legendEntry").data((List)ticks);
                Selector legendEntriesEnter = legendEntries.enter().append("g").classed("legendEntry", true);
                legendEntriesEnter.append("path").classed("legendShape", true);
                legendEntriesEnter.append("line").classed("legendTickLine", true);
                Selector lengendEntryText = legendEntriesEnter.append("text").classed("legendLabel", true);
                if (NestedSizeLegend.this.entryFontStyle() != null) {
                    lengendEntryText.style(NestedSizeLegend.this.entryFontStyle());
                }
                legendEntries.attr("transform", (Object)("translate(" + (entryBounds.x + entryShiftX) + "," + entryBounds.y + ")"));
                legendEntries.select((Object)".legendShape").attr("d", (ValueFunction)symbol).attr("transform", (ValueFunction)transformEntry).style("stroke", ObjectConverter.toBoolean((Object)self.shapeBorderColor()) ? Rave.rgb((Object)self.shapeBorderColor()).toString() : null);
                legendEntries.select((Object)".legendTickLine").attr("x1", (Object)0).attr("x2", (Object)(maxSymbolHeight / 2.0 + self._tickPadding)).attr("transform", (ValueFunction)transformCenterEntry);
                double labelX = maxSymbolHeight / 2.0 + ObjectConverter.toDouble((Object)self.labelPadding()) + self._tickPadding;
                Selector label = legendEntries.select((Object)".legendLabel");
                label.attr("x", (Object)labelX).attr("transform", (ValueFunction)transformCenterEntry).attr("dy", (ValueFunction)new ValueFunction<SceneNode, Object>(){

                    @SwiftMethodOverload(skipParameters={1})
                    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                        return self.getTextDyPlacement(context);
                    }
                }).text(labelFormat);
                textFlow.extent(ObjectConverter.toInt((Object)Math.max(0.0, entryBounds.width - labelX - entryShiftX)), ObjectConverter.toInt((Object)label.node().getBBox().height)).flow((Selection)label);
            }
        });
    }

    public NestedSizeLegend tickPadding(double padding) {
        this._tickPadding = Math.max(0.0, padding);
        return this;
    }

    public double tickPadding() {
        return this._tickPadding;
    }

    public NestedSizeLegend shapeDisplay(String display) {
        this._shapeDisplay = SHAPE_DISPLAY_HALF.equals(display) ? display : SHAPE_DISPLAY_FULL;
        return this;
    }

    public String shapeDisplay() {
        return this._shapeDisplay;
    }

    public NestedSizeLegend clip(Selector defs, String id) {
        this._defs = defs;
        this._clipId = id;
        return this;
    }

    private static double areaToCircleRadius(double area) {
        return Math.sqrt(area / Math.PI);
    }
}

