/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.navigation.focus;

import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import java.util.Iterator;
import java.util.List;

public final class FocusController {
    public static SceneNode previousLevelFocusableNode(SceneNode node) {
        SceneNode focused = node;
        SceneNode parent = null;
        while ((parent = focused.getParentNode()) != null && FocusController.getNavigationIndex(parent) < 0) {
            focused = parent;
        }
        return parent;
    }

    public static SceneNode nextLevelFocusableNode(SceneNode node) {
        SceneNode focused;
        block1: {
            SceneNode child;
            SceneNode firstChild = FocusController.firstChild(node);
            focused = FocusController.nextFocusableNodeFromStart(firstChild);
            if (focused != null) break block1;
            Iterator iterator = node.getChildNodes().iterator();
            while (iterator.hasNext() && (focused = FocusController.nextLevelFocusableNode(child = (SceneNode)iterator.next())) == null) {
            }
        }
        return focused;
    }

    public static SceneNode previousFocusableNodeFromEnd(SceneNode node) {
        return FocusController._previousFocusableNode(node, null);
    }

    public static SceneNode previousFocusableNode(SceneNode node) {
        return FocusController._previousFocusableNode(node, node);
    }

    private static SceneNode _previousFocusableNode(SceneNode scope, SceneNode start) {
        SceneNode startingNode;
        int startingIndex;
        SceneNode last = FocusController.lastChild(scope != null ? scope.getParentNode() : null);
        if (start != null) {
            startingIndex = FocusController.getNavigationIndex(start);
            startingNode = start.getPreviousSibling();
        } else {
            startingIndex = 0;
            startingNode = last;
        }
        if (startingIndex < 0) {
            for (SceneNode target = startingNode; target != null; target = target.getPreviousSibling()) {
                if (FocusController.getNavigationIndex(target) < 0) continue;
                return target;
            }
        } else {
            SceneNode sameIndex = FocusController.findNodeWithIndex(startingNode, startingIndex, false);
            if (sameIndex != null) {
                return sameIndex;
            }
        }
        startingIndex = start != null && startingIndex != 0 ? startingIndex : Integer.MAX_VALUE;
        return FocusController.findPreviousNodeWithLowerIndex(last, startingIndex);
    }

    public static SceneNode nextFocusableNodeFromStart(SceneNode node) {
        return FocusController._nextFocusableNode(node, null);
    }

    public static SceneNode nextFocusableNode(SceneNode node) {
        return FocusController._nextFocusableNode(node, node);
    }

    private static SceneNode _nextFocusableNode(SceneNode scope, SceneNode start) {
        SceneNode first;
        SceneNode next;
        if (start != null) {
            int index = FocusController.getNavigationIndex(start);
            if (index < 0) {
                for (SceneNode target = start.getNextSibling(); target != null; target = target.getNextSibling()) {
                    if (FocusController.getNavigationIndex(target) < 0) continue;
                    return target;
                }
            } else {
                SceneNode sameIndex = FocusController.findNodeWithIndex(start.getNextSibling(), index, true);
                if (sameIndex != null) {
                    return sameIndex;
                }
            }
            if (index == 0) {
                return null;
            }
        }
        if ((next = FocusController.findNextNodeWithGreaterIndex(first = FocusController.firstChild(scope != null ? scope.getParentNode() : null), start != null ? FocusController.getNavigationIndex(start) : 0)) != null) {
            return next;
        }
        return FocusController.findNodeWithIndex(first, 0, true);
    }

    private static int getNavigationIndex(SceneNode node) {
        Object index = node.getProperty("__raveNavigationIndex__");
        return index != null ? ObjectConverter.toInt((Object)index) : 0;
    }

    private static SceneNode findNodeWithIndex(SceneNode node, int index, boolean forward) {
        SceneNode target = node;
        while (target != null) {
            if (FocusController.getNavigationIndex(target) == index) {
                return target;
            }
            target = forward ? target.getNextSibling() : target.getPreviousSibling();
        }
        return null;
    }

    private static SceneNode findNextNodeWithGreaterIndex(SceneNode node, int index) {
        SceneNode greater = null;
        int maxIndex = Integer.MAX_VALUE;
        for (SceneNode target = node; target != null; target = target.getNextSibling()) {
            int currentIndex = FocusController.getNavigationIndex(target);
            if (currentIndex <= index || currentIndex >= maxIndex) continue;
            maxIndex = currentIndex;
            greater = target;
        }
        return greater;
    }

    private static SceneNode findPreviousNodeWithLowerIndex(SceneNode node, int index) {
        SceneNode lower = null;
        int minIndex = 0;
        for (SceneNode target = node; target != null; target = target.getPreviousSibling()) {
            int currentIndex = FocusController.getNavigationIndex(target);
            if (currentIndex >= index || currentIndex <= minIndex) continue;
            minIndex = currentIndex;
            lower = target;
        }
        return lower;
    }

    private static SceneNode firstChild(SceneNode node) {
        SceneNode firstChild = null;
        if (node != null && node.hasChildNodes()) {
            firstChild = (SceneNode)node.getChildNodes().get(0);
        }
        return firstChild;
    }

    private static SceneNode lastChild(SceneNode node) {
        SceneNode lastChild = null;
        if (node != null && node.hasChildNodes()) {
            List children = node.getChildNodes();
            lastChild = (SceneNode)children.get(children.size() - 1);
        }
        return lastChild;
    }
}

