/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.navigation.keyboard;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.event.KeyboardEvent;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.SelectorEventListener;

public final class KeyBinding
implements RunFunction<Object> {
    private final OMap<String, RunFunction<SceneNode>> keyDownMap = new OMap();
    private final OMap<String, RunFunction<SceneNode>> keyPressMap = new OMap();
    private SelectorEventListener<KeyboardEvent> keyDownListener;
    private SelectorEventListener<KeyboardEvent> keyPressListener;

    public KeyBinding() {
        final KeyBinding self = this;
        this.keyDownListener = new SelectorEventListener<KeyboardEvent>(){

            public void onEvent(SceneNode context, Object data, int index, int groupIndex, KeyboardEvent event) {
                RunFunction callback = KeyBinding.getCallback((OMap<String, RunFunction<SceneNode>>)self.keyDownMap);
                if (callback != null) {
                    callback.run(event.target, new Object[]{event});
                }
            }
        };
        this.keyPressListener = new SelectorEventListener<KeyboardEvent>(){

            public void onEvent(SceneNode context, Object data, int index, int groupIndex, KeyboardEvent event) {
                RunFunction callback = KeyBinding.getCallback((OMap<String, RunFunction<SceneNode>>)self.keyPressMap);
                if (callback != null) {
                    callback.run(event.target, new Object[]{event});
                }
            }
        };
    }

    public Object run(Object context, Object ... args) {
        this.keybinding((Selector)args[0]);
        return null;
    }

    public void keybinding(Selector g) {
        g.on("keydown", this.keyDownListener);
        g.on("keypress", this.keyPressListener);
    }

    public KeyBinding on(int keyCode, RunFunction<SceneNode> callback) {
        KeyBinding.addKeyCallback(keyCode, callback, 0, this.keyDownMap);
        return this;
    }

    public RunFunction<SceneNode> get(int keyCode) {
        return KeyBinding.getKeyCallback(keyCode, 0, this.keyDownMap);
    }

    public KeyBinding on(int keyCode, RunFunction<SceneNode> callback, int modifiers) {
        KeyBinding.addKeyCallback(keyCode, callback, modifiers, this.keyDownMap);
        return this;
    }

    public RunFunction<SceneNode> get(int keyCode, int modifiers) {
        return KeyBinding.getKeyCallback(keyCode, modifiers, this.keyDownMap);
    }

    public KeyBinding on(String key, RunFunction<SceneNode> callback) {
        if (key != null && key.length() > 0) {
            KeyBinding.addKeyCallback(key.charAt(0), callback, 0, this.keyPressMap);
        }
        return this;
    }

    public RunFunction<SceneNode> get(String key) {
        if (key != null && key.length() > 0) {
            return KeyBinding.getKeyCallback(key.charAt(0), 0, this.keyPressMap);
        }
        return null;
    }

    public KeyBinding on(String key, RunFunction<SceneNode> callback, int modifiers) {
        if (key != null && key.length() > 0) {
            KeyBinding.addKeyCallback(key.charAt(0), callback, modifiers, modifiers == 8 || modifiers == 0 ? this.keyPressMap : this.keyDownMap);
        }
        return this;
    }

    public RunFunction<SceneNode> get(String key, int modifiers) {
        if (key != null && key.length() > 0) {
            return KeyBinding.getKeyCallback(key.charAt(0), modifiers, modifiers == 8 || modifiers == 0 ? this.keyPressMap : this.keyDownMap);
        }
        return null;
    }

    private static void addKeyCallback(int keyCode, RunFunction<SceneNode> callback, int modifiers, OMap<String, RunFunction<SceneNode>> map) {
        String key = KeyBinding.generateMapKey(keyCode, modifiers);
        map.put((Object)key, callback);
    }

    private static RunFunction<SceneNode> getKeyCallback(int keyCode, int modifiers, OMap<String, RunFunction<SceneNode>> map) {
        String key = KeyBinding.generateMapKey(keyCode, modifiers);
        return (RunFunction)map.get((Object)key);
    }

    private static String generateMapKey(int keyCode, int modifiers) {
        return keyCode + ":" + modifiers;
    }

    private static RunFunction<SceneNode> getCallback(OMap<String, RunFunction<SceneNode>> map) {
        return (RunFunction)map.get((Object)KeyBinding.getKeyFromEvent((KeyboardEvent)Rave.event.get()));
    }

    private static String getKeyFromEvent(KeyboardEvent event) {
        int modifiers = 0;
        if (event.shiftKey) {
            modifiers |= 8;
        }
        if (event.ctrlKey) {
            modifiers |= 4;
        }
        if (event.altKey) {
            modifiers |= 2;
        }
        if (event.metaKey) {
            modifiers |= 1;
        }
        int keyCode = event.keyCode == 0 ? event.which : event.keyCode;
        return KeyBinding.generateMapKey(keyCode, modifiers);
    }
}

