/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal;

import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.transform.Matrix;
import com.ibm.vida.rave.core.transform.MatrixUtil;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;
import java.util.ArrayList;
import java.util.List;

public final class DirtyRegionManager {
    private static final String DIRTY_CACHE = "__drc__";
    public static final int EXPAND = 2;
    private Rect dirtyRegion;
    private Rect normalizedRegion;
    private boolean globalDirty = true;
    private final List<AbstractSceneNode> dirtyNodes = new ArrayList<AbstractSceneNode>();

    public boolean isGloballyDirty() {
        return this.globalDirty;
    }

    public void add(AbstractSceneNode node) {
        if (!this.globalDirty) {
            this.dirtyNodes.add(node);
            this.addBounds(node, (RectStruct)node.getProperty(DIRTY_CACHE));
        }
    }

    private void addBounds(AbstractSceneNode node, RectStruct cache) {
        double bottom;
        double top;
        double right;
        double left;
        if (cache == null) {
            RectStruct r = this.computeBounds(node);
            left = r.x;
            right = r.x + r.width;
            top = r.y;
            bottom = r.y + r.height;
        } else {
            left = cache.x;
            right = cache.x + cache.width;
            top = cache.y;
            bottom = cache.y + cache.height;
        }
        if (!this.globalDirty) {
            this.normalizedRegion = null;
            if (this.dirtyRegion == null) {
                this.dirtyRegion = new Rect(left, right, top, bottom);
            } else {
                this.dirtyRegion.left = Math.min(this.dirtyRegion.left, left);
                this.dirtyRegion.top = Math.min(this.dirtyRegion.top, top);
                this.dirtyRegion.bottom = Math.max(this.dirtyRegion.bottom, bottom);
                this.dirtyRegion.right = Math.max(this.dirtyRegion.right, right);
            }
        }
    }

    private RectStruct getDirtyBounds(AbstractSceneNode node) {
        RectStruct r = (RectStruct)node.getProperty(DIRTY_CACHE);
        if (r == null) {
            r = this.computeBounds(node);
        }
        return r;
    }

    private RectStruct computeBounds(AbstractSceneNode node) {
        RaveRect bBox = node.getBoundingClientRectBBox();
        double left = bBox.x;
        double top = bBox.y;
        double right = bBox.x + bBox.width;
        double bottom = bBox.y + bBox.height;
        double strokeWidth = node.getComputedSizePx(31);
        if (strokeWidth > 0.0) {
            double expand = 1.5 * strokeWidth / 2.0;
            left -= expand;
            top -= expand;
            right += expand;
            bottom += expand;
        }
        RectStruct r = MatrixUtil.transformBounds((RectStruct)new RectStruct(left, top, right - left, bottom - top), (Matrix)node.getCTM());
        node.setProperty(DIRTY_CACHE, r);
        return r;
    }

    public void clear() {
        this.dirtyRegion = null;
        this.normalizedRegion = null;
        this.globalDirty = false;
        this.dirtyNodes.clear();
    }

    public void forceRedraw() {
        for (AbstractSceneNode node : this.dirtyNodes) {
            node.removeProperty(DIRTY_CACHE);
        }
        this.clear();
        this.globalDirty = true;
    }

    private void normalize() {
        for (AbstractSceneNode node : this.dirtyNodes) {
            this.addBounds(node, null);
        }
        this.dirtyNodes.clear();
        this.normalizedRegion = new Rect(Math.max(0.0, Math.floor(this.dirtyRegion.left - 2.0)), Math.max(0.0, Math.ceil(this.dirtyRegion.right + 2.0)), Math.max(0.0, Math.floor(this.dirtyRegion.top - 2.0)), Math.max(0.0, Math.ceil(this.dirtyRegion.bottom + 2.0)));
    }

    public RaveRect getClip() {
        if (this.dirtyRegion != null) {
            if (this.normalizedRegion == null) {
                this.normalize();
            }
            return new RaveRect(this.normalizedRegion.left, this.normalizedRegion.top, this.normalizedRegion.right - this.normalizedRegion.left, this.normalizedRegion.bottom - this.normalizedRegion.top);
        }
        return null;
    }

    public boolean intersects(AbstractSceneNode node) {
        if (this.dirtyRegion != null) {
            if (this.normalizedRegion == null) {
                this.normalize();
            }
            RectStruct r = this.getDirtyBounds(node);
            if (r.x >= this.normalizedRegion.right || r.y >= this.normalizedRegion.bottom || r.y + r.height <= this.normalizedRegion.top || r.x + r.width <= this.normalizedRegion.left) {
                return false;
            }
        }
        return true;
    }

    private static class Rect {
        double left;
        double right;
        double top;
        double bottom;

        Rect(double left, double right, double top, double bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }
    }
}

