/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.internal.nodes.RootProvider;
import java.util.List;

public class RendererConfiguration {
    public static RendererConfiguration INSTANCE = new RendererConfiguration();
    private final List<RootProvider> roots = new ArrayEx();

    public List<RootProvider> getRootProviders() {
        return this.roots;
    }

    public RootProvider getRootProviderForNode(SceneNode node) {
        for (RootProvider root : this.roots) {
            if (node.getOwner() != root.getRoot().getOwner()) continue;
            return root;
        }
        return null;
    }

    public void addRootProvider(RootProvider rootProvider) {
        this.roots.add(rootProvider);
    }

    public void removeRootProvider(RootProvider rootProvider) {
        int i = this.roots.indexOf(rootProvider);
        if (i >= 0) {
            this.roots.remove(i);
        }
    }

    public void removeRootProviderForNode(SceneNode node) {
        int i = -1;
        boolean found = false;
        for (RootProvider root : this.roots) {
            ++i;
            if (node != root.getRoot().getOwner()) continue;
            found = true;
            break;
        }
        if (found) {
            this.roots.remove(i);
        }
    }
}

