/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.css.collector;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.css.CSSStyleRule;
import com.ibm.vida.rave.core.internal.collections.OSet;
import com.ibm.vida.rave.core.internal.css.CSSStyleSheetManager;
import com.ibm.vida.rave.core.internal.selector.SelectionQueryEngine;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;
import java.util.ArrayList;
import java.util.List;

public final class CSSStyleRuleCollector {
    public static List<CSSStyleRule> collectAll(AbstractSceneNode node) {
        ArrayList<CSSStyleRule> matches = new ArrayList<CSSStyleRule>();
        OSet selectorCache = new OSet();
        SelectionQueryEngine engine = Rave.configuration.getQueryEngine(null);
        if (engine != null) {
            for (CSSStyleRule potentialMatch : CSSStyleRuleCollector.getPotentialMatches(node)) {
                String selectorText = potentialMatch.getSelectorText();
                if (selectorCache.contains((Object)selectorText)) continue;
                if (engine.matches((SceneNode)node, selectorText)) {
                    matches.add(potentialMatch);
                }
                selectorCache.add((Object)selectorText);
            }
        }
        return matches;
    }

    private static List<CSSStyleRule> getPotentialMatches(AbstractSceneNode node) {
        List rules;
        List rules2;
        CSSStyleSheetManager manager = CSSStyleSheetManager.INSTANCE;
        ArrayList<CSSStyleRule> potentialMatches = new ArrayList<CSSStyleRule>();
        String id = node.getId();
        if (id != null && (rules2 = manager.getPotentialMatchesById("#" + id)) != null) {
            for (CSSStyleRule rule : rules2) {
                potentialMatches.add(rule);
            }
        }
        List<String> classes = node.getClassList();
        for (String className : classes) {
            List rules3;
            if (className == null || (rules3 = manager.getPotentialMatchesByClass("." + className)) == null) continue;
            for (CSSStyleRule rule : rules3) {
                potentialMatches.add(rule);
            }
        }
        String tag = node.getName();
        if (tag != null && (rules = manager.getPotentialMatchesByTag(tag)) != null) {
            for (CSSStyleRule rule : rules) {
                potentialMatches.add(rule);
            }
        }
        return potentialMatches;
    }
}

