/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes;

import com.ibm.vida.rave.core.css.CSSSize;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.AbstractRenderer;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.vida.rave.render.internal.nodes.GeometricHelper;

public class CircleSceneItem
extends AbstractSceneNode {
    protected double cx;
    protected double r;
    protected double cy;

    public CircleSceneItem(String nsuri, SceneNode context) {
        super(nsuri, context);
    }

    @Override
    protected RaveRect calculateBBox() {
        return new RaveRect(this.cx - this.r, this.cy - this.r, this.r * 2.0, this.r * 2.0);
    }

    public int getDrawType() {
        return 1002;
    }

    public String getName() {
        return "circle";
    }

    public double getCx() {
        return this.cx;
    }

    public double getCy() {
        return this.cy;
    }

    public double getR() {
        return this.r;
    }

    @Override
    protected boolean intersects(RectStruct rect) {
        return GeometricHelper.circleIntersect(this.cx, this.cy, this.r, rect) && this.intersectsClip(rect);
    }

    @Override
    public void paint(AbstractRenderer renderer) {
        renderer.setStrokeAndFill(this);
        renderer.drawCircle(this);
    }

    @Override
    public void doLayout() {
        this.cx = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)9).value);
        this.cy = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)10).value);
        this.r = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)6).value);
    }
}

