/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes;

import com.ibm.vida.rave.core.css.CSSSize;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.AbstractRenderer;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.vida.rave.render.internal.nodes.GeometricHelper;
import java.util.ArrayList;

public class EllipseSceneItem
extends AbstractSceneNode {
    protected double cx;
    protected double cy;
    protected double rx;
    protected double ry;

    public EllipseSceneItem(String nsuri, SceneNode context) {
        super(nsuri, context);
    }

    @Override
    protected RaveRect calculateBBox() {
        return new RaveRect(this.cx - this.rx, this.cy - this.ry, this.rx * 2.0, this.ry * 2.0);
    }

    public int getDrawType() {
        return 1013;
    }

    public String getName() {
        return "ellipse";
    }

    public double getCx() {
        return this.cx;
    }

    public double getCy() {
        return this.cy;
    }

    public double getRx() {
        return this.rx;
    }

    public double getRy() {
        return this.ry;
    }

    @Override
    protected boolean intersects(RectStruct rect) {
        double kappa = 0.5522848;
        double ox = this.rx * kappa;
        double oy = this.ry * kappa;
        GeometricHelper.PathHandler pathHandler = new GeometricHelper.PathHandler();
        pathHandler.moveTo(this.cx - this.rx, this.cy);
        pathHandler.bezierCurveTo(this.cx - this.rx, this.cy - oy, this.cx - ox, this.cy - this.ry, this.cx, this.cy - this.ry);
        pathHandler.bezierCurveTo(this.cx + ox, this.cy - this.ry, this.cx + this.rx, this.cy - oy, this.cx + this.rx, this.cy);
        pathHandler.bezierCurveTo(this.cx + this.rx, this.cy + oy, this.cx + ox, this.cy + this.ry, this.cx, this.cy + this.ry);
        pathHandler.bezierCurveTo(this.cx - ox, this.cy + this.ry, this.cx - this.rx, this.cy + oy, this.cx - this.rx, this.cy);
        pathHandler.closePath();
        ArrayList<GeometricHelper.PathShape> shapes = pathHandler.getShapes();
        return shapes.get(0).intersect(rect) && this.intersectsClip(rect);
    }

    @Override
    public void paint(AbstractRenderer renderer) {
        renderer.setStrokeAndFill(this);
        renderer.drawEllipse(this);
    }

    @Override
    public void doLayout() {
        this.cx = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)9).value);
        this.cy = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)10).value);
        this.rx = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)12).value);
        this.ry = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)13).value);
    }
}

