/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes;

import com.ibm.vida.rave.core.geom.Path2DHandler;
import com.ibm.vida.rave.core.geom.PointStruct;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.render.internal.nodes.path.Path2DUtil;
import java.util.ArrayList;
import java.util.List;

public final class GeometricHelper {
    public static boolean polygonIntersect(RectStruct rect, List<PointStruct> points) {
        PointStruct topLeft = new PointStruct(rect.x, rect.y);
        if (GeometricHelper.pointInPolygon(topLeft, points)) {
            return true;
        }
        if (GeometricHelper.pointInRectangle(points.get(0), rect)) {
            return true;
        }
        PointStruct topRight = new PointStruct(rect.x + rect.width, rect.y);
        PointStruct bottomRight = new PointStruct(rect.x + rect.width, rect.y + rect.height);
        PointStruct bottomLeft = new PointStruct(rect.x, rect.y + rect.height);
        PointStruct prevPoint = points.get(points.size() - 1);
        for (PointStruct curPoint : points) {
            if (GeometricHelper.linesIntersect(topLeft.x, topLeft.y, topRight.x, topRight.y, prevPoint.x, prevPoint.y, curPoint.x, curPoint.y)) {
                return true;
            }
            if (GeometricHelper.linesIntersect(topRight.x, topRight.y, bottomRight.x, bottomRight.y, prevPoint.x, prevPoint.y, curPoint.x, curPoint.y)) {
                return true;
            }
            if (GeometricHelper.linesIntersect(bottomRight.x, bottomRight.y, bottomLeft.x, bottomLeft.y, prevPoint.x, prevPoint.y, curPoint.x, curPoint.y)) {
                return true;
            }
            if (GeometricHelper.linesIntersect(bottomLeft.x, bottomLeft.y, topLeft.x, topLeft.y, prevPoint.x, prevPoint.y, curPoint.x, curPoint.y)) {
                return true;
            }
            prevPoint = curPoint;
        }
        return false;
    }

    public static boolean polylineIntersect(RectStruct rect, List<PointStruct> points) {
        if (GeometricHelper.pointInRectangle(points.get(0), rect)) {
            return true;
        }
        PointStruct topLeft = new PointStruct(rect.x, rect.y);
        PointStruct topRight = new PointStruct(rect.x + rect.width, rect.y);
        PointStruct bottomRight = new PointStruct(rect.x + rect.width, rect.y + rect.height);
        PointStruct bottomLeft = new PointStruct(rect.x, rect.y + rect.height);
        PointStruct prevPoint = points.get(points.size() - 1);
        for (PointStruct curPoint : points) {
            if (GeometricHelper.linesIntersect(topLeft.x, topLeft.y, topRight.x, topRight.y, prevPoint.x, prevPoint.y, curPoint.x, curPoint.y)) {
                return true;
            }
            if (GeometricHelper.linesIntersect(topRight.x, topRight.y, bottomRight.x, bottomRight.y, prevPoint.x, prevPoint.y, curPoint.x, curPoint.y)) {
                return true;
            }
            if (GeometricHelper.linesIntersect(bottomRight.x, bottomRight.y, bottomLeft.x, bottomLeft.y, prevPoint.x, prevPoint.y, curPoint.x, curPoint.y)) {
                return true;
            }
            if (GeometricHelper.linesIntersect(bottomLeft.x, bottomLeft.y, topLeft.x, topLeft.y, prevPoint.x, prevPoint.y, curPoint.x, curPoint.y)) {
                return true;
            }
            prevPoint = curPoint;
        }
        return false;
    }

    public static boolean pointInPolygon(PointStruct pt, List<PointStruct> points) {
        boolean isInside = false;
        PointStruct prevPoint = points.get(points.size() - 1);
        for (PointStruct curPoint : points) {
            boolean stradle;
            boolean curAbove = curPoint.y >= pt.y;
            boolean prevAbove = prevPoint.y >= pt.y;
            boolean bl = stradle = curAbove != prevAbove;
            if (stradle) {
                boolean pointLeftOfIntersect;
                double xIntersect = (prevPoint.x - curPoint.x) * (pt.y - curPoint.y) / (prevPoint.y - curPoint.y) + curPoint.x;
                boolean bl2 = pointLeftOfIntersect = pt.x <= xIntersect;
                if (pointLeftOfIntersect) {
                    isInside = !isInside;
                }
            }
            prevPoint = curPoint;
        }
        return isInside;
    }

    public static boolean pointOnPolyline(PointStruct pt, List<PointStruct> points, double tolerance) {
        PointStruct prevPoint = null;
        for (PointStruct curPoint : points) {
            if (prevPoint == null) {
                prevPoint = curPoint;
                continue;
            }
            double d = GeometricHelper.calcDistance(pt.x, pt.y, prevPoint.x, prevPoint.y, curPoint.x, curPoint.y);
            if (d <= tolerance) {
                return true;
            }
            prevPoint = curPoint;
        }
        return false;
    }

    public static boolean pointInRectangle(PointStruct pt, RectStruct rect) {
        return pt.x >= rect.x && pt.x < rect.x + rect.width && pt.y >= rect.y && pt.y < rect.y + rect.height;
    }

    public static boolean circleIntersect(double xCtr, double yCtr, double radius, RectStruct rect) {
        double yClosest;
        double dy;
        double xClosest = GeometricHelper.clamp(xCtr, rect.x, rect.x + rect.width);
        double dx = xCtr - xClosest;
        double distance_sq = dx * dx + (dy = yCtr - (yClosest = GeometricHelper.clamp(yCtr, rect.y, rect.y + rect.height))) * dy;
        return distance_sq < radius * radius;
    }

    private static double clamp(double value, double minValue, double maxValue) {
        if (value < minValue) {
            return minValue;
        }
        if (value > maxValue) {
            return maxValue;
        }
        return value;
    }

    public static double calcDistance(double x, double y, double x1, double y1, double x2, double y2) {
        double ySeg;
        double xSeg;
        double dot = (x - x1) * (x2 - x1) + (y - y1) * (y2 - y1);
        double len_sq = (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
        double u = -1.0;
        if (len_sq != 0.0) {
            u = dot / len_sq;
        }
        if (u < 0.0) {
            xSeg = x1;
            ySeg = y1;
        } else if (u > 1.0) {
            xSeg = x2;
            ySeg = y2;
        } else {
            xSeg = x1 + u * (x2 - x1);
            ySeg = y1 + u * (y2 - y1);
        }
        double dx = x - xSeg;
        double dy = y - ySeg;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static boolean linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (denom <= 1.0E-5) {
            return false;
        }
        double uA = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / denom;
        double uB = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / denom;
        return uA > 0.0 && uA < 1.0 && uB > 0.0 && uB < 1.0;
    }

    public static boolean rectIntersects(double left1, double top1, double width1, double height1, double left2, double top2, double width2, double height2) {
        double right1 = left1 + width1;
        double bottom1 = top1 + height1;
        double right2 = left2 + width2;
        double bottom2 = top2 + height2;
        return !(left1 > right2 || right1 < left2 || top1 > bottom2 || bottom1 < top2);
    }

    public static class PathHandler
    implements Path2DHandler {
        private final ArrayList<PathShape> shapes = new ArrayList();
        private int currentShape = -1;
        private PointStruct currentPoint = null;

        public void fail(int index) {
        }

        public void startPath() {
        }

        public void closePath() {
            this.shapes.get(this.currentShape).setClosed();
            this.currentPoint = null;
        }

        public void moveTo(double x, double y) {
            ++this.currentShape;
            this.shapes.add(new PathShape());
            this.currentPoint = new PointStruct(x, y);
            this.shapes.get(this.currentShape).addPoint(this.currentPoint);
        }

        public void lineTo(double x, double y) {
            this.currentPoint = new PointStruct(x, y);
            this.shapes.get(this.currentShape).addPoint(this.currentPoint);
        }

        public void quadraticCurveTo(double cpx, double cpy, double x, double y) {
            double p0x = this.currentPoint.x;
            double p0y = this.currentPoint.y;
            double p1x = cpx;
            double p1y = cpy;
            double p2x = x;
            double p2y = y;
            double dx = p2x - p0x;
            double dy = p2y - p0y;
            double delta = Math.max(Math.abs(dx), Math.abs(dy));
            int curvePointCount = (int)(delta / 2.0);
            if (curvePointCount > 1) {
                double dt;
                double t = dt = 1.0 / (double)curvePointCount;
                for (int j = 0; j < curvePointCount; ++j) {
                    double xp = (1.0 - t) * (1.0 - t) * p0x + 2.0 * (1.0 - t) * t * p1x + t * t * p2x;
                    double yp = (1.0 - t) * (1.0 - t) * p0y + 2.0 * (1.0 - t) * t * p1y + t * t * p2y;
                    this.shapes.get(this.currentShape).addPoint(new PointStruct(xp, yp));
                    t += dt;
                }
            }
            this.currentPoint = new PointStruct(x, y);
            this.shapes.get(this.currentShape).addPoint(this.currentPoint);
        }

        public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
            double p0x = this.currentPoint.x;
            double p0y = this.currentPoint.y;
            double p1x = cp1x;
            double p1y = cp1y;
            double p2x = cp2x;
            double p2y = cp2y;
            double p3x = x;
            double p3y = y;
            double dx = p3x - p0x;
            double dy = p3y - p0y;
            double delta = Math.max(Math.abs(dx), Math.abs(dy));
            int curvePointCount = (int)(delta / 2.0);
            if (curvePointCount > 1) {
                double dt;
                double t = dt = 1.0 / (double)curvePointCount;
                for (int j = 0; j < curvePointCount; ++j) {
                    double xp = (1.0 - t) * (1.0 - t) * (1.0 - t) * p0x + 3.0 * (1.0 - t) * (1.0 - t) * t * p1x + 3.0 * (1.0 - t) * (t * t) * p2x + t * t * t * p3x;
                    double yp = (1.0 - t) * (1.0 - t) * (1.0 - t) * p0y + 3.0 * (1.0 - t) * (1.0 - t) * t * p1y + 3.0 * (1.0 - t) * (t * t) * p2y + t * t * t * p3y;
                    this.shapes.get(this.currentShape).addPoint(new PointStruct(xp, yp));
                    t += dt;
                }
            }
            this.currentPoint = new PointStruct(x, y);
            this.shapes.get(this.currentShape).addPoint(this.currentPoint);
        }

        public void arcTo(double x0, double y0, double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
            Path2DUtil.arcToBezier(this, x0, y0, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y);
        }

        public ArrayList<PathShape> getShapes() {
            return this.shapes;
        }
    }

    public static class PathShape {
        public final ArrayList<PointStruct> points = new ArrayList();
        private boolean isClosed = false;
        private PointStruct[] bounds = null;
        private boolean isCollinear = true;
        private double initialSlope = 0.0;
        private boolean initialVertical = false;

        public void addPoint(PointStruct point) {
            if (this.points.size() != 0 && point.x == this.points.get((int)(this.points.size() - 1)).x && point.y == this.points.get((int)(this.points.size() - 1)).y) {
                return;
            }
            this.points.add(point);
            if (this.bounds == null) {
                this.bounds = new PointStruct[2];
                this.bounds[0] = new PointStruct(point.x, point.y);
                this.bounds[1] = new PointStruct(point.x, point.y);
            } else {
                if (point.x < this.bounds[0].x) {
                    this.bounds[0].x = point.x;
                } else if (point.x > this.bounds[1].x) {
                    this.bounds[1].x = point.x;
                }
                if (point.y < this.bounds[0].y) {
                    this.bounds[0].y = point.y;
                } else if (point.y > this.bounds[1].y) {
                    this.bounds[1].y = point.y;
                }
            }
            if (this.isCollinear && this.points.size() >= 2) {
                double slope;
                double dx = this.points.get((int)(this.points.size() - 1)).x - this.points.get((int)(this.points.size() - 2)).x;
                double dy = this.points.get((int)(this.points.size() - 1)).y - this.points.get((int)(this.points.size() - 2)).y;
                boolean isVertical = Math.abs(dy) < 1.0E-4;
                double d = slope = isVertical ? 0.0 : dx / dy;
                if (this.points.size() == 2) {
                    this.initialVertical = isVertical;
                    this.initialSlope = slope;
                } else {
                    this.isCollinear = isVertical == this.initialVertical && Math.abs(this.initialSlope - slope) < 1.0E-4;
                }
            }
        }

        public void setClosed() {
            if (!this.isCollinear) {
                this.isClosed = true;
            }
        }

        public PointStruct[] getBounds() {
            return this.bounds;
        }

        public boolean intersect(PointStruct point) {
            if (this.isClosed) {
                return GeometricHelper.pointInPolygon(point, this.points);
            }
            return GeometricHelper.pointOnPolyline(point, this.points, 5.0);
        }

        public boolean intersect(RectStruct rect) {
            if (rect.width <= 2.0 && rect.height <= 2.0) {
                return this.intersect(new PointStruct(rect.x, rect.y));
            }
            if (rect.x > this.bounds[1].x || rect.x + rect.width < this.bounds[0].x || rect.y > this.bounds[1].y || rect.y + rect.height < this.bounds[0].y) {
                return false;
            }
            if (this.isClosed) {
                return GeometricHelper.polygonIntersect(rect, this.points);
            }
            return GeometricHelper.polylineIntersect(rect, this.points);
        }
    }
}

