/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes;

import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.transform.Matrix;
import com.ibm.vida.rave.core.transform.MatrixUtil;
import com.ibm.vida.rave.render.AbstractRenderer;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;

public class GroupSceneItem
extends AbstractSceneNode {
    private boolean isolated = false;

    public GroupSceneItem(String nsuri, SceneNode context) {
        super(nsuri, context);
    }

    public String getName() {
        return "g";
    }

    public int getDrawType() {
        return 1004;
    }

    @Override
    protected boolean intersects(RectStruct rect) {
        if (this.hasChildNodes()) {
            return super.intersects(rect);
        }
        return false;
    }

    @Override
    protected RaveRect calculateBBox() {
        double y2 = 0.0;
        double x2 = 0.0;
        double y1 = 0.0;
        double x1 = 0.0;
        if (this.hasChildNodes()) {
            y1 = Double.POSITIVE_INFINITY;
            x1 = Double.POSITIVE_INFINITY;
            y2 = Double.NEGATIVE_INFINITY;
            x2 = Double.NEGATIVE_INFINITY;
            for (SceneNode child : this.getChildrenArray()) {
                RaveRect bb = child.getBBox();
                double x = bb.x;
                double y = bb.y;
                double w = bb.width;
                double h = bb.height;
                Matrix t = (Matrix)((AbstractSceneNode)child).computeStyleValue(11);
                if (t != null) {
                    RectStruct bstruct = MatrixUtil.transformBounds((RectStruct)new RectStruct(x, y, w, h), (Matrix)t);
                    x = bstruct.x;
                    y = bstruct.y;
                    w = bstruct.width;
                    h = bstruct.height;
                }
                double cx2 = x + w;
                double cy2 = y + h;
                if (x < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (cx2 > x2) {
                    x2 = cx2;
                }
                if (!(cy2 > y2)) continue;
                y2 = cy2;
            }
        }
        return new RaveRect(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public void paint(AbstractRenderer renderer) {
        this.isolated = this.isolate();
        if (this.isolated) {
            renderer.push();
        }
    }

    @Override
    public void postPaint(AbstractRenderer renderer) {
        if (this.isolated) {
            renderer.pop(this.getOpacity());
        }
    }

    @Override
    public void doLayout() {
    }

    private boolean isolate() {
        return this.getOpacity() < 1.0;
    }

    public double getOpacity() {
        Object oOpacity = this.getComputedStyleValue(30);
        return oOpacity != null ? ((Number)oOpacity).doubleValue() : 1.0;
    }
}

