/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes;

import com.ibm.vida.rave.core.css.CSSSize;
import com.ibm.vida.rave.core.geom.PointStruct;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.AbstractRenderer;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.vida.rave.render.internal.nodes.GeometricHelper;
import java.util.ArrayList;

public class LineSceneItem
extends AbstractSceneNode {
    public static final double LINE_TOUCH_DISTANCE = 5.0;
    protected double x1;
    protected double x2;
    protected double y1;
    protected double y2;

    public LineSceneItem(String nsuri, SceneNode context) {
        super(nsuri, context);
    }

    @Override
    protected RaveRect calculateBBox() {
        double tmp;
        if (this.x1 > this.x2) {
            tmp = this.x1;
            this.x1 = this.x2;
            this.x2 = tmp;
        }
        if (this.y1 > this.y2) {
            tmp = this.y1;
            this.y1 = this.y2;
            this.y2 = tmp;
        }
        return new RaveRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
    }

    public int getDrawType() {
        return 1001;
    }

    public String getName() {
        return "line";
    }

    public double getX1() {
        return this.x1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY1() {
        return this.y1;
    }

    public double getY2() {
        return this.y2;
    }

    @Override
    protected boolean intersects(RectStruct rect) {
        ArrayList<PointStruct> line = new ArrayList<PointStruct>();
        line.add(new PointStruct(this.x1, this.y1));
        line.add(new PointStruct(this.x2, this.y2));
        if (rect.width <= 2.0 && rect.height <= 2.0) {
            return GeometricHelper.pointOnPolyline(new PointStruct(rect.x, rect.y), line, 5.0);
        }
        return GeometricHelper.polylineIntersect(rect, line) && this.intersectsClip(rect);
    }

    @Override
    public void paint(AbstractRenderer renderer) {
        renderer.setStrokeAndFill(this);
        renderer.drawLine(this);
    }

    @Override
    public void doLayout() {
        this.x1 = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)4).value);
        this.x2 = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)5).value);
        this.y1 = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)7).value);
        this.y2 = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)8).value);
    }
}

