/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes;

import com.ibm.vida.rave.core.geo.DrawingContext;
import com.ibm.vida.rave.core.geo.PathGenerator;
import com.ibm.vida.rave.core.geom.Path2DHandler;
import com.ibm.vida.rave.core.geom.PointStruct;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.internal.geo.PathActionDrawingContext;
import com.ibm.vida.rave.core.internal.geo.PathActionPathGenerator;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.AbstractRenderer;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.vida.rave.render.internal.nodes.GeometricHelper;
import com.ibm.vida.rave.render.internal.nodes.path.StringPathGenerator;
import com.ibm.vida.rave.render.internal.style.RenderStyleManager;
import java.util.ArrayList;

public class PathSceneItem
extends AbstractSceneNode {
    protected PathGenerator d;
    private String pathString;

    public PathSceneItem(String nsuri, SceneNode context) {
        super(nsuri, context);
    }

    @Override
    protected RaveRect calculateBBox() {
        if (this.d == null) {
            return new RaveRect(0.0, 0.0, 0.0, 0.0);
        }
        GeometricHelper.PathHandler pathHandler = new GeometricHelper.PathHandler();
        this.d.draw((Path2DHandler)pathHandler);
        ArrayList<GeometricHelper.PathShape> shapes = pathHandler.getShapes();
        if (shapes.size() == 0) {
            return new RaveRect(0.0, 0.0, 0.0, 0.0);
        }
        PointStruct[] bounds = shapes.get(0).getBounds();
        double xMin = bounds[0].x;
        double yMin = bounds[0].y;
        double xMax = bounds[1].x;
        double yMax = bounds[1].y;
        for (int i = 1; i < shapes.size(); ++i) {
            bounds = shapes.get(i).getBounds();
            if (bounds[0].x < xMin) {
                xMin = bounds[0].x;
            }
            if (bounds[1].x > xMax) {
                xMax = bounds[1].x;
            }
            if (bounds[0].y < yMin) {
                yMin = bounds[0].y;
            }
            if (!(bounds[1].y > yMax)) continue;
            yMax = bounds[1].y;
        }
        return new RaveRect(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public int getDrawType() {
        return 1006;
    }

    public String getName() {
        return "path";
    }

    @Override
    protected boolean intersects(RectStruct rect) {
        boolean intersection = false;
        if (this.d != null) {
            GeometricHelper.PathHandler pathHandler = new GeometricHelper.PathHandler();
            this.d.draw((Path2DHandler)pathHandler);
            ArrayList<GeometricHelper.PathShape> shapes = pathHandler.getShapes();
            if (shapes.size() == 0) {
                return false;
            }
            boolean hasFill = RenderStyleManager.getFill(this) != null;
            for (GeometricHelper.PathShape shape : shapes) {
                if (hasFill) {
                    shape.setClosed();
                }
                if (!shape.intersect(rect) || !this.intersectsClip(rect)) continue;
                intersection = !intersection;
            }
        }
        return intersection;
    }

    @Override
    public void paint(AbstractRenderer renderer) {
        if (this.getPath() != null) {
            renderer.setStrokeAndFill(this);
            renderer.drawPath(this);
        }
    }

    public PathGenerator<?> getPath() {
        return this.d;
    }

    protected String getPathString() {
        return this.pathString;
    }

    @Override
    public void initExtensions() {
        super.initExtensions();
        final SceneNode.SetAttributeExtension origSetAttr = this.setAttributeExt;
        final PathSceneItem self = this;
        this.setAttributeExt = new SceneNode.SetAttributeExtension(){

            public void setAttribute(SceneNode context, String key, Object value) {
                origSetAttr.setAttribute(context, key, value);
                if (value != null && "d".equals(key)) {
                    Object internalVal = self.attributes.getByIndex(16);
                    self.pathString = null;
                    if (Lang.isString(internalVal)) {
                        self.pathString = ObjectConverter.toString(internalVal);
                        self.d = new StringPathGenerator(self.getPathString());
                    } else {
                        self.d = new PathActionPathGenerator();
                        if (internalVal instanceof PathActionDrawingContext) {
                            self.d.context((DrawingContext)internalVal);
                        }
                    }
                } else if (value != null && "points".equals(key)) {
                    Object internalVal = self.attributes.getByIndex(17);
                    self.pathString = ObjectConverter.toString(internalVal);
                    self.d = new StringPathGenerator(self.getPathString());
                }
            }
        };
    }

    @Override
    public void doLayout() {
    }
}

