/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.css.CSSSize;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.graphicUtils.TextMetrics;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.nativeImpl.graphicUtils.RenderingContext;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.render.AbstractRenderer;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.vida.rave.render.internal.nodes.TSpanSceneItem;
import com.ibm.vida.rave.render.internal.nodes.TextSceneItem;
import com.ibm.vida.rave.render.internal.style.FontStyle;
import com.ibm.vida.rave.render.internal.style.RenderStyleManager;
import com.ibm.vida.rave.render.internal.style.ShadowStyle;

public class TextPathSceneItem
extends AbstractSceneNode {
    private FontStyle styleCache;
    protected double x;
    protected double y;
    protected double width;
    protected double height;
    protected Double ascent;
    protected Double descent;
    protected double nextX;
    protected double nextY;
    private RaveRect cachedBoundingClientRectBBox;

    public TextPathSceneItem(String nsuri, SceneNode context) {
        super(nsuri, context);
    }

    public int getDrawType() {
        return 1017;
    }

    public String getName() {
        return "textPath";
    }

    @Override
    protected void notifyAfterUpdate(int type, int subType, String key, Object toValue, Object fromValue) {
        this.styleCache = null;
        super.notifyAfterUpdate(type, subType, key, toValue, fromValue);
    }

    @Override
    protected void invalidateLayout() {
        super.invalidateLayout();
        this.cachedBoundingClientRectBBox = null;
    }

    @Override
    protected RaveRect calculateBBox() {
        RectStruct clientRect = new RectStruct(this.x, this.y - this.ascent, this.width, this.height);
        if (this.hasChildNodes()) {
            for (SceneNode child : this.getChildNodes()) {
                RaveRect childRect = ((AbstractSceneNode)child).calculateBBox();
                this.expandRect(childRect, clientRect);
            }
        }
        return new RaveRect(clientRect.x, clientRect.y, clientRect.width, clientRect.height);
    }

    @Override
    public RaveRect getBoundingClientRectBBox() {
        if (this.cachedBoundingClientRectBBox == null) {
            if (this.invalidLayout) {
                this.layout();
            }
            RectStruct clientRect = new RectStruct(this.x, this.y - this.ascent, this.width, this.height);
            if (this.hasChildNodes()) {
                for (SceneNode child : this.getChildrenArray()) {
                    RaveRect childRect = ((AbstractSceneNode)child).getBoundingClientRectBBox();
                    this.expandRect(childRect, clientRect);
                }
            }
            this.cachedBoundingClientRectBBox = new RaveRect(clientRect.x, clientRect.y, clientRect.width, clientRect.height);
        }
        return this.cachedBoundingClientRectBBox;
    }

    private void expandRect(RaveRect rect1, RectStruct rect2) {
        double currentX2 = rect2.x + rect2.width;
        double currentY2 = rect2.y + rect2.height;
        double childX2 = rect1.x + rect1.width;
        double childY2 = rect1.y + rect1.height;
        rect2.x = Math.min(rect1.x, rect2.x);
        rect2.y = Math.min(rect1.y, rect2.y);
        rect2.width = Math.max(currentX2, childX2) - rect2.x;
        rect2.height = Math.max(currentY2, childY2) - rect2.y;
    }

    public FontStyle getFontStyle() {
        if (this.styleCache == null) {
            this.styleCache = RenderStyleManager.getFont(this);
        }
        return this.styleCache;
    }

    @Override
    public ShadowStyle getShadow() {
        ShadowStyle result = (ShadowStyle)this.getComputedStyleValue(46);
        if (result == null) {
            result = ShadowStyle.parse(this.getProperty("_rave_drop_shadow"));
        }
        result = result == null || "none".equals(result) ? null : result;
        return result;
    }

    public String getTextString() {
        return this.text;
    }

    public double getX() {
        return this.x;
    }

    public double getXOffset() {
        return ObjectConverter.toDouble((Object)this.getParentNode().getAttribute("x")) + ObjectConverter.toDouble((Object)this.getParentNode().getAttribute("dx"));
    }

    public double getYOffset() {
        return ObjectConverter.toDouble((Object)this.getParentNode().getAttribute("y")) + ObjectConverter.toDouble((Object)this.getParentNode().getAttribute("dy"));
    }

    public double getY() {
        return this.y;
    }

    @Override
    public double getSizePx(CSSSize size) {
        double value = 0.0;
        if (size != null) {
            value = size.value;
            switch (size.unit.type) {
                case 1: {
                    return size.value * this.getFontStyle().getSize();
                }
            }
            return super.getSizePx(size);
        }
        return value;
    }

    @Override
    public void paint(AbstractRenderer renderer) {
        if (this.text != null && this.text.length() > 0) {
            renderer.setStrokeAndFill(this);
            renderer.drawTextPath(this, this.getFilteredPath());
        }
    }

    private Selector getFilteredPath() {
        String pathID = (String)this.getAttribute("http://www.w3.org/1999/xlink:href");
        final String finalPathID = pathID.substring(1);
        Selector filteredPaths = Rave.selectAll((String)"path").filter((ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            @SwiftMethodOverload(skipParameters={1})
            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                return finalPathID.equals(context.getAttribute("id"));
            }
        });
        return filteredPaths;
    }

    @Override
    public void doLayout() {
        this.calculateDimensions();
        this.nextX = this.x + this.width;
        this.nextY = this.y;
        this.invalidLayout = false;
        if (this.hasChildNodes()) {
            for (SceneNode child : this.getChildNodes()) {
                if (!(child instanceof TSpanSceneItem)) continue;
                TSpanSceneItem achild = (TSpanSceneItem)child;
                if (achild.invalidLayout) {
                    achild.layout();
                }
                this.nextX = achild.nextX;
                this.nextY = achild.nextY;
            }
        }
    }

    @Override
    public void setDirty(boolean dirty_, boolean invalidateLayout) {
        if (dirty_ && invalidateLayout && this.hasChildNodes()) {
            for (SceneNode child : this.getChildNodes()) {
                if (!(child instanceof TSpanSceneItem)) continue;
                ((AbstractSceneNode)child).invalidateLayout();
            }
        }
        super.setDirty(dirty_, invalidateLayout);
    }

    protected void calculateDimensions() {
        this.computeStylesToRoot();
        TextMetrics metrics = this.calculateMetrics();
        this.width = metrics.width;
        double fontSize = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)22).value);
        this.ascent = metrics.actualBoundingBoxAscent;
        this.descent = metrics.actualBoundingBoxDescent;
        if (Lang.undefined() == this.ascent) {
            this.ascent = fontSize * 0.7 + fontSize * 0.1;
        }
        if (Lang.undefined() == this.descent) {
            this.descent = fontSize * 0.3;
        }
        this.height = this.ascent + this.descent;
        if (!(this.getParentNode() instanceof TextSceneItem)) {
            this.x = 0.0;
            this.y = 0.0;
        } else {
            this.x = this.calculateX();
            this.y = this.getSizePx((CSSSize)((TextSceneItem)this.getParentNode()).getComputedStyleValue(1)) + this.getSizePx((CSSSize)((TextSceneItem)this.getParentNode()).getComputedStyleValue(16));
        }
    }

    private double calculateX() {
        double parentCalculatedX = this.getSizePx((CSSSize)((TextSceneItem)this.getParentNode()).getComputedStyleValue(0));
        String anchor = (String)this.getComputedStyleValue(27);
        if ("middle".equals(anchor)) {
            parentCalculatedX -= this.width / 2.0;
        } else if ("end".equals(anchor)) {
            parentCalculatedX -= this.width;
        }
        return parentCalculatedX + this.getSizePx((CSSSize)((TextSceneItem)this.getParentNode()).getComputedStyleValue(15));
    }

    private TextMetrics calculateMetrics() {
        RenderingContext context = Rave.canvas.create(1.0, 1.0).getContext("2d", new Object[0]);
        context.font = this.getFontStyle().toString();
        TextMetrics tm = context.measureText(this.text);
        Rave.canvas.disposeContext(context);
        return tm;
    }
}

