/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes.cache;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.vida.rave.render.internal.nodes.cache.MultiSceneNodeCache;
import com.ibm.vida.rave.render.internal.nodes.cache.SingleSceneNodeCache;
import com.ibm.vida.rave.render.internal.query.SceneNodeNotificationListener;
import java.util.List;

public class SceneNodeCacheManager
implements SceneNodeNotificationListener {
    @InlineStringConstant
    private static final String ID = "id";
    private final SingleSceneNodeCache idCache = new SingleSceneNodeCache();
    private final MultiSceneNodeCache classCache = new MultiSceneNodeCache();

    public SceneNode matchId(int cacheId, String idString, SceneNode root) {
        SceneNode node;
        if (cacheId == 1000 && this.isDescendant(node = (SceneNode)this.idCache.get(idString), root)) {
            return node;
        }
        return null;
    }

    private boolean isDescendant(SceneNode node, SceneNode root) {
        if (node != null) {
            SceneNode parent = node;
            do {
                if (parent != root) continue;
                return true;
            } while ((parent = parent.getParentNode()) != null);
        }
        return false;
    }

    public List<SceneNode> matchClass(int cacheId, String className, SceneNode root) {
        ArrayEx cached;
        ArrayEx matches = null;
        if (cacheId == 1001 && (cached = (ArrayEx)this.classCache.get(className)) != null) {
            for (SceneNode node : cached) {
                if (!this.isDescendant(node, root)) continue;
                if (matches == null) {
                    matches = new ArrayEx();
                }
                matches.add((Object)node);
            }
        }
        return matches;
    }

    private void addToIDCache(SceneNode node, Object id, boolean addChildIds) {
        if (id != null) {
            this.idCache.add(ObjectConverter.toString((Object)id), node);
            if (addChildIds) {
                for (SceneNode child : node.getChildNodes()) {
                    this.addToIDCache(child, ((AbstractSceneNode)child).getId(), true);
                }
            }
        }
    }

    private void removeFromIdCache(SceneNode node, Object id, boolean removeFromChildren) {
        this.idCache.remove(ObjectConverter.toString((Object)id), node);
        if (removeFromChildren && node.hasChildNodes()) {
            for (SceneNode child : node.getChildNodes()) {
                this.removeFromIdCache(child, ((AbstractSceneNode)child).getId(), true);
            }
        }
    }

    @Override
    public void afterUpdate(int type, int subType, String key, Object newValue, Object oldValue, AbstractSceneNode node) {
        switch (type) {
            case 1000: {
                if (subType != 2000 || !ID.equals(key)) break;
                if (oldValue != null) {
                    this.removeFromIdCache(node, oldValue, false);
                }
                this.addToIDCache(node, newValue, false);
                break;
            }
            case 1001: {
                String id;
                if (subType == 2000) {
                    if (!ID.equals(key)) break;
                    this.addToIDCache(node, newValue, false);
                    break;
                }
                if (subType == 2001 || subType != 3000 || (id = node.getId()) == null) break;
                this.addToIDCache(node, id, true);
                break;
            }
            case 1002: {
                if (subType == 2000) {
                    if (!ID.equals(key)) break;
                    this.removeFromIdCache(node, oldValue, false);
                    break;
                }
                if (subType == 2001 || subType != 3000) break;
                String id = node.getId();
                this.removeFromIdCache(node, id, true);
                break;
            }
        }
    }
}

