/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.properties;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.collections.OMap;

public abstract class DynamicAttributesCollection<T> {
    protected String[] propNames;
    protected T[] propValues;
    private OMap<String, T> dynamicMap;
    protected boolean allowUnknownProperties = true;

    public final T getByIndex(int i) {
        return this.propValues[i];
    }

    public final void setPropertyValue(int index, T value) {
        this.propValues[index] = value;
    }

    public final T get(String propName) {
        int i = this.getIndex(propName);
        if (i == -1) {
            return (T)(this.allowUnknownProperties && this.dynamicMap != null ? this.dynamicMap.get((Object)propName.toLowerCase()) : null);
        }
        return this.propValues[i];
    }

    public final int put(String propName, T value) {
        int i = this.getIndex(propName);
        if (i == -1) {
            if (this.allowUnknownProperties) {
                if (this.dynamicMap == null) {
                    this.dynamicMap = new OMap();
                }
                this.dynamicMap.put((Object)propName, value);
            }
        } else {
            this.setPropertyValue(i, value);
        }
        return i;
    }

    public final int getIndex(String propName) {
        int len = this.propNames.length;
        for (int i = 0; i < len; ++i) {
            if (!this.propNames[i].equals(propName)) continue;
            return i;
        }
        return -1;
    }

    public final int size() {
        return this.propNames.length + (!this.allowUnknownProperties || this.dynamicMap == null ? 0 : this.dynamicMap.keySet().size());
    }

    public final boolean containsProperty(String propName) {
        String[] props = this.propNames;
        for (int index = 0; index < props.length; ++index) {
            if (!props[index].equals(propName)) continue;
            return true;
        }
        return this.allowUnknownProperties && this.dynamicMap != null ? this.dynamicMap.containsKey((Object)propName) : false;
    }

    private ArrayEx<String> getKeys() {
        ArrayEx result = new ArrayEx();
        for (String name : this.propNames) {
            result.add((Object)name);
        }
        if (this.dynamicMap != null) {
            for (String name : this.dynamicMap.keySet()) {
                result.add((Object)name);
            }
        }
        return result;
    }

    public String serialize() {
        StringBuilder builder = new StringBuilder();
        for (String key : this.getKeys()) {
            T val = this.get(key);
            if (val == null) continue;
            builder.append(key + "=\"" + val + "\" ");
        }
        return builder.toString().trim();
    }
}

