/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.query;

import com.ibm.vida.rave.core.internal.selector.SelectionQueryEngine;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.internal.RendererConfiguration;
import com.ibm.vida.rave.render.internal.nodes.RootProvider;
import com.ibm.vida.rave.render.internal.nodes.cache.SceneNodeCacheManager;
import com.ibm.vida.rave.render.internal.select.jsoup.select.Evaluator;
import com.ibm.vida.rave.render.internal.select.jsoup.select.JsoupSelector;
import com.ibm.vida.rave.render.internal.select.jsoup.select.QueryParser;
import java.util.ArrayList;
import java.util.List;

public class SceneNodeSelectionQueryEngine
implements SelectionQueryEngine {
    public boolean matches(SceneNode context, String selectorString) {
        Evaluator evaluator;
        if (selectorString != null && (evaluator = QueryParser.parse(selectorString)) != null) {
            return evaluator.matches(context.getOwner(), context);
        }
        return false;
    }

    public SceneNode querySelector(String match, SceneNode rootNode) {
        List<SceneNode> results;
        if (match != null && (results = this.querySelectorAll(match, rootNode)).size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public SceneNode querySelector(String match) {
        List<SceneNode> matches;
        if (match != null && (matches = this.querySelectorAll(match)) != null && matches.size() > 0) {
            return matches.get(0);
        }
        return null;
    }

    public List<SceneNode> querySelectorAll(String match) {
        return this.querySelectorAll(match, null);
    }

    public List<SceneNode> querySelectorAll(String match, SceneNode rootNode) {
        ArrayList<SceneNode> results = new ArrayList<SceneNode>();
        if (match != null) {
            SceneNodeSelectionQueryEngine.doQuerySelectorAll(results, match, rootNode, ":root".equals(match));
        }
        return results;
    }

    private static void doQuerySelectorAll(List<SceneNode> results, String match, SceneNode rootNode, boolean includeRootInResults) {
        block4: {
            block3: {
                SceneNode _rootNode = rootNode;
                if (_rootNode == null) break block3;
                RootProvider rootProvider = RendererConfiguration.INSTANCE.getRootProviderForNode(_rootNode);
                SceneNodeCacheManager cache = null;
                if (rootProvider == null) break block4;
                cache = rootProvider.getCacheManager();
                if (_rootNode == rootProvider.getRoot().getOwner()) {
                    _rootNode = rootProvider.getRoot();
                }
                for (SceneNode node : JsoupSelector.select(match, _rootNode, cache)) {
                    if (!includeRootInResults && node == _rootNode) continue;
                    results.add(node);
                }
                break block4;
            }
            List<RootProvider> providers = RendererConfiguration.INSTANCE.getRootProviders();
            for (RootProvider provider : providers) {
                SceneNodeSelectionQueryEngine.doQuerySelectorAll(results, match, provider.getRoot(), true);
            }
        }
    }
}

