/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.select.jsoup.select;

import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.internal.nodes.cache.SceneNodeCacheManager;
import com.ibm.vida.rave.render.internal.select.jsoup.select.Evaluator;
import com.ibm.vida.rave.render.internal.select.jsoup.select.NodeTraversor;
import com.ibm.vida.rave.render.internal.select.jsoup.select.NodeVisitor;
import java.util.ArrayList;
import java.util.List;

public class Collector {
    private Collector() {
    }

    public static List<SceneNode> collect(Evaluator evaluator, SceneNode root, SceneNodeCacheManager cache) {
        ArrayList<SceneNode> elements = new ArrayList<SceneNode>();
        if (evaluator != null) {
            List<SceneNode> cachedVals = evaluator.cached(cache, root);
            if (cachedVals != null) {
                for (SceneNode node : cachedVals) {
                    elements.add(node);
                }
            } else {
                new NodeTraversor(new Accumulator(root, elements, evaluator)).traverse(root);
            }
        }
        return elements;
    }

    private static class Accumulator
    implements NodeVisitor {
        private final SceneNode root;
        private final List<SceneNode> elements;
        private final Evaluator evaluator;

        Accumulator(SceneNode root, List<SceneNode> elements, Evaluator evaluator) {
            this.root = root;
            this.elements = elements;
            this.evaluator = evaluator;
        }

        @Override
        public void head(SceneNode node, int depth) {
            if (this.evaluator != null && this.evaluator.matches(this.root, node)) {
                this.elements.add(node);
            }
        }

        @Override
        public void tail(SceneNode node, int depth) {
        }
    }
}

