/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.select.jsoup.select;

import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.internal.select.jsoup.select.Evaluator;
import java.util.ArrayList;
import java.util.List;

abstract class CombiningEvaluator
extends Evaluator {
    @SwiftWeak(value=false)
    final List<Evaluator> evaluators = new ArrayList<Evaluator>();
    int num = 0;

    CombiningEvaluator(List<Evaluator> evaluators) {
        if (evaluators != null) {
            for (Evaluator evaluator : evaluators) {
                this.evaluators.add(evaluator);
            }
        }
        this.updateNumEvaluators();
    }

    Evaluator rightMostEvaluator() {
        return this.num > 0 ? this.evaluators.get(this.num - 1) : null;
    }

    void replaceRightMostEvaluator(Evaluator replacement) {
        this.evaluators.set(this.num - 1, replacement);
    }

    void updateNumEvaluators() {
        this.num = this.evaluators.size();
    }

    static final class Or
    extends CombiningEvaluator {
        Or(List<Evaluator> evaluators) {
            super(null);
            if (this.num > 1) {
                this.evaluators.add(new And(evaluators));
            } else if (evaluators != null) {
                for (Evaluator evaluator : evaluators) {
                    this.evaluators.add(evaluator);
                }
            }
            this.updateNumEvaluators();
        }

        public void add(Evaluator e) {
            this.evaluators.add(e);
            this.updateNumEvaluators();
        }

        @Override
        public boolean matches(SceneNode root, SceneNode node) {
            for (int i = 0; i < this.num; ++i) {
                Evaluator s = (Evaluator)this.evaluators.get(i);
                if (!s.matches(root, node)) continue;
                return true;
            }
            return false;
        }
    }

    static final class And
    extends CombiningEvaluator {
        And(List<Evaluator> evaluators) {
            super(evaluators);
        }

        @Override
        public boolean matches(SceneNode root, SceneNode node) {
            for (int i = 0; i < this.num; ++i) {
                Evaluator s = (Evaluator)this.evaluators.get(i);
                if (s.matches(root, node)) continue;
                return false;
            }
            return true;
        }
    }
}

