/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.select.jsoup.select;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.nativeImpl.RegExp;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.vida.rave.render.internal.nodes.cache.SceneNodeCacheManager;
import java.util.List;

public abstract class Evaluator {
    protected Evaluator() {
    }

    public abstract boolean matches(SceneNode var1, SceneNode var2);

    public List<SceneNode> cached(SceneNodeCacheManager manager, SceneNode element) {
        return null;
    }

    public static final class MatchesOwn
    extends Evaluator {
        private final RegExp pattern;

        public MatchesOwn(RegExp pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return this.pattern.test(element.getText());
        }
    }

    public static final class Matches
    extends Evaluator {
        private final RegExp pattern;

        public Matches(RegExp pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            if (this.pattern.test(element.getText())) {
                return true;
            }
            for (SceneNode child : element.getChildNodes()) {
                if (!this.matches(element, child)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class ContainsOwnText
    extends Evaluator {
        private final String searchText;

        public ContainsOwnText(String searchText) {
            this.searchText = searchText.toLowerCase();
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return element.getText().toLowerCase().contains(this.searchText);
        }
    }

    public static final class ContainsText
    extends Evaluator {
        private final String searchText;

        public ContainsText(String searchText) {
            this.searchText = searchText.toLowerCase();
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            if (root == element) {
                return false;
            }
            if (element.getText().toLowerCase().contains(this.searchText)) {
                return true;
            }
            for (SceneNode child : element.getChildNodes()) {
                if (!this.matches(element, child)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class IsEmpty
    extends Evaluator {
        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return !element.hasChildNodes();
        }
    }

    public static final class IsOnlyOfType
    extends Evaluator {
        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            SceneNode p = element.getParentNode();
            if (p == null) {
                return false;
            }
            int pos = 0;
            List family = p.getChildNodes();
            for (int i = 0; i < family.size(); ++i) {
                if (!((SceneNode)family.get(i)).getName().equals(element.getName())) continue;
                ++pos;
            }
            return pos == 1;
        }
    }

    public static final class IsOnlyChild
    extends Evaluator {
        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            SceneNode p = element.getParentNode();
            return p != null && element.getPreviousSibling() == null && element.getNextSibling() == null;
        }
    }

    public static final class IsRoot
    extends Evaluator {
        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return element.getParentNode() == null;
        }
    }

    public static final class IsFirstChild
    extends Evaluator {
        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            SceneNode p = element.getParentNode();
            return p != null && ((AbstractSceneNode)element).getSiblingIndex() == 0;
        }
    }

    public static final class IsNthLastChild
    extends CssNthEvaluator {
        public IsNthLastChild(int a, int b) {
            super(a, b);
        }

        @Override
        protected int calculatePosition(SceneNode root, SceneNode element) {
            return element.getParentNode().getChildNodes().size() - ((AbstractSceneNode)element).getSiblingIndex();
        }
    }

    public static final class IsNthChild
    extends CssNthEvaluator {
        public IsNthChild(int a, int b) {
            super(a, b);
        }

        @Override
        protected int calculatePosition(SceneNode root, SceneNode element) {
            return ((AbstractSceneNode)element).getSiblingIndex() + 1;
        }
    }

    public static class IsNthOfType
    extends CssNthEvaluator {
        public IsNthOfType(int a, int b) {
            super(a, b);
        }

        @Override
        protected int calculatePosition(SceneNode root, SceneNode element) {
            int pos = 0;
            List family = element.getParentNode().getChildNodes();
            for (int i = 0; i < family.size(); ++i) {
                if (((SceneNode)family.get(i)).getName().equals(element.getName())) {
                    ++pos;
                }
                if (family.get(i) == element) break;
            }
            return pos;
        }
    }

    public static class IsNthLastOfType
    extends CssNthEvaluator {
        public IsNthLastOfType(int a, int b) {
            super(a, b);
        }

        @Override
        protected int calculatePosition(SceneNode root, SceneNode element) {
            int pos = 0;
            List family = element.getParentNode().getChildNodes();
            for (int i = ((AbstractSceneNode)element).getSiblingIndex(); i < family.size(); ++i) {
                if (!((SceneNode)family.get(i)).getName().equals(element.getName())) continue;
                ++pos;
            }
            return pos;
        }
    }

    public static abstract class CssNthEvaluator
    extends Evaluator {
        protected final int a;
        protected final int b;

        public CssNthEvaluator(int a, int b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            SceneNode p = element.getParentNode();
            if (p == null) {
                return false;
            }
            int pos = this.calculatePosition(root, element);
            if (this.a == 0) {
                return pos == this.b;
            }
            return (pos - this.b) * this.a >= 0 && (pos - this.b) % this.a == 0;
        }

        protected abstract int calculatePosition(SceneNode var1, SceneNode var2);
    }

    public static final class IsLastChild
    extends Evaluator {
        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            SceneNode p = element.getParentNode();
            return element != root && p != null && ((AbstractSceneNode)element).getSiblingIndex() == p.getChildNodes().size() - 1;
        }
    }

    public static final class IndexEquals
    extends IndexEvaluator {
        public IndexEquals(int index) {
            super(index);
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return ((AbstractSceneNode)element).getSiblingIndex() == this.index;
        }
    }

    public static final class IndexGreaterThan
    extends IndexEvaluator {
        public IndexGreaterThan(int index) {
            super(index);
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return ((AbstractSceneNode)element).getSiblingIndex() > this.index;
        }
    }

    public static final class IndexLessThan
    extends IndexEvaluator {
        public IndexLessThan(int index) {
            super(index);
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return ((AbstractSceneNode)element).getSiblingIndex() < this.index;
        }
    }

    public static abstract class IndexEvaluator
    extends Evaluator {
        int index;

        public IndexEvaluator(int index) {
            this.index = index;
        }
    }

    public static final class AllElements
    extends Evaluator {
        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return element != root;
        }
    }

    public static final class AttributeWithValueMatching
    extends Evaluator {
        String key;
        RegExp pattern;

        public AttributeWithValueMatching(String key, RegExp pattern) {
            this.key = key.trim().toLowerCase();
            this.pattern = pattern;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return element.getAttribute(this.key) != null && this.pattern.test(ObjectConverter.toString((Object)element.getAttribute(this.key)));
        }
    }

    public static final class AttributeWithValueContaining
    extends AttributeKeyPair {
        public AttributeWithValueContaining(String key, String value) {
            super(key, value);
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            Object attributeValue = element.getAttribute(this.key);
            if (attributeValue == null) {
                return false;
            }
            String elementValue = ObjectConverter.toString((Object)attributeValue);
            return elementValue.contains(this.value);
        }
    }

    public static final class AttributeWithValueEnding
    extends AttributeKeyPair {
        public AttributeWithValueEnding(String key, String value) {
            super(key, value);
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            Object attributeVal = element.getAttribute(this.key);
            if (attributeVal == null) {
                return false;
            }
            String elementValue = ObjectConverter.toString((Object)attributeVal);
            return elementValue.matches(".*" + this.value + "$");
        }
    }

    public static final class AttributeWithValueStarting
    extends AttributeKeyPair {
        public AttributeWithValueStarting(String key, String value) {
            super(key, value);
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            Object attributeValue = element.getAttribute(this.key);
            if (attributeValue == null) {
                return false;
            }
            String elementValue = ObjectConverter.toString((Object)attributeValue);
            return elementValue.matches("^" + this.value + ".*");
        }
    }

    public static final class AttributeWithValueNot
    extends AttributeKeyPair {
        public AttributeWithValueNot(String key, String value) {
            super(key, value);
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            Object val = element.getAttribute(this.key);
            String attributeValue = val == null ? "" : ObjectConverter.toString((Object)element.getAttribute(this.key));
            return !this.value.toUpperCase().equals(attributeValue.toUpperCase());
        }
    }

    public static final class AttributeWithValue
    extends AttributeKeyPair {
        public AttributeWithValue(String key, String value) {
            super(key, value);
        }

        @Override
        public List<SceneNode> cached(SceneNodeCacheManager cache, SceneNode root) {
            if (cache == null) {
                return null;
            }
            if (this.isIdKey) {
                SceneNode cached = cache.matchId(1000, this.value, root);
                return cached == null ? null : new ArrayEx((Object[])new SceneNode[]{cached});
            }
            if (this.isClassKey) {
                return cache.matchClass(1001, this.value, root);
            }
            return null;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            if (root == element) {
                return false;
            }
            if (this.isIdKey) {
                return this.value.equals(((AbstractSceneNode)element).getId());
            }
            Object val = element.getAttribute(this.key);
            String attributeValue = val == null ? "" : ObjectConverter.toString((Object)element.getAttribute(this.key));
            return this.value.toUpperCase().equals(attributeValue.toUpperCase());
        }
    }

    public static final class Attribute
    extends AttributeKeyPair {
        public Attribute(String key) {
            super(key, null);
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            if (root == element) {
                return false;
            }
            if (this.isIdKey) {
                return ((AbstractSceneNode)element).getId() != null;
            }
            return element.getAttribute(this.key) != null;
        }

        @Override
        public List<SceneNode> cached(SceneNodeCacheManager node, SceneNode root) {
            return null;
        }
    }

    public static abstract class AttributeKeyPair
    extends Evaluator {
        protected String key;
        protected String value;
        protected boolean isIdKey;
        protected boolean isClassKey;

        public AttributeKeyPair(String key, String value) {
            String _value = value;
            this.key = key.trim().toLowerCase();
            if (_value != null) {
                if (_value.matches("^[\"'].*") && _value.matches(".*[\"']$")) {
                    _value = _value.substring(1, _value.length() - 1);
                }
                this.value = _value.trim();
            }
            if (this.key.equals("id")) {
                this.isIdKey = true;
            } else if (this.key.equals("class")) {
                this.isClassKey = true;
            }
        }

        @Override
        public List<SceneNode> cached(SceneNodeCacheManager node, SceneNode root) {
            return null;
        }
    }

    public static final class Class
    extends Evaluator {
        private final String className;

        public Class(String className) {
            this.className = className;
        }

        @Override
        public List<SceneNode> cached(SceneNodeCacheManager cache, SceneNode root) {
            return null;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return ((AbstractSceneNode)element).getClassList().contains(this.className);
        }
    }

    public static final class Id
    extends Evaluator {
        private final String id;

        public Id(String id) {
            this.id = id;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return this.id.equals(((AbstractSceneNode)element).getId());
        }

        @Override
        public List<SceneNode> cached(SceneNodeCacheManager cache, SceneNode root) {
            if (cache == null) {
                return null;
            }
            SceneNode cached = cache.matchId(1000, this.id, root);
            return cached == null ? null : new ArrayEx((Object[])new SceneNode[]{cached});
        }
    }

    public static final class Tag
    extends Evaluator {
        private final String tagName;

        public Tag(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            if (root == element) {
                return false;
            }
            return element.getName().equals(this.tagName);
        }
    }
}

