/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.select.jsoup.select;

import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.internal.select.jsoup.select.Collector;
import com.ibm.vida.rave.render.internal.select.jsoup.select.Evaluator;

abstract class StructuralEvaluator
extends Evaluator {
    @SwiftWeak(value=false)
    Evaluator evaluator;

    StructuralEvaluator() {
    }

    static class ImmediatePreviousSibling
    extends StructuralEvaluator {
        public ImmediatePreviousSibling(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            if (root == element) {
                return false;
            }
            SceneNode prev = element.getPreviousSibling();
            return prev != null && this.evaluator.matches(root, prev);
        }
    }

    static class PreviousSibling
    extends StructuralEvaluator {
        public PreviousSibling(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            if (root == element) {
                return false;
            }
            for (SceneNode prev = element.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
                if (!this.evaluator.matches(root, prev)) continue;
                return true;
            }
            return false;
        }
    }

    static class ImmediateParent
    extends StructuralEvaluator {
        public ImmediateParent(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            if (root == element) {
                return false;
            }
            SceneNode parent = element.getParentNode();
            return parent != null && this.evaluator.matches(root, parent);
        }
    }

    static class Parent
    extends StructuralEvaluator {
        public Parent(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            if (root == element) {
                return false;
            }
            for (SceneNode parent = element.getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!this.evaluator.matches(root, parent)) continue;
                return true;
            }
            return false;
        }
    }

    static class Not
    extends StructuralEvaluator {
        public Not(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode node) {
            return !this.evaluator.matches(root, node);
        }
    }

    static class Has
    extends StructuralEvaluator {
        public Has(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            for (SceneNode e : Collector.collect(new Evaluator.AllElements(), element, null)) {
                if (e == element || !this.evaluator.matches(root, e)) continue;
                return true;
            }
            return false;
        }
    }

    static class Root
    extends Evaluator {
        Root() {
        }

        @Override
        public boolean matches(SceneNode root, SceneNode element) {
            return root == element;
        }
    }
}

