/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.style;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.css.CSSSize;
import com.ibm.vida.rave.core.css.CSSUnit;
import com.ibm.vida.rave.core.internal.css.CSSUtil;
import com.ibm.vida.rave.render.internal.style.ShorthandStyle;
import java.util.ArrayList;
import java.util.List;

public final class FontStyle
extends ShorthandStyle {
    private final List<Object> values = new ArrayList<Object>();
    private static final List<String> keys = new ArrayEx((Object[])new String[]{"font-style", "font-size", "font-family", "font-weight", "font-variant", "line-height"});
    private final String style;
    private final CSSSize size;
    private final String family;
    private final String lineHeight;
    private final String weight;
    private final String variant;

    public FontStyle(String style, String family, CSSSize size, String weight, String lineHeight, String variant) {
        String _style = style;
        String _family = CSSUtil.parseFontFamily((Object)family);
        String _variant = variant;
        if (_style == null) {
            _style = "";
        }
        this.values.add(_style);
        this.style = _style;
        this.values.add(size);
        this.size = size;
        if (_family == null) {
            _family = "";
        }
        this.values.add(_family);
        this.family = _family;
        this.weight = weight;
        this.values.add(this.getWeight());
        if (_variant == null) {
            _variant = "";
        }
        this.values.add(_variant);
        this.variant = _variant;
        this.values.add(lineHeight);
        this.lineHeight = lineHeight;
    }

    public static FontStyle parseFont(Object value) {
        String[] parsed = CSSUtil.parseFont((Object)value);
        CSSSize _size = CSSUtil.parseSize((Object)parsed[3]);
        String _weight = CSSUtil.parseWeight((Object)parsed[2]);
        String _family = parsed[5];
        if (_size == null || _family == null || _weight == null) {
            return null;
        }
        return new FontStyle(parsed[0], _family, _size, _weight, parsed[4], parsed[1]);
    }

    public final String getStyle() {
        return this.style;
    }

    public final double getSize() {
        return this.size.value;
    }

    public final CSSUnit getUnit() {
        return this.size.unit;
    }

    public final CSSSize getCSSSize() {
        return this.size;
    }

    public final String getFamily() {
        return this.family;
    }

    public final String getWeight() {
        return this.weight;
    }

    private String getLineHeightAsString() {
        if (this.lineHeight == null) {
            return "normal";
        }
        return this.lineHeight;
    }

    public String getFontVariant() {
        return this.variant;
    }

    public String toString() {
        String str = this.style + " " + this.variant + " " + this.getWeight() + " " + (int)this.getSize() + this.getUnit() + "/" + this.getLineHeightAsString() + " " + this.family;
        return str.trim();
    }

    @Override
    public List<String> getKeys() {
        return keys;
    }

    @Override
    public Object getValue(String key) {
        int i = keys.indexOf(key);
        if (i > -1) {
            return this.values.get(i);
        }
        return null;
    }
}

