/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.style;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.color.RGB;

public class GradientStop {
    private double offset;
    private final RGB color;
    private final double opacity;

    GradientStop(double offset, RGB color, double opacity) {
        this.offset = this.fix(offset);
        this.color = color;
        this.opacity = this.fix(opacity);
    }

    public RGB calculateColor() {
        double opacity = this.color.getA() * this.getOpacity();
        return Rave.rgb((Object)("rgba(" + this.color.getR() + "," + this.color.getG() + "," + this.color.getB() + "," + opacity + ")"));
    }

    private double fix(double number) {
        return Math.min(Math.max(number, 0.0), 1.0);
    }

    public final double getOffset() {
        return this.offset;
    }

    public final void setOffset(double offset) {
        this.offset = this.fix(offset);
    }

    public final double getOpacity() {
        return this.opacity;
    }
}

